/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.ConstructorAccessorImpl;
import jdk.internal.reflect.DelegatingConstructorAccessorImpl;
import jdk.internal.reflect.MethodAccessorGenerator;
import jdk.internal.reflect.ReflectionFactory;

class NativeConstructorAccessorImpl
extends ConstructorAccessorImpl {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long GENERATED_OFFSET = U.objectFieldOffset(NativeConstructorAccessorImpl.class, "generated");
    private final Constructor<?> c;
    private DelegatingConstructorAccessorImpl parent;
    private int numInvocations;
    private volatile int generated;

    NativeConstructorAccessorImpl(Constructor<?> c) {
        this.c = c;
    }

    @Override
    public Object newInstance(Object[] args) throws InstantiationException, IllegalArgumentException, InvocationTargetException {
        if (++this.numInvocations > ReflectionFactory.inflationThreshold() && !this.c.getDeclaringClass().isHidden() && this.generated == 0 && U.compareAndSetInt(this, GENERATED_OFFSET, 0, 1)) {
            try {
                ConstructorAccessorImpl acc = (ConstructorAccessorImpl)new MethodAccessorGenerator().generateConstructor(this.c.getDeclaringClass(), this.c.getParameterTypes(), this.c.getExceptionTypes(), this.c.getModifiers());
                this.parent.setDelegate(acc);
            }
            catch (Throwable t) {
                this.generated = 0;
                throw t;
            }
        }
        return NativeConstructorAccessorImpl.newInstance0(this.c, args);
    }

    void setParent(DelegatingConstructorAccessorImpl parent) {
        this.parent = parent;
    }

    private static native Object newInstance0(Constructor<?> var0, Object[] var1) throws InstantiationException, IllegalArgumentException, InvocationTargetException;
}

