/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.DelegatingMethodAccessorImpl;
import jdk.internal.reflect.MethodAccessorGenerator;
import jdk.internal.reflect.MethodAccessorImpl;
import jdk.internal.reflect.ReflectionFactory;

class NativeMethodAccessorImpl
extends MethodAccessorImpl {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long GENERATED_OFFSET = U.objectFieldOffset(NativeMethodAccessorImpl.class, "generated");
    private final Method method;
    private DelegatingMethodAccessorImpl parent;
    private int numInvocations;
    private volatile int generated;

    NativeMethodAccessorImpl(Method method) {
        this.method = method;
    }

    @Override
    public Object invoke(Object obj, Object[] args) throws IllegalArgumentException, InvocationTargetException {
        if (++this.numInvocations > ReflectionFactory.inflationThreshold() && !this.method.getDeclaringClass().isHidden() && this.generated == 0 && U.compareAndSetInt(this, GENERATED_OFFSET, 0, 1)) {
            try {
                MethodAccessorImpl acc = (MethodAccessorImpl)new MethodAccessorGenerator().generateMethod(this.method.getDeclaringClass(), this.method.getName(), this.method.getParameterTypes(), this.method.getReturnType(), this.method.getExceptionTypes(), this.method.getModifiers());
                this.parent.setDelegate(acc);
            }
            catch (Throwable t) {
                this.generated = 0;
                throw t;
            }
        }
        return NativeMethodAccessorImpl.invoke0(this.method, obj, args);
    }

    void setParent(DelegatingMethodAccessorImpl parent) {
        this.parent = parent;
    }

    private static native Object invoke0(Method var0, Object var1, Object[] var2);
}

