/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.Properties;
import jdk.internal.access.JavaLangReflectAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.reflect.BootstrapConstructorAccessorImpl;
import jdk.internal.reflect.ConstructorAccessor;
import jdk.internal.reflect.ConstructorAccessorImpl;
import jdk.internal.reflect.DelegatingConstructorAccessorImpl;
import jdk.internal.reflect.DelegatingMethodAccessorImpl;
import jdk.internal.reflect.FieldAccessor;
import jdk.internal.reflect.InstantiationExceptionConstructorAccessorImpl;
import jdk.internal.reflect.MethodAccessor;
import jdk.internal.reflect.MethodAccessorGenerator;
import jdk.internal.reflect.NativeConstructorAccessorImpl;
import jdk.internal.reflect.NativeMethodAccessorImpl;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.SerializationConstructorAccessorImpl;
import jdk.internal.reflect.UnsafeFieldAccessorFactory;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class ReflectionFactory {
    private static boolean initted = false;
    private static final ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile Method hasStaticInitializerMethod;
    private static boolean noInflation;
    private static int inflationThreshold;
    private static boolean disableSerialConstructorChecks;
    private final JavaLangReflectAccess langReflectAccess = SharedSecrets.getJavaLangReflectAccess();

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.REFLECTION_FACTORY_ACCESS_PERMISSION);
        }
        return soleInstance;
    }

    private static Method findMethodForReflection(Method method) {
        String altName = "reflected$" + method.getName();
        try {
            return method.getDeclaringClass().getDeclaredMethod(altName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public FieldAccessor newFieldAccessor(Field field, boolean override) {
        boolean isFinal;
        ReflectionFactory.checkInitted();
        Field root = this.langReflectAccess.getRoot(field);
        if (!(root == null || root.getModifiers() != field.getModifiers() && override)) {
            field = root;
        }
        boolean isReadOnly = (isFinal = Modifier.isFinal(field.getModifiers())) && (!override || this.langReflectAccess.isTrustedFinalField(field));
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, isReadOnly);
    }

    public MethodAccessor newMethodAccessor(Method method) {
        Method root;
        Method altMethod;
        ReflectionFactory.checkInitted();
        if (Reflection.isCallerSensitive(method) && (altMethod = ReflectionFactory.findMethodForReflection(method)) != null) {
            method = altMethod;
        }
        if ((root = this.langReflectAccess.getRoot(method)) != null) {
            method = root;
        }
        if (noInflation && !method.getDeclaringClass().isHidden()) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl acc = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl res = new DelegatingMethodAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor<?> c) {
        ReflectionFactory.checkInitted();
        Class<?> declaringClass = c.getDeclaringClass();
        if (Modifier.isAbstract(declaringClass.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (declaringClass == Class.class) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        Constructor<?> root = this.langReflectAccess.getRoot(c);
        if (root != null) {
            c = root;
        }
        if (Reflection.isSubclassOf(declaringClass, ConstructorAccessorImpl.class)) {
            return new BootstrapConstructorAccessorImpl(c);
        }
        if (noInflation && !c.getDeclaringClass().isHidden()) {
            return new MethodAccessorGenerator().generateConstructor(c.getDeclaringClass(), c.getParameterTypes(), c.getExceptionTypes(), c.getModifiers());
        }
        NativeConstructorAccessorImpl acc = new NativeConstructorAccessorImpl(c);
        DelegatingConstructorAccessorImpl res = new DelegatingConstructorAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public Constructor<?> newConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations) {
        return this.langReflectAccess.newConstructor(declaringClass, parameterTypes, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor<?> c) {
        return this.langReflectAccess.getConstructorAccessor(c);
    }

    public void setConstructorAccessor(Constructor<?> c, ConstructorAccessor accessor) {
        this.langReflectAccess.setConstructorAccessor(c, accessor);
    }

    public Method copyMethod(Method arg) {
        return this.langReflectAccess.copyMethod(arg);
    }

    public Method leafCopyMethod(Method arg) {
        return this.langReflectAccess.leafCopyMethod(arg);
    }

    public Field copyField(Field arg) {
        return this.langReflectAccess.copyField(arg);
    }

    public <T> Constructor<T> copyConstructor(Constructor<T> arg) {
        return this.langReflectAccess.copyConstructor(arg);
    }

    public byte[] getExecutableTypeAnnotationBytes(Executable ex) {
        return this.langReflectAccess.getExecutableTypeAnnotationBytes(ex);
    }

    public Class<?>[] getExecutableSharedParameterTypes(Executable ex) {
        return this.langReflectAccess.getExecutableSharedParameterTypes(ex);
    }

    public <T> T newInstance(Constructor<T> ctor, Object[] args, Class<?> caller) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.langReflectAccess.newInstance(ctor, args, caller);
    }

    public final Constructor<?> newConstructorForExternalization(Class<?> cl) {
        if (!Externalizable.class.isAssignableFrom(cl)) {
            return null;
        }
        try {
            Constructor<?> cons = cl.getConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public final Constructor<?> newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall) {
        if (constructorToCall.getDeclaringClass() == cl) {
            constructorToCall.setAccessible(true);
            return constructorToCall;
        }
        return this.generateConstructor(cl, constructorToCall);
    }

    private boolean superHasAccessibleConstructor(Class<?> cl) {
        Class<?> superCl = cl.getSuperclass();
        assert (Serializable.class.isAssignableFrom(cl));
        assert (superCl != null);
        if (ReflectionFactory.packageEquals(cl, superCl)) {
            for (Constructor<?> ctor : superCl.getDeclaredConstructors()) {
                if ((ctor.getModifiers() & 2) != 0) continue;
                return true;
            }
            return Reflection.areNestMates(cl, superCl);
        }
        if ((superCl.getModifiers() & 5) == 0) {
            return false;
        }
        for (Constructor<?> ctor : superCl.getDeclaredConstructors()) {
            if ((ctor.getModifiers() & 5) == 0) continue;
            return true;
        }
        return false;
    }

    public final Constructor<?> newConstructorForSerialization(Class<?> cl) {
        Constructor<?> constructorToCall;
        Class<?> initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            Class<?> prev = initCl;
            if ((initCl = initCl.getSuperclass()) != null && (disableSerialConstructorChecks || this.superHasAccessibleConstructor(prev))) continue;
            return null;
        }
        try {
            constructorToCall = initCl.getDeclaredConstructor(new Class[0]);
            int mods = constructorToCall.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ReflectionFactory.packageEquals(cl, initCl)) {
                return null;
            }
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        return this.generateConstructor(cl, constructorToCall);
    }

    private final Constructor<?> generateConstructor(Class<?> cl, Constructor<?> constructorToCall) {
        SerializationConstructorAccessorImpl acc = new MethodAccessorGenerator().generateSerializationConstructor(cl, constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), constructorToCall.getDeclaringClass());
        Constructor<?> c = this.newConstructor(constructorToCall.getDeclaringClass(), constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), this.langReflectAccess.getConstructorSlot(constructorToCall), this.langReflectAccess.getConstructorSignature(constructorToCall), this.langReflectAccess.getConstructorAnnotations(constructorToCall), this.langReflectAccess.getConstructorParameterAnnotations(constructorToCall));
        this.setConstructorAccessor(c, acc);
        c.setAccessible(true);
        return c;
    }

    public final MethodHandle readObjectForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "readObject", ObjectInputStream.class);
    }

    public final MethodHandle readObjectNoDataForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "readObjectNoData", ObjectInputStream.class);
    }

    public final MethodHandle writeObjectForSerialization(Class<?> cl) {
        return this.findReadWriteObjectForSerialization(cl, "writeObject", ObjectOutputStream.class);
    }

    private final MethodHandle findReadWriteObjectForSerialization(Class<?> cl, String methodName, Class<?> streamClass) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        try {
            Method meth = cl.getDeclaredMethod(methodName, streamClass);
            int mods = meth.getModifiers();
            if (meth.getReturnType() != Void.TYPE || Modifier.isStatic(mods) || !Modifier.isPrivate(mods)) {
                return null;
            }
            meth.setAccessible(true);
            return MethodHandles.lookup().unreflect(meth);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException ex1) {
            throw new InternalError("Error", ex1);
        }
    }

    public final MethodHandle writeReplaceForSerialization(Class<?> cl) {
        return this.getReplaceResolveForSerialization(cl, "writeReplace");
    }

    public final MethodHandle readResolveForSerialization(Class<?> cl) {
        return this.getReplaceResolveForSerialization(cl, "readResolve");
    }

    private MethodHandle getReplaceResolveForSerialization(Class<?> cl, String methodName) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        for (Class<?> defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                Method m = defCl.getDeclaredMethod(methodName, new Class[0]);
                if (m.getReturnType() != Object.class) {
                    return null;
                }
                int mods = m.getModifiers();
                if (Modifier.isStatic(mods) | Modifier.isAbstract(mods)) {
                    return null;
                }
                if (!(Modifier.isPublic(mods) | Modifier.isProtected(mods))) {
                    if (Modifier.isPrivate(mods) && cl != defCl) {
                        return null;
                    }
                    if (!ReflectionFactory.packageEquals(cl, defCl)) {
                        return null;
                    }
                }
                try {
                    m.setAccessible(true);
                    return MethodHandles.lookup().unreflect(m);
                }
                catch (IllegalAccessException ex0) {
                    throw new InternalError("Error", ex0);
                }
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        return null;
    }

    public final boolean hasStaticInitializerForSerialization(Class<?> cl) {
        Method m = hasStaticInitializerMethod;
        if (m == null) {
            try {
                m = ObjectStreamClass.class.getDeclaredMethod("hasStaticInitializer", Class.class);
                m.setAccessible(true);
                hasStaticInitializerMethod = m;
            }
            catch (NoSuchMethodException ex) {
                throw new InternalError("No such method hasStaticInitializer on " + ObjectStreamClass.class, ex);
            }
        }
        try {
            return (Boolean)m.invoke(null, cl);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new InternalError("Exception invoking hasStaticInitializer", ex);
        }
    }

    public final Constructor<OptionalDataException> newOptionalDataExceptionForSerialization() {
        try {
            Constructor<OptionalDataException> boolCtor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
            boolCtor.setAccessible(true);
            return boolCtor;
        }
        catch (NoSuchMethodException ex) {
            throw new InternalError("Constructor not found", ex);
        }
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        if (!VM.isModuleSystemInited()) {
            return;
        }
        Properties props = GetPropertyAction.privilegedGetProperties();
        String val = props.getProperty("sun.reflect.noInflation");
        if (val != null && val.equals("true")) {
            noInflation = true;
        }
        if ((val = props.getProperty("sun.reflect.inflationThreshold")) != null) {
            try {
                inflationThreshold = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to parse property sun.reflect.inflationThreshold", e);
            }
        }
        disableSerialConstructorChecks = "true".equals(props.getProperty("jdk.disableSerialConstructorChecks"));
        initted = true;
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        assert (!cl1.isArray() && !cl2.isArray());
        if (cl1 == cl2) {
            return true;
        }
        return cl1.getClassLoader() == cl2.getClassLoader() && cl1.getPackageName() == cl2.getPackageName();
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
        disableSerialConstructorChecks = false;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction<ReflectionFactory> {
        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

