/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.reflect.FieldAccessor;
import jdk.internal.reflect.UnsafeBooleanFieldAccessorImpl;
import jdk.internal.reflect.UnsafeByteFieldAccessorImpl;
import jdk.internal.reflect.UnsafeCharacterFieldAccessorImpl;
import jdk.internal.reflect.UnsafeDoubleFieldAccessorImpl;
import jdk.internal.reflect.UnsafeFieldAccessorImpl;
import jdk.internal.reflect.UnsafeFloatFieldAccessorImpl;
import jdk.internal.reflect.UnsafeIntegerFieldAccessorImpl;
import jdk.internal.reflect.UnsafeLongFieldAccessorImpl;
import jdk.internal.reflect.UnsafeObjectFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedBooleanFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedByteFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedCharacterFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedDoubleFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedFloatFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedIntegerFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedLongFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedObjectFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedShortFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticBooleanFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticByteFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticCharacterFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticDoubleFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticFloatFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticIntegerFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticLongFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticObjectFieldAccessorImpl;
import jdk.internal.reflect.UnsafeQualifiedStaticShortFieldAccessorImpl;
import jdk.internal.reflect.UnsafeShortFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticBooleanFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticByteFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticCharacterFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticDoubleFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticFloatFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticIntegerFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticLongFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticObjectFieldAccessorImpl;
import jdk.internal.reflect.UnsafeStaticShortFieldAccessorImpl;

class UnsafeFieldAccessorFactory {
    UnsafeFieldAccessorFactory() {
    }

    static FieldAccessor newFieldAccessor(Field field, boolean isReadOnly) {
        boolean isQualified;
        Class<?> type = field.getType();
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        boolean isFinal = Modifier.isFinal(field.getModifiers());
        boolean isVolatile = Modifier.isVolatile(field.getModifiers());
        boolean bl = isQualified = isFinal || isVolatile;
        if (isStatic) {
            UnsafeFieldAccessorImpl.unsafe.ensureClassInitialized(field.getDeclaringClass());
            if (!isQualified) {
                if (type == Boolean.TYPE) {
                    return new UnsafeStaticBooleanFieldAccessorImpl(field);
                }
                if (type == Byte.TYPE) {
                    return new UnsafeStaticByteFieldAccessorImpl(field);
                }
                if (type == Short.TYPE) {
                    return new UnsafeStaticShortFieldAccessorImpl(field);
                }
                if (type == Character.TYPE) {
                    return new UnsafeStaticCharacterFieldAccessorImpl(field);
                }
                if (type == Integer.TYPE) {
                    return new UnsafeStaticIntegerFieldAccessorImpl(field);
                }
                if (type == Long.TYPE) {
                    return new UnsafeStaticLongFieldAccessorImpl(field);
                }
                if (type == Float.TYPE) {
                    return new UnsafeStaticFloatFieldAccessorImpl(field);
                }
                if (type == Double.TYPE) {
                    return new UnsafeStaticDoubleFieldAccessorImpl(field);
                }
                return new UnsafeStaticObjectFieldAccessorImpl(field);
            }
            if (type == Boolean.TYPE) {
                return new UnsafeQualifiedStaticBooleanFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Byte.TYPE) {
                return new UnsafeQualifiedStaticByteFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Short.TYPE) {
                return new UnsafeQualifiedStaticShortFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Character.TYPE) {
                return new UnsafeQualifiedStaticCharacterFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Integer.TYPE) {
                return new UnsafeQualifiedStaticIntegerFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Long.TYPE) {
                return new UnsafeQualifiedStaticLongFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Float.TYPE) {
                return new UnsafeQualifiedStaticFloatFieldAccessorImpl(field, isReadOnly);
            }
            if (type == Double.TYPE) {
                return new UnsafeQualifiedStaticDoubleFieldAccessorImpl(field, isReadOnly);
            }
            return new UnsafeQualifiedStaticObjectFieldAccessorImpl(field, isReadOnly);
        }
        if (!isQualified) {
            if (type == Boolean.TYPE) {
                return new UnsafeBooleanFieldAccessorImpl(field);
            }
            if (type == Byte.TYPE) {
                return new UnsafeByteFieldAccessorImpl(field);
            }
            if (type == Short.TYPE) {
                return new UnsafeShortFieldAccessorImpl(field);
            }
            if (type == Character.TYPE) {
                return new UnsafeCharacterFieldAccessorImpl(field);
            }
            if (type == Integer.TYPE) {
                return new UnsafeIntegerFieldAccessorImpl(field);
            }
            if (type == Long.TYPE) {
                return new UnsafeLongFieldAccessorImpl(field);
            }
            if (type == Float.TYPE) {
                return new UnsafeFloatFieldAccessorImpl(field);
            }
            if (type == Double.TYPE) {
                return new UnsafeDoubleFieldAccessorImpl(field);
            }
            return new UnsafeObjectFieldAccessorImpl(field);
        }
        if (type == Boolean.TYPE) {
            return new UnsafeQualifiedBooleanFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Byte.TYPE) {
            return new UnsafeQualifiedByteFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Short.TYPE) {
            return new UnsafeQualifiedShortFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Character.TYPE) {
            return new UnsafeQualifiedCharacterFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Integer.TYPE) {
            return new UnsafeQualifiedIntegerFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Long.TYPE) {
            return new UnsafeQualifiedLongFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Float.TYPE) {
            return new UnsafeQualifiedFloatFieldAccessorImpl(field, isReadOnly);
        }
        if (type == Double.TYPE) {
            return new UnsafeQualifiedDoubleFieldAccessorImpl(field, isReadOnly);
        }
        return new UnsafeQualifiedObjectFieldAccessorImpl(field, isReadOnly);
    }
}

