/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.lang.reflect.Field;
import jdk.internal.reflect.UnsafeStaticFieldAccessorImpl;

class UnsafeStaticFloatFieldAccessorImpl
extends UnsafeStaticFieldAccessorImpl {
    UnsafeStaticFloatFieldAccessorImpl(Field field) {
        super(field);
    }

    @Override
    public Object get(Object obj) throws IllegalArgumentException {
        return Float.valueOf(this.getFloat(obj));
    }

    @Override
    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object obj) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object obj) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object obj) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    @Override
    public float getFloat(Object obj) throws IllegalArgumentException {
        return unsafe.getFloat(this.base, this.fieldOffset);
    }

    @Override
    public double getDouble(Object obj) throws IllegalArgumentException {
        return this.getFloat(obj);
    }

    @Override
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Short)value).shortValue());
            return;
        }
        if (value instanceof Character) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Character)value).charValue());
            return;
        }
        if (value instanceof Integer) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Integer)value).intValue());
            return;
        }
        if (value instanceof Long) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Long)value).longValue());
            return;
        }
        if (value instanceof Float) {
            unsafe.putFloat(this.base, this.fieldOffset, ((Float)value).floatValue());
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    @Override
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    @Override
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, b);
    }

    @Override
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, c);
    }

    @Override
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, s);
    }

    @Override
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, i);
    }

    @Override
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, l);
    }

    @Override
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        if (this.isFinal) {
            this.throwFinalFieldIllegalAccessException(f);
        }
        unsafe.putFloat(this.base, this.fieldOffset, f);
    }

    @Override
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

