/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util;

import java.util.Properties;

public final class StaticProperty {
    private static final String JAVA_HOME;
    private static final String USER_HOME;
    private static final String USER_DIR;
    private static final String USER_NAME;
    private static final String JAVA_LIBRARY_PATH;
    private static final String SUN_BOOT_LIBRARY_PATH;
    private static final String JDK_SERIAL_FILTER;
    private static final String JDK_SERIAL_FILTER_FACTORY;
    private static final String JAVA_IO_TMPDIR;
    private static final String NATIVE_ENCODING;

    private StaticProperty() {
    }

    private static String getProperty(Properties props, String key) {
        String v = props.getProperty(key);
        if (v == null) {
            throw new InternalError("null property: " + key);
        }
        return v;
    }

    private static String getProperty(Properties props, String key, String defaultVal) {
        String v = props.getProperty(key);
        return v == null ? defaultVal : v;
    }

    public static String javaHome() {
        return JAVA_HOME;
    }

    public static String userHome() {
        return USER_HOME;
    }

    public static String userDir() {
        return USER_DIR;
    }

    public static String userName() {
        return USER_NAME;
    }

    public static String javaLibraryPath() {
        return JAVA_LIBRARY_PATH;
    }

    public static String javaIoTmpDir() {
        return JAVA_IO_TMPDIR;
    }

    public static String sunBootLibraryPath() {
        return SUN_BOOT_LIBRARY_PATH;
    }

    public static String jdkSerialFilter() {
        return JDK_SERIAL_FILTER;
    }

    public static String jdkSerialFilterFactory() {
        return JDK_SERIAL_FILTER_FACTORY;
    }

    public static String nativeEncoding() {
        return NATIVE_ENCODING;
    }

    static {
        Properties props = System.getProperties();
        JAVA_HOME = StaticProperty.getProperty(props, "java.home");
        USER_HOME = StaticProperty.getProperty(props, "user.home");
        USER_DIR = StaticProperty.getProperty(props, "user.dir");
        USER_NAME = StaticProperty.getProperty(props, "user.name");
        JAVA_IO_TMPDIR = StaticProperty.getProperty(props, "java.io.tmpdir");
        JAVA_LIBRARY_PATH = StaticProperty.getProperty(props, "java.library.path", "");
        SUN_BOOT_LIBRARY_PATH = StaticProperty.getProperty(props, "sun.boot.library.path", "");
        JDK_SERIAL_FILTER = StaticProperty.getProperty(props, "jdk.serialFilter", null);
        JDK_SERIAL_FILTER_FACTORY = StaticProperty.getProperty(props, "jdk.serialFilterFactory", null);
        NATIVE_ENCODING = StaticProperty.getProperty(props, "native.encoding");
    }
}

