/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util;

import java.util.HashMap;
import java.util.Map;

public final class SystemProps {
    private SystemProps() {
    }

    public static Map<String, String> initProperties() {
        Raw raw = new Raw();
        HashMap<String, String> props = raw.cmdProperties();
        String javaHome = props.get("java.home");
        assert (javaHome != null) : "java.home not set";
        SystemProps.putIfAbsent(props, "user.home", raw.propDefault(37));
        SystemProps.putIfAbsent(props, "user.dir", raw.propDefault(36));
        SystemProps.putIfAbsent(props, "user.name", raw.propDefault(38));
        SystemProps.put(props, "sun.jnu.encoding", raw.propDefault(32));
        String nativeEncoding = raw.propDefault(4) == null ? raw.propDefault(32) : raw.propDefault(4);
        SystemProps.put(props, "native.encoding", nativeEncoding);
        SystemProps.putIfAbsent(props, "file.encoding", nativeEncoding);
        SystemProps.putIfAbsent(props, "os.name", raw.propDefault(21));
        SystemProps.putIfAbsent(props, "os.arch", raw.propDefault(20));
        SystemProps.putIfAbsent(props, "os.version", raw.propDefault(22));
        SystemProps.putIfAbsent(props, "line.separator", raw.propDefault(19));
        SystemProps.putIfAbsent(props, "file.separator", raw.propDefault(5));
        SystemProps.putIfAbsent(props, "path.separator", raw.propDefault(23));
        SystemProps.putIfAbsent(props, "java.io.tmpdir", raw.propDefault(18));
        SystemProps.putIfAbsent(props, "http.proxyHost", raw.propDefault(14));
        SystemProps.putIfAbsent(props, "http.proxyPort", raw.propDefault(15));
        SystemProps.putIfAbsent(props, "https.proxyHost", raw.propDefault(16));
        SystemProps.putIfAbsent(props, "https.proxyPort", raw.propDefault(17));
        SystemProps.putIfAbsent(props, "ftp.proxyHost", raw.propDefault(11));
        SystemProps.putIfAbsent(props, "ftp.proxyPort", raw.propDefault(12));
        SystemProps.putIfAbsent(props, "socksProxyHost", raw.propDefault(25));
        SystemProps.putIfAbsent(props, "socksProxyPort", raw.propDefault(26));
        SystemProps.putIfAbsent(props, "http.nonProxyHosts", raw.propDefault(13));
        SystemProps.putIfAbsent(props, "ftp.nonProxyHosts", raw.propDefault(10));
        SystemProps.putIfAbsent(props, "socksNonProxyHosts", raw.propDefault(24));
        SystemProps.putIfAbsent(props, "sun.arch.abi", raw.propDefault(27));
        SystemProps.putIfAbsent(props, "sun.arch.data.model", raw.propDefault(28));
        SystemProps.putIfAbsent(props, "sun.os.patch.level", raw.propDefault(33));
        SystemProps.putIfAbsent(props, "sun.stdout.encoding", raw.propDefault(35));
        SystemProps.putIfAbsent(props, "sun.stderr.encoding", raw.propDefault(34));
        SystemProps.putIfAbsent(props, "sun.io.unicode.encoding", raw.propDefault(31));
        SystemProps.putIfAbsent(props, "sun.cpu.isalist", raw.propDefault(30));
        SystemProps.putIfAbsent(props, "sun.cpu.endian", raw.propDefault(29));
        SystemProps.fillI18nProps(props, "user.language", raw.propDefault(1), raw.propDefault(7));
        SystemProps.fillI18nProps(props, "user.script", raw.propDefault(2), raw.propDefault(8));
        SystemProps.fillI18nProps(props, "user.country", raw.propDefault(0), raw.propDefault(6));
        SystemProps.fillI18nProps(props, "user.variant", raw.propDefault(3), raw.propDefault(9));
        return props;
    }

    private static void put(HashMap<String, String> props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private static void putIfAbsent(HashMap<String, String> props, String key, String value) {
        if (value != null) {
            props.putIfAbsent(key, value);
        }
    }

    private static void fillI18nProps(HashMap<String, String> cmdProps, String base, String display, String format) {
        String fmt;
        String fmtValue;
        String disp;
        String dispValue;
        String baseValue = cmdProps.get(base);
        if (baseValue != null) {
            return;
        }
        if (display != null) {
            cmdProps.put(base, display);
            baseValue = display;
        }
        if ((dispValue = cmdProps.get(disp = base.concat(".display"))) == null && display != null && !display.equals(baseValue)) {
            cmdProps.put(disp, display);
        }
        if ((fmtValue = cmdProps.get(fmt = base.concat(".format"))) == null && format != null && !format.equals(baseValue)) {
            cmdProps.put(fmt, format);
        }
    }

    public static class Raw {
        private static final int _display_country_NDX = 0;
        private static final int _display_language_NDX = 1;
        private static final int _display_script_NDX = 2;
        private static final int _display_variant_NDX = 3;
        private static final int _file_encoding_NDX = 4;
        private static final int _file_separator_NDX = 5;
        private static final int _format_country_NDX = 6;
        private static final int _format_language_NDX = 7;
        private static final int _format_script_NDX = 8;
        private static final int _format_variant_NDX = 9;
        private static final int _ftp_nonProxyHosts_NDX = 10;
        private static final int _ftp_proxyHost_NDX = 11;
        private static final int _ftp_proxyPort_NDX = 12;
        private static final int _http_nonProxyHosts_NDX = 13;
        private static final int _http_proxyHost_NDX = 14;
        private static final int _http_proxyPort_NDX = 15;
        private static final int _https_proxyHost_NDX = 16;
        private static final int _https_proxyPort_NDX = 17;
        private static final int _java_io_tmpdir_NDX = 18;
        private static final int _line_separator_NDX = 19;
        private static final int _os_arch_NDX = 20;
        private static final int _os_name_NDX = 21;
        private static final int _os_version_NDX = 22;
        private static final int _path_separator_NDX = 23;
        private static final int _socksNonProxyHosts_NDX = 24;
        private static final int _socksProxyHost_NDX = 25;
        private static final int _socksProxyPort_NDX = 26;
        private static final int _sun_arch_abi_NDX = 27;
        private static final int _sun_arch_data_model_NDX = 28;
        private static final int _sun_cpu_endian_NDX = 29;
        private static final int _sun_cpu_isalist_NDX = 30;
        private static final int _sun_io_unicode_encoding_NDX = 31;
        private static final int _sun_jnu_encoding_NDX = 32;
        private static final int _sun_os_patch_level_NDX = 33;
        private static final int _sun_stderr_encoding_NDX = 34;
        private static final int _sun_stdout_encoding_NDX = 35;
        private static final int _user_dir_NDX = 36;
        private static final int _user_home_NDX = 37;
        private static final int _user_name_NDX = 38;
        private static final int FIXED_LENGTH = 39;
        private final String[] platformProps = Raw.platformProperties();

        private Raw() {
        }

        String propDefault(int index) {
            return this.platformProps[index];
        }

        private HashMap<String, String> cmdProperties() {
            String k;
            String[] vmProps = Raw.vmProperties();
            HashMap<String, String> cmdProps = new HashMap<String, String>(vmProps.length / 2 + 39);
            int i = 0;
            while (i < vmProps.length && (k = vmProps[i++]) != null) {
                String v;
                cmdProps.put(k, (v = vmProps[i++]) != null ? v : "");
            }
            return cmdProps;
        }

        private static native String[] vmProperties();

        private static native String[] platformProperties();
    }
}

