/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.util.xml.impl.Attrs;
import jdk.internal.util.xml.impl.Input;
import jdk.internal.util.xml.impl.Pair;
import jdk.internal.util.xml.impl.ReaderUTF16;
import jdk.internal.util.xml.impl.ReaderUTF8;

public abstract class Parser {
    public static final String FAULT = "";
    protected static final int BUFFSIZE_READER = 512;
    protected static final int BUFFSIZE_PARSER = 128;
    public static final char EOS = '\uffff';
    private Pair mNoNS;
    private Pair mXml;
    private Map<String, Input> mEnt;
    private Map<String, Input> mPEnt;
    protected boolean mIsSAlone;
    protected boolean mIsSAloneSet;
    protected boolean mIsNSAware;
    protected int mPh = -1;
    protected static final int PH_BEFORE_DOC = -1;
    protected static final int PH_DOC_START = 0;
    protected static final int PH_MISC_DTD = 1;
    protected static final int PH_DTD = 2;
    protected static final int PH_DTD_MISC = 3;
    protected static final int PH_DOCELM = 4;
    protected static final int PH_DOCELM_MISC = 5;
    protected static final int PH_AFTER_DOC = 6;
    protected int mEvt;
    protected static final int EV_NULL = 0;
    protected static final int EV_ELM = 1;
    protected static final int EV_ELMS = 2;
    protected static final int EV_ELME = 3;
    protected static final int EV_TEXT = 4;
    protected static final int EV_WSPC = 5;
    protected static final int EV_PI = 6;
    protected static final int EV_CDAT = 7;
    protected static final int EV_COMM = 8;
    protected static final int EV_DTD = 9;
    protected static final int EV_ENT = 10;
    private char mESt;
    protected char[] mBuff = new char[128];
    protected int mBuffIdx;
    protected Pair mPref;
    protected Pair mElm;
    protected Pair mAttL;
    protected Input mDoc;
    protected Input mInp;
    private char[] mChars;
    private int mChLen;
    private int mChIdx;
    protected Attrs mAttrs = new Attrs();
    private String[] mItems;
    private char mAttrIdx;
    private String mUnent;
    private Pair mDltd;
    private static final char[] NONS;
    private static final char[] XML;
    private static final char[] XMLNS;
    private static final byte[] asctyp;
    private static final byte[] nmttyp;

    protected Parser() {
        this.mPref = this.pair(this.mPref);
        this.mPref.name = FAULT;
        this.mPref.value = FAULT;
        this.mPref.chars = NONS;
        this.mNoNS = this.mPref;
        this.mPref = this.pair(this.mPref);
        this.mPref.name = "xml";
        this.mPref.value = "http://www.w3.org/XML/1998/namespace";
        this.mPref.chars = XML;
        this.mXml = this.mPref;
    }

    protected void init() {
        this.mUnent = null;
        this.mElm = null;
        this.mPref = this.mXml;
        this.mAttL = null;
        this.mPEnt = new HashMap<String, Input>();
        this.mEnt = new HashMap<String, Input>();
        this.mDoc = this.mInp;
        this.mChars = this.mInp.chars;
        this.mPh = 0;
    }

    protected void cleanup() {
        while (this.mAttL != null) {
            while (this.mAttL.list != null) {
                if (this.mAttL.list.list != null) {
                    this.del(this.mAttL.list.list);
                }
                this.mAttL.list = this.del(this.mAttL.list);
            }
            this.mAttL = this.del(this.mAttL);
        }
        while (this.mElm != null) {
            this.mElm = this.del(this.mElm);
        }
        while (this.mPref != this.mXml) {
            this.mPref = this.del(this.mPref);
        }
        while (this.mInp != null) {
            this.pop();
        }
        if (this.mDoc != null && this.mDoc.src != null) {
            try {
                this.mDoc.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mPEnt = null;
        this.mEnt = null;
        this.mDoc = null;
        this.mPh = 6;
    }

    protected int step() throws Exception {
        this.mEvt = 0;
        int st = 0;
        block29: while (this.mEvt == 0) {
            char ch = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            block0 : switch (st) {
                case 0: {
                    if (ch != '<') {
                        this.bkch();
                        this.mBuffIdx = -1;
                        st = 1;
                        break;
                    }
                    switch (this.getch()) {
                        case '/': {
                            this.mEvt = 3;
                            if (this.mElm == null) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = -1;
                            this.bname(this.mIsNSAware);
                            char[] chars = this.mElm.chars;
                            if (chars.length == this.mBuffIdx + 1) {
                                for (int i = 1; i <= this.mBuffIdx; i = (int)((char)(i + 1))) {
                                    if (chars[i] == this.mBuff[i]) continue;
                                    this.panic(FAULT);
                                }
                            } else {
                                this.panic(FAULT);
                            }
                            if (this.wsskip() != '>') {
                                this.panic(FAULT);
                            }
                            this.getch();
                            break block0;
                        }
                        case '!': {
                            ch = this.getch();
                            this.bkch();
                            switch (ch) {
                                case '-': {
                                    this.mEvt = 8;
                                    this.comm();
                                    break block0;
                                }
                                case '[': {
                                    this.mEvt = 7;
                                    this.cdat();
                                    break block0;
                                }
                            }
                            this.mEvt = 9;
                            this.dtd();
                            break block0;
                        }
                        case '?': {
                            this.mEvt = 6;
                            this.pi();
                            break block0;
                        }
                    }
                    this.bkch();
                    this.mElm = this.pair(this.mElm);
                    this.mElm.chars = this.qname(this.mIsNSAware);
                    this.mElm.name = this.mElm.local();
                    this.mElm.id = this.mElm.next != null ? this.mElm.next.id : 0;
                    this.mElm.num = 0;
                    Pair elm = this.find(this.mAttL, this.mElm.chars);
                    this.mElm.list = elm != null ? elm.list : null;
                    this.mAttrIdx = '\u0000';
                    Pair att = this.pair(null);
                    att.num = 0;
                    this.attr(att);
                    this.del(att);
                    this.mElm.value = this.mIsNSAware ? this.rslv(this.mElm.chars) : null;
                    switch (this.wsskip()) {
                        case '>': {
                            this.getch();
                            this.mEvt = 2;
                            break block0;
                        }
                        case '/': {
                            this.getch();
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            this.mEvt = 1;
                            break block0;
                        }
                    }
                    this.panic(FAULT);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            this.bappend(ch);
                            break block0;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block0;
                        }
                        case '<': {
                            this.mEvt = 5;
                            this.bkch();
                            this.bflash_ws();
                            break block0;
                        }
                    }
                    this.bkch();
                    st = 2;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case '&': {
                            if (this.mUnent == null) {
                                this.mUnent = this.ent('x');
                                if (this.mUnent == null) continue block29;
                                this.mEvt = 4;
                                this.bkch();
                                this.setch('&');
                                this.bflash();
                                break block0;
                            }
                            this.mEvt = 10;
                            this.skippedEnt(this.mUnent);
                            this.mUnent = null;
                            break block0;
                        }
                        case '<': {
                            this.mEvt = 4;
                            this.bkch();
                            this.bflash();
                            break block0;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block0;
                        }
                        case '\uffff': {
                            this.panic(FAULT);
                        }
                    }
                    this.bappend(ch);
                    break;
                }
                default: {
                    this.panic(FAULT);
                }
            }
        }
        return this.mEvt;
    }

    private void dtd() throws Exception {
        Object str = null;
        String name = null;
        Pair psid = null;
        if (!"DOCTYPE".equals(this.name(false))) {
            this.panic(FAULT);
        }
        this.mPh = 2;
        int st = 0;
        block24: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    if (this.chtyp(ch) == ' ') continue block24;
                    this.bkch();
                    name = this.name(this.mIsNSAware);
                    this.wsskip();
                    st = 1;
                    continue block24;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case 'A': {
                            this.bkch();
                            psid = this.pubsys(' ');
                            st = 2;
                            this.docType(name, psid.name, psid.value);
                            continue block24;
                        }
                        case '[': {
                            this.bkch();
                            st = 2;
                            this.docType(name, null, null);
                            continue block24;
                        }
                        case '>': {
                            this.bkch();
                            st = 3;
                            this.docType(name, null, null);
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case '[': {
                            this.dtdsub();
                            st = 3;
                            continue block24;
                        }
                        case '>': {
                            this.bkch();
                            st = 3;
                            continue block24;
                        }
                        case ' ': {
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
                case 3: {
                    switch (this.chtyp(ch)) {
                        case '>': {
                            if (psid != null) {
                                InputSource is = this.resolveEnt(name, psid.name, psid.value);
                                if (is != null) {
                                    if (!this.mIsSAlone) {
                                        this.bkch();
                                        this.setch(']');
                                        this.push(new Input(512));
                                        this.setinp(is);
                                        this.mInp.pubid = psid.name;
                                        this.mInp.sysid = psid.value;
                                        this.dtdsub();
                                    } else {
                                        this.skippedEnt("[dtd]");
                                        if (is.getCharacterStream() != null) {
                                            try {
                                                is.getCharacterStream().close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                        if (is.getByteStream() != null) {
                                            try {
                                                is.getByteStream().close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                } else {
                                    this.skippedEnt("[dtd]");
                                }
                                this.del(psid);
                            }
                            st = -1;
                            continue block24;
                        }
                        case ' ': {
                            continue block24;
                        }
                    }
                    this.panic(FAULT);
                    continue block24;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdsub() throws Exception {
        this.startInternalSub();
        int st = 0;
        block25: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case '<': {
                            ch = this.getch();
                            switch (ch) {
                                case '?': {
                                    this.pi();
                                    continue block25;
                                }
                                case '!': {
                                    ch = this.getch();
                                    this.bkch();
                                    if (ch == '-') {
                                        this.comm();
                                        continue block25;
                                    }
                                    this.bntok();
                                    switch (this.bkeyword()) {
                                        case 'n': {
                                            this.dtdent();
                                            break;
                                        }
                                        case 'a': {
                                            this.dtdattl();
                                            break;
                                        }
                                        case 'e': {
                                            this.dtdelm();
                                            break;
                                        }
                                        case 'o': {
                                            this.dtdnot();
                                            break;
                                        }
                                        default: {
                                            this.panic(FAULT);
                                        }
                                    }
                                    st = 1;
                                    continue block25;
                                }
                            }
                            this.panic(FAULT);
                            continue block25;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block25;
                        }
                        case ']': {
                            st = -1;
                            continue block25;
                        }
                        case ' ': {
                            continue block25;
                        }
                        case 'Z': {
                            if (this.getch() != ']') {
                                this.panic(FAULT);
                            }
                            st = -1;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 1: {
                    switch (ch) {
                        case '>': {
                            st = 0;
                            continue block25;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdent() throws Exception {
        String str = null;
        char[] val = null;
        Input inp = null;
        Pair ids = null;
        int st = 0;
        block21: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ' ': {
                            continue block21;
                        }
                        case '%': {
                            ch = this.getch();
                            this.bkch();
                            if (this.chtyp(ch) == ' ') {
                                this.wsskip();
                                str = this.name(false);
                                switch (this.chtyp(this.wsskip())) {
                                    case 'A': {
                                        ids = this.pubsys(' ');
                                        if (this.wsskip() == '>') {
                                            if (!this.mPEnt.containsKey(str)) {
                                                inp = new Input();
                                                inp.pubid = ids.name;
                                                inp.sysid = ids.value;
                                                this.mPEnt.put(str, inp);
                                            }
                                        } else {
                                            this.panic(FAULT);
                                        }
                                        this.del(ids);
                                        st = -1;
                                        continue block21;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        this.bqstr('d');
                                        val = new char[this.mBuffIdx + 1];
                                        System.arraycopy(this.mBuff, 1, val, 1, val.length - 1);
                                        val[0] = 32;
                                        if (!this.mPEnt.containsKey(str)) {
                                            inp = new Input(val);
                                            inp.pubid = this.mInp.pubid;
                                            inp.sysid = this.mInp.sysid;
                                            inp.xmlenc = this.mInp.xmlenc;
                                            inp.xmlver = this.mInp.xmlver;
                                            this.mPEnt.put(str, inp);
                                        }
                                        st = -1;
                                        continue block21;
                                    }
                                }
                                this.panic(FAULT);
                                continue block21;
                            }
                            this.pent(' ');
                            continue block21;
                        }
                    }
                    this.bkch();
                    str = this.name(false);
                    st = 1;
                    continue block21;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            if (this.mEnt.get(str) == null) {
                                val = new char[this.mBuffIdx];
                                System.arraycopy(this.mBuff, 1, val, 0, val.length);
                                if (!this.mEnt.containsKey(str)) {
                                    inp = new Input(val);
                                    inp.pubid = this.mInp.pubid;
                                    inp.sysid = this.mInp.sysid;
                                    inp.xmlenc = this.mInp.xmlenc;
                                    inp.xmlver = this.mInp.xmlver;
                                    this.mEnt.put(str, inp);
                                }
                            }
                            st = -1;
                            continue block21;
                        }
                        case 'A': {
                            this.bkch();
                            ids = this.pubsys(' ');
                            switch (this.wsskip()) {
                                case '>': {
                                    if (this.mEnt.containsKey(str)) break;
                                    inp = new Input();
                                    inp.pubid = ids.name;
                                    inp.sysid = ids.value;
                                    this.mEnt.put(str, inp);
                                    break;
                                }
                                case 'N': {
                                    if ("NDATA".equals(this.name(false))) {
                                        this.wsskip();
                                        this.unparsedEntDecl(str, ids.name, ids.value, this.name(false));
                                        break;
                                    }
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.del(ids);
                            st = -1;
                            continue block21;
                        }
                        case ' ': {
                            continue block21;
                        }
                    }
                    this.panic(FAULT);
                    continue block21;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdelm() throws Exception {
        this.wsskip();
        this.name(this.mIsNSAware);
        while (true) {
            char ch = this.getch();
            switch (ch) {
                case '>': {
                    this.bkch();
                    return;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
            }
        }
    }

    private void dtdattl() throws Exception {
        char[] elmqn = null;
        Pair elm = null;
        int st = 0;
        block14: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            elmqn = this.qname(this.mIsNSAware);
                            elm = this.find(this.mAttL, elmqn);
                            if (elm == null) {
                                elm = this.pair(this.mAttL);
                                elm.chars = elmqn;
                                this.mAttL = elm;
                            }
                            st = 1;
                            continue block14;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            this.dtdatt(elm);
                            if (this.wsskip() != '>') continue block14;
                            return;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdatt(Pair elm) throws Exception {
        char[] attqn = null;
        Pair att = null;
        int st = 0;
        block57: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            attqn = this.qname(this.mIsNSAware);
                            att = this.find(elm.list, attqn);
                            if (att == null) {
                                att = this.pair(elm.list);
                                att.chars = attqn;
                                elm.list = att;
                            } else {
                                att = this.pair(null);
                                att.chars = attqn;
                                att.id = 99;
                            }
                            this.wsskip();
                            st = 1;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '(': {
                            att.id = 117;
                            st = 2;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.bkch();
                    this.bntok();
                    att.id = this.bkeyword();
                    switch (att.id) {
                        case 111: {
                            if (this.wsskip() != '(') {
                                this.panic(FAULT);
                            }
                            ch = this.getch();
                            st = 2;
                            continue block57;
                        }
                        case 78: 
                        case 82: 
                        case 84: 
                        case 99: 
                        case 105: 
                        case 110: 
                        case 114: 
                        case 116: {
                            this.wsskip();
                            st = 4;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case '-': 
                        case '.': 
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': 
                        case 'd': {
                            this.bkch();
                            switch (att.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            st = 3;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 3: {
                    switch (ch) {
                        case ')': {
                            this.wsskip();
                            st = 4;
                            continue block57;
                        }
                        case '|': {
                            this.wsskip();
                            switch (att.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 4: {
                    switch (ch) {
                        case '#': {
                            this.bntok();
                            switch (this.bkeyword()) {
                                case 'F': {
                                    switch (this.wsskip()) {
                                        case '\"': 
                                        case '\'': {
                                            st = 5;
                                            continue block57;
                                        }
                                        case '\uffff': {
                                            this.panic(FAULT);
                                        }
                                    }
                                    st = -1;
                                    continue block57;
                                }
                                case 'I': 
                                case 'Q': {
                                    st = -1;
                                    continue block57;
                                }
                            }
                            this.panic(FAULT);
                            continue block57;
                        }
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            st = 5;
                            continue block57;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.bkch();
                    st = -1;
                    continue block57;
                }
                case 5: {
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            att.list = this.pair(null);
                            att.list.chars = new char[att.chars.length + this.mBuffIdx + 3];
                            System.arraycopy(att.chars, 1, att.list.chars, 0, att.chars.length - 1);
                            att.list.chars[att.chars.length - 1] = 61;
                            att.list.chars[att.chars.length] = ch;
                            System.arraycopy(this.mBuff, 1, att.list.chars, att.chars.length + 1, this.mBuffIdx);
                            att.list.chars[att.chars.length + this.mBuffIdx + 1] = ch;
                            att.list.chars[att.chars.length + this.mBuffIdx + 2] = 32;
                            st = -1;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdnot() throws Exception {
        this.wsskip();
        String name = this.name(false);
        this.wsskip();
        Pair ids = this.pubsys('N');
        this.notDecl(name, ids.name, ids.value);
        this.del(ids);
    }

    private void attr(Pair att) throws Exception {
        switch (this.wsskip()) {
            case '/': 
            case '>': {
                if ((att.num & 2) == 0) {
                    att.num |= 2;
                    Input inp = this.mInp;
                    Pair def = this.mElm.list;
                    while (def != null) {
                        Pair act;
                        if (def.list != null && (act = this.find(att.next, def.chars)) == null) {
                            this.push(new Input(def.list.chars));
                        }
                        def = def.next;
                    }
                    if (this.mInp != inp) {
                        this.attr(att);
                        return;
                    }
                }
                this.mAttrs.setLength(this.mAttrIdx);
                this.mItems = this.mAttrs.mItems;
                return;
            }
            case '\uffff': {
                this.panic(FAULT);
            }
        }
        att.chars = this.qname(this.mIsNSAware);
        att.name = att.local();
        String type = this.atype(att);
        this.wsskip();
        if (this.getch() != '=') {
            this.panic(FAULT);
        }
        this.bqstr((char)att.id);
        String val = new String(this.mBuff, 1, this.mBuffIdx);
        Pair next = this.pair(att);
        next.num = att.num & 0xFFFFFFFE;
        if (!this.mIsNSAware || !this.isdecl(att, val)) {
            this.mAttrIdx = (char)(this.mAttrIdx + '\u0001');
            this.attr(next);
            this.mAttrIdx = (char)(this.mAttrIdx - '\u0001');
            char idx = (char)(this.mAttrIdx << 3);
            this.mItems[idx + '\u0001'] = att.qname();
            this.mItems[idx + 2] = this.mIsNSAware ? att.name : FAULT;
            this.mItems[idx + 3] = val;
            this.mItems[idx + 4] = type;
            switch (att.num & 3) {
                case 0: {
                    this.mItems[idx + 5] = null;
                    break;
                }
                case 1: {
                    this.mItems[idx + 5] = "d";
                    break;
                }
                default: {
                    this.mItems[idx + 5] = "D";
                }
            }
            this.mItems[idx + '\u0000'] = att.chars[0] != '\u0000' ? this.rslv(att.chars) : FAULT;
        } else {
            this.newPrefix();
            this.attr(next);
        }
        this.del(next);
    }

    private String atype(Pair att) throws Exception {
        Pair attr;
        att.id = 99;
        if (this.mElm.list == null || (attr = this.find(this.mElm.list, att.chars)) == null) {
            return "CDATA";
        }
        att.num |= 1;
        att.id = 105;
        switch (attr.id) {
            case 105: {
                return "ID";
            }
            case 114: {
                return "IDREF";
            }
            case 82: {
                return "IDREFS";
            }
            case 110: {
                return "ENTITY";
            }
            case 78: {
                return "ENTITIES";
            }
            case 116: {
                return "NMTOKEN";
            }
            case 84: {
                return "NMTOKENS";
            }
            case 117: {
                return "NMTOKEN";
            }
            case 111: {
                return "NOTATION";
            }
            case 99: {
                att.id = 99;
                return "CDATA";
            }
        }
        this.panic(FAULT);
        return null;
    }

    private void comm() throws Exception {
        if (this.mPh == 0) {
            this.mPh = 1;
        }
        this.mBuffIdx = -1;
        int st = 0;
        block13: while (st >= 0) {
            char ch;
            char c = ch = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: {
                    if (ch == '-') {
                        st = 1;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 1: {
                    if (ch == '-') {
                        st = 2;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 2: {
                    switch (ch) {
                        case '-': {
                            st = 3;
                            continue block13;
                        }
                    }
                    this.bappend(ch);
                    continue block13;
                }
                case 3: {
                    switch (ch) {
                        case '-': {
                            st = 4;
                            continue block13;
                        }
                    }
                    this.bappend('-');
                    this.bappend(ch);
                    st = 2;
                    continue block13;
                }
                case 4: {
                    if (ch != '>') break;
                    this.comm(this.mBuff, this.mBuffIdx + 1);
                    st = -1;
                    continue block13;
                }
            }
            this.panic(FAULT);
        }
    }

    private void pi() throws Exception {
        String str = null;
        this.mBuffIdx = -1;
        int st = 0;
        block15: while (st >= 0) {
            char ch = this.getch();
            if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            str = this.name(false);
                            if (str.isEmpty() || this.mXml.name.equals(str.toLowerCase())) {
                                this.panic(FAULT);
                            }
                            if (this.mPh == 0) {
                                this.mPh = 1;
                            }
                            this.wsskip();
                            st = 1;
                            this.mBuffIdx = -1;
                            continue block15;
                        }
                    }
                    this.panic(FAULT);
                    continue block15;
                }
                case 1: {
                    switch (ch) {
                        case '?': {
                            st = 2;
                            continue block15;
                        }
                    }
                    this.bappend(ch);
                    continue block15;
                }
                case 2: {
                    switch (ch) {
                        case '>': {
                            this.pi(str, new String(this.mBuff, 0, this.mBuffIdx + 1));
                            st = -1;
                            continue block15;
                        }
                        case '?': {
                            this.bappend('?');
                            continue block15;
                        }
                    }
                    this.bappend('?');
                    this.bappend(ch);
                    st = 1;
                    continue block15;
                }
            }
            this.panic(FAULT);
        }
    }

    private void cdat() throws Exception {
        this.mBuffIdx = -1;
        int st = 0;
        block12: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    if (ch == '[') {
                        st = 1;
                        continue block12;
                    }
                    this.panic(FAULT);
                    continue block12;
                }
                case 1: {
                    if (this.chtyp(ch) == 'A') {
                        this.bappend(ch);
                        continue block12;
                    }
                    if (!"CDATA".equals(new String(this.mBuff, 0, this.mBuffIdx + 1))) {
                        this.panic(FAULT);
                    }
                    this.bkch();
                    st = 2;
                    continue block12;
                }
                case 2: {
                    if (ch != '[') {
                        this.panic(FAULT);
                    }
                    this.mBuffIdx = -1;
                    st = 3;
                    continue block12;
                }
                case 3: {
                    if (ch != ']') {
                        this.bappend(ch);
                        continue block12;
                    }
                    st = 4;
                    continue block12;
                }
                case 4: {
                    if (ch != ']') {
                        this.bappend(']');
                        this.bappend(ch);
                        st = 3;
                        continue block12;
                    }
                    st = 5;
                    continue block12;
                }
                case 5: {
                    switch (ch) {
                        case ']': {
                            this.bappend(']');
                            continue block12;
                        }
                        case '>': {
                            this.bflash();
                            st = -1;
                            continue block12;
                        }
                    }
                    this.bappend(']');
                    this.bappend(']');
                    this.bappend(ch);
                    st = 3;
                    continue block12;
                }
            }
            this.panic(FAULT);
        }
    }

    protected String name(boolean ns) throws Exception {
        this.mBuffIdx = -1;
        this.bname(ns);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    protected char[] qname(boolean ns) throws Exception {
        this.mBuffIdx = -1;
        this.bname(ns);
        char[] chars = new char[this.mBuffIdx + 1];
        System.arraycopy(this.mBuff, 0, chars, 0, this.mBuffIdx + 1);
        return chars;
    }

    private void pubsys(Input inp) throws Exception {
        Pair pair = this.pubsys(' ');
        inp.pubid = pair.name;
        inp.sysid = pair.value;
        this.del(pair);
    }

    private Pair pubsys(char flag) throws Exception {
        Pair ids = this.pair(null);
        String str = this.name(false);
        if ("PUBLIC".equals(str)) {
            this.bqstr('i');
            ids.name = new String(this.mBuff, 1, this.mBuffIdx);
            switch (this.wsskip()) {
                case '\"': 
                case '\'': {
                    this.bqstr(' ');
                    ids.value = new String(this.mBuff, 1, this.mBuffIdx);
                    break;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
                default: {
                    if (flag != 'N') {
                        this.panic(FAULT);
                    }
                    ids.value = null;
                }
            }
            return ids;
        }
        if ("SYSTEM".equals(str)) {
            ids.name = null;
            this.bqstr(' ');
            ids.value = new String(this.mBuff, 1, this.mBuffIdx);
            return ids;
        }
        this.panic(FAULT);
        return null;
    }

    protected String eqstr(char flag) throws Exception {
        if (flag == '=') {
            this.wsskip();
            if (this.getch() != '=') {
                this.panic(FAULT);
            }
        }
        this.bqstr(flag == '=' ? (char)'-' : (char)flag);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    private String ent(char flag) throws Exception {
        int idx = this.mBuffIdx + 1;
        Input inp = null;
        String str = null;
        this.mESt = (char)256;
        this.bappend('&');
        int st = 0;
        block25: while (st >= 0) {
            char ch = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            switch (st) {
                case 0: 
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '-': 
                        case '.': 
                        case 'd': {
                            if (st != 1) {
                                this.panic(FAULT);
                            }
                        }
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bappend(ch);
                            this.eappend(ch);
                            st = 1;
                            continue block25;
                        }
                        case ':': {
                            if (this.mIsNSAware) {
                                this.panic(FAULT);
                            }
                            this.bappend(ch);
                            this.eappend(ch);
                            st = 1;
                            continue block25;
                        }
                        case ';': {
                            if (this.mESt < '\u0100') {
                                this.mBuffIdx = idx - 1;
                                this.bappend(this.mESt);
                                st = -1;
                                continue block25;
                            }
                            if (this.mPh == 2) {
                                this.bappend(';');
                                st = -1;
                                continue block25;
                            }
                            str = new String(this.mBuff, idx + 1, this.mBuffIdx - idx);
                            inp = this.mEnt.get(str);
                            this.mBuffIdx = idx - 1;
                            if (inp != null) {
                                if (inp.chars == null) {
                                    InputSource is = this.resolveEnt(str, inp.pubid, inp.sysid);
                                    if (is != null) {
                                        this.push(new Input(512));
                                        this.setinp(is);
                                        this.mInp.pubid = inp.pubid;
                                        this.mInp.sysid = inp.sysid;
                                        str = null;
                                    } else if (flag != 'x') {
                                        this.panic(FAULT);
                                    }
                                } else {
                                    this.push(inp);
                                    str = null;
                                }
                            } else if (flag != 'x') {
                                this.panic(FAULT);
                            }
                            st = -1;
                            continue block25;
                        }
                        case '#': {
                            if (st != 0) {
                                this.panic(FAULT);
                            }
                            st = 2;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case 'd': {
                            this.bappend(ch);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int i = Integer.parseInt(new String(this.mBuff, idx + 1, this.mBuffIdx - idx), 10);
                                if (i >= 65535) {
                                    this.panic(FAULT);
                                }
                                ch = (char)i;
                            }
                            catch (NumberFormatException nfe) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = idx - 1;
                            if (ch == ' ' || this.mInp.next != null) {
                                this.bappend(ch, flag);
                            } else {
                                this.bappend(ch);
                            }
                            st = -1;
                            continue block25;
                        }
                        case 'a': {
                            if (this.mBuffIdx != idx || ch != 'x') break;
                            st = 3;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 3: {
                    switch (this.chtyp(ch)) {
                        case 'A': 
                        case 'a': 
                        case 'd': {
                            this.bappend(ch);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int i = Integer.parseInt(new String(this.mBuff, idx + 1, this.mBuffIdx - idx), 16);
                                if (i >= 65535) {
                                    this.panic(FAULT);
                                }
                                ch = (char)i;
                            }
                            catch (NumberFormatException nfe) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = idx - 1;
                            if (ch == ' ' || this.mInp.next != null) {
                                this.bappend(ch, flag);
                            } else {
                                this.bappend(ch);
                            }
                            st = -1;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
            }
            this.panic(FAULT);
        }
        return str;
    }

    private void pent(char flag) throws Exception {
        int idx = this.mBuffIdx + 1;
        Input inp = null;
        String str = null;
        this.bappend('%');
        if (this.mPh != 2) {
            return;
        }
        this.bname(false);
        str = new String(this.mBuff, idx + 2, this.mBuffIdx - idx - 1);
        if (this.getch() != ';') {
            this.panic(FAULT);
        }
        inp = this.mPEnt.get(str);
        this.mBuffIdx = idx - 1;
        if (inp != null) {
            if (inp.chars == null) {
                InputSource is = this.resolveEnt(str, inp.pubid, inp.sysid);
                if (is != null) {
                    if (flag != '-') {
                        this.bappend(' ');
                    }
                    this.push(new Input(512));
                    this.setinp(is);
                    this.mInp.pubid = inp.pubid;
                    this.mInp.sysid = inp.sysid;
                } else {
                    this.skippedEnt("%" + str);
                }
            } else {
                if (flag == '-') {
                    inp.chIdx = 1;
                } else {
                    this.bappend(' ');
                    inp.chIdx = 0;
                }
                this.push(inp);
            }
        } else {
            this.skippedEnt("%" + str);
        }
    }

    private boolean isdecl(Pair name, String value) {
        if (name.chars[0] == '\u0000') {
            if ("xmlns".equals(name.name)) {
                this.mPref = this.pair(this.mPref);
                this.mPref.list = this.mElm;
                this.mPref.value = value;
                this.mPref.name = FAULT;
                this.mPref.chars = NONS;
                ++this.mElm.num;
                return true;
            }
        } else if (name.eqpref(XMLNS)) {
            int len = name.name.length();
            this.mPref = this.pair(this.mPref);
            this.mPref.list = this.mElm;
            this.mPref.value = value;
            this.mPref.name = name.name;
            this.mPref.chars = new char[len + 1];
            this.mPref.chars[0] = (char)(len + 1);
            name.name.getChars(0, len, this.mPref.chars, 1);
            ++this.mElm.num;
            return true;
        }
        return false;
    }

    private String rslv(char[] qname) throws Exception {
        Pair pref = this.mPref;
        while (pref != null) {
            if (pref.eqpref(qname)) {
                return pref.value;
            }
            pref = pref.next;
        }
        if (qname[0] == '\u0001') {
            pref = this.mPref;
            while (pref != null) {
                if (pref.chars[0] == '\u0000') {
                    return pref.value;
                }
                pref = pref.next;
            }
        }
        this.panic(FAULT);
        return null;
    }

    protected char wsskip() throws IOException {
        char ch;
        do {
            char c = ch = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
        } while (ch < '\u0080' && nmttyp[ch] == 3);
        --this.mChIdx;
        return ch;
    }

    protected abstract void docType(String var1, String var2, String var3) throws SAXException;

    public abstract void startInternalSub() throws SAXException;

    protected abstract void comm(char[] var1, int var2);

    protected abstract void pi(String var1, String var2) throws Exception;

    protected abstract void newPrefix() throws Exception;

    protected abstract void skippedEnt(String var1) throws Exception;

    protected abstract InputSource resolveEnt(String var1, String var2, String var3) throws Exception;

    protected abstract void notDecl(String var1, String var2, String var3) throws Exception;

    protected abstract void unparsedEntDecl(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract void panic(String var1) throws Exception;

    private void bname(boolean ns) throws Exception {
        int bchidx;
        int bqname;
        ++this.mBuffIdx;
        int bcolon = bqname = this.mBuffIdx;
        int bstart = bchidx = bqname + 1;
        int cstart = this.mChIdx;
        int st = ns ? 0 : 2;
        block12: while (true) {
            if (this.mChIdx >= this.mChLen) {
                this.bcopy(cstart, bstart);
                this.getch();
                cstart = --this.mChIdx;
                bstart = bchidx;
            }
            char ch = this.mChars[this.mChIdx++];
            char type = '\u0000';
            if (ch < '\u0080') {
                type = (char)nmttyp[ch];
            } else if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: 
                case 2: {
                    switch (type) {
                        case '\u0000': {
                            ++bchidx;
                            st = (short)(st + 1);
                            continue block12;
                        }
                        case '\u0001': {
                            --this.mChIdx;
                            st = (short)(st + 1);
                            continue block12;
                        }
                    }
                    this.panic(FAULT);
                    continue block12;
                }
                case 1: 
                case 3: {
                    switch (type) {
                        case '\u0000': 
                        case '\u0002': {
                            ++bchidx;
                            continue block12;
                        }
                        case '\u0001': {
                            ++bchidx;
                            if (!ns) continue block12;
                            if (bcolon != bqname) {
                                this.panic(FAULT);
                            }
                            bcolon = bchidx - 1;
                            if (st != 1) continue block12;
                            st = 2;
                            continue block12;
                        }
                    }
                    --this.mChIdx;
                    this.bcopy(cstart, bstart);
                    this.mBuff[bqname] = (char)(bcolon - bqname);
                    return;
                }
            }
            this.panic(FAULT);
        }
    }

    private void bntok() throws Exception {
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        block4: while (true) {
            char ch = this.getch();
            switch (this.chtyp(ch)) {
                case '-': 
                case '.': 
                case ':': 
                case 'A': 
                case 'X': 
                case '_': 
                case 'a': 
                case 'd': {
                    this.bappend(ch);
                    continue block4;
                }
                case 'Z': {
                    this.panic(FAULT);
                }
            }
            break;
        }
        this.bkch();
    }

    private char bkeyword() throws Exception {
        String str = new String(this.mBuff, 1, this.mBuffIdx);
        switch (str.length()) {
            case 2: {
                return "ID".equals(str) ? (char)'i' : '?';
            }
            case 5: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREF".equals(str) ? (char)'r' : '?';
                    }
                    case 'C': {
                        return "CDATA".equals(str) ? (char)'c' : '?';
                    }
                    case 'F': {
                        return "FIXED".equals(str) ? (char)'F' : '?';
                    }
                }
                break;
            }
            case 6: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREFS".equals(str) ? (char)'R' : '?';
                    }
                    case 'E': {
                        return "ENTITY".equals(str) ? (char)'n' : '?';
                    }
                }
                break;
            }
            case 7: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IMPLIED".equals(str) ? (char)'I' : '?';
                    }
                    case 'N': {
                        return "NMTOKEN".equals(str) ? (char)'t' : '?';
                    }
                    case 'A': {
                        return "ATTLIST".equals(str) ? (char)'a' : '?';
                    }
                    case 'E': {
                        return "ELEMENT".equals(str) ? (char)'e' : '?';
                    }
                }
                break;
            }
            case 8: {
                switch (this.mBuff[2]) {
                    case 'N': {
                        return "ENTITIES".equals(str) ? (char)'N' : '?';
                    }
                    case 'M': {
                        return "NMTOKENS".equals(str) ? (char)'T' : '?';
                    }
                    case 'O': {
                        return "NOTATION".equals(str) ? (char)'o' : '?';
                    }
                    case 'E': {
                        return "REQUIRED".equals(str) ? (char)'Q' : '?';
                    }
                }
                break;
            }
        }
        return '?';
    }

    private void bqstr(char flag) throws Exception {
        Input inp = this.mInp;
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        int st = 0;
        block18: while (st >= 0) {
            int ch = this.mChIdx < this.mChLen ? this.mChars[this.mChIdx++] : this.getch();
            switch (st) {
                case 0: {
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block18;
                        }
                        case 39: {
                            st = 2;
                            continue block18;
                        }
                        case 34: {
                            st = 3;
                            continue block18;
                        }
                    }
                    this.panic(FAULT);
                    continue block18;
                }
                case 2: 
                case 3: {
                    switch (ch) {
                        case 39: {
                            if (st == 2 && this.mInp == inp) {
                                st = -1;
                                continue block18;
                            }
                            this.bappend((char)ch);
                            continue block18;
                        }
                        case 34: {
                            if (st == 3 && this.mInp == inp) {
                                st = -1;
                                continue block18;
                            }
                            this.bappend((char)ch);
                            continue block18;
                        }
                        case 38: {
                            if (flag != 'd') {
                                this.ent(flag);
                                continue block18;
                            }
                            this.bappend((char)ch);
                            continue block18;
                        }
                        case 37: {
                            if (flag == 'd') {
                                this.pent('-');
                                continue block18;
                            }
                            this.bappend((char)ch);
                            continue block18;
                        }
                        case 60: {
                            if (flag == '-' || flag == 'd') {
                                this.bappend((char)ch);
                                continue block18;
                            }
                            this.panic(FAULT);
                            continue block18;
                        }
                        case 65535: {
                            this.panic(FAULT);
                        }
                        case 13: {
                            if (flag == ' ' || this.mInp.next != null) break;
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            ch = 10;
                        }
                    }
                    this.bappend((char)ch, flag);
                    continue block18;
                }
            }
            this.panic(FAULT);
        }
        if (flag == 'i' && this.mBuff[this.mBuffIdx] == ' ') {
            --this.mBuffIdx;
        }
    }

    protected abstract void bflash() throws Exception;

    protected abstract void bflash_ws() throws Exception;

    private void bappend(char ch, char mode) {
        block0 : switch (mode) {
            case 'i': {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.mBuffIdx > 0 && this.mBuff[this.mBuffIdx] != ' ') {
                            this.bappend(' ');
                        }
                        return;
                    }
                }
                break;
            }
            case 'c': {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        ch = (char)32;
                        break block0;
                    }
                }
                break;
            }
        }
        ++this.mBuffIdx;
        if (this.mBuffIdx < this.mBuff.length) {
            this.mBuff[this.mBuffIdx] = ch;
        } else {
            --this.mBuffIdx;
            this.bappend(ch);
        }
    }

    private void bappend(char ch) {
        try {
            this.mBuff[++this.mBuffIdx] = ch;
        }
        catch (Exception exp) {
            char[] buff = new char[this.mBuff.length << 1];
            System.arraycopy(this.mBuff, 0, buff, 0, this.mBuff.length);
            this.mBuff = buff;
            this.mBuff[this.mBuffIdx] = ch;
        }
    }

    private void bcopy(int cidx, int bidx) {
        int length = this.mChIdx - cidx;
        if (bidx + length + 1 >= this.mBuff.length) {
            char[] buff = new char[this.mBuff.length + length];
            System.arraycopy(this.mBuff, 0, buff, 0, this.mBuff.length);
            this.mBuff = buff;
        }
        System.arraycopy(this.mChars, cidx, this.mBuff, bidx, length);
        this.mBuffIdx += length;
    }

    private void eappend(char ch) {
        block0 : switch (this.mESt) {
            case '\u0100': {
                switch (ch) {
                    case 'l': {
                        this.mESt = (char)257;
                        break block0;
                    }
                    case 'g': {
                        this.mESt = (char)258;
                        break block0;
                    }
                    case 'a': {
                        this.mESt = (char)259;
                        break block0;
                    }
                    case 'q': {
                        this.mESt = (char)263;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0101': {
                this.mESt = (char)(ch == 't' ? 60 : 512);
                break;
            }
            case '\u0102': {
                this.mESt = (char)(ch == 't' ? 62 : 512);
                break;
            }
            case '\u0103': {
                switch (ch) {
                    case 'm': {
                        this.mESt = (char)260;
                        break block0;
                    }
                    case 'p': {
                        this.mESt = (char)261;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0104': {
                this.mESt = (char)(ch == 'p' ? 38 : 512);
                break;
            }
            case '\u0105': {
                this.mESt = (char)(ch == 'o' ? 262 : 512);
                break;
            }
            case '\u0106': {
                this.mESt = (char)(ch == 's' ? 39 : 512);
                break;
            }
            case '\u0107': {
                this.mESt = (char)(ch == 'u' ? 264 : 512);
                break;
            }
            case '\u0108': {
                this.mESt = (char)(ch == 'o' ? 265 : 512);
                break;
            }
            case '\u0109': {
                this.mESt = (char)(ch == 't' ? 34 : 512);
                break;
            }
            case '\"': 
            case '&': 
            case '\'': 
            case '<': 
            case '>': {
                this.mESt = (char)512;
            }
        }
    }

    protected void setinp(InputSource is) throws Exception {
        Reader reader = null;
        this.mChIdx = 0;
        this.mChLen = 0;
        this.mChars = this.mInp.chars;
        this.mInp.src = null;
        if (this.mPh < 0) {
            this.mIsSAlone = false;
        }
        this.mIsSAloneSet = false;
        if (is.getCharacterStream() != null) {
            reader = is.getCharacterStream();
            this.xml(reader);
        } else if (is.getByteStream() != null) {
            if (is.getEncoding() != null) {
                String expenc = is.getEncoding().toUpperCase();
                reader = expenc.equals("UTF-16") ? this.bom(is.getByteStream(), 'U') : this.enc(expenc, is.getByteStream());
                this.xml(reader);
            } else {
                reader = this.bom(is.getByteStream(), ' ');
                if (reader == null) {
                    reader = this.utf16(is.getByteStream());
                }
                if (reader == null) {
                    reader = this.enc("UTF-8", is.getByteStream());
                    String expenc = this.xml(reader);
                    if (!expenc.equals("UTF-8")) {
                        if (expenc.startsWith("UTF-16")) {
                            this.panic(FAULT);
                        }
                        reader = this.enc(expenc, is.getByteStream());
                    }
                } else {
                    this.xml(reader);
                }
            }
        } else {
            this.panic(FAULT);
        }
        this.mInp.src = reader;
        this.mInp.pubid = is.getPublicId();
        this.mInp.sysid = is.getSystemId();
    }

    private Reader bom(InputStream is, char hint) throws Exception {
        int val = is.read();
        switch (val) {
            case 239: {
                if (hint == 'U') {
                    this.panic(FAULT);
                }
                if (is.read() != 187) {
                    this.panic(FAULT);
                }
                if (is.read() != 191) {
                    this.panic(FAULT);
                }
                return new ReaderUTF8(is);
            }
            case 254: {
                if (is.read() != 255) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(is, 'b');
            }
            case 255: {
                if (is.read() != 254) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(is, 'l');
            }
            case -1: {
                this.mChars[this.mChIdx++] = 65535;
                return new ReaderUTF8(is);
            }
        }
        if (hint == 'U') {
            this.panic(FAULT);
        }
        switch (val & 0xF0) {
            case 192: 
            case 208: {
                this.mChars[this.mChIdx++] = (char)((val & 0x1F) << 6 | is.read() & 0x3F);
                break;
            }
            case 224: {
                this.mChars[this.mChIdx++] = (char)((val & 0xF) << 12 | (is.read() & 0x3F) << 6 | is.read() & 0x3F);
                break;
            }
            case 240: {
                throw new UnsupportedEncodingException();
            }
            default: {
                this.mChars[this.mChIdx++] = (char)val;
            }
        }
        return null;
    }

    private Reader utf16(InputStream is) throws Exception {
        byte b0;
        if (this.mChIdx != 0 && ((b0 = (byte)this.mChars[0]) == 0 || b0 == 60)) {
            int b1 = is.read();
            int b2 = is.read();
            int b3 = is.read();
            if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
                this.mChars[0] = (char)b1;
                this.mChars[this.mChIdx++] = (char)b3;
                return new ReaderUTF16(is, 'b');
            }
            if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
                this.mChars[0] = (char)b0;
                this.mChars[this.mChIdx++] = (char)b2;
                return new ReaderUTF16(is, 'l');
            }
            this.mChars[0] = (char)b0;
            this.mChars[this.mChIdx++] = (char)b1;
            this.mChars[this.mChIdx++] = (char)b2;
            this.mChars[this.mChIdx++] = (char)b3;
        }
        return null;
    }

    private String xml(Reader reader) throws Exception {
        String str = null;
        String enc = "UTF-8";
        int st = 0;
        int byteRead = this.mChIdx;
        block38: while (st >= 0 && this.mChIdx < this.mChars.length) {
            int val;
            char c;
            if (st < byteRead) {
                c = this.mChars[st];
            } else {
                val = reader.read();
                c = val >= 0 ? (int)val : 65535;
                this.mChars[this.mChIdx++] = c;
            }
            switch (st) {
                case 0: {
                    switch (c) {
                        case '<': {
                            st = 1;
                            continue block38;
                        }
                        case '\ufeff': {
                            val = reader.read();
                            this.mChars[this.mChIdx - 1] = c = val >= 0 ? (int)val : 65535;
                            st = (short)(c == '<' ? 1 : -1);
                            continue block38;
                        }
                    }
                    st = -1;
                    continue block38;
                }
                case 1: {
                    st = (short)(c == '?' ? 2 : -1);
                    continue block38;
                }
                case 2: {
                    st = (short)(c == 'x' ? 3 : -1);
                    continue block38;
                }
                case 3: {
                    st = (short)(c == 'm' ? 4 : -1);
                    continue block38;
                }
                case 4: {
                    st = (short)(c == 'l' ? 5 : -1);
                    continue block38;
                }
                case 5: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            st = 6;
                            continue block38;
                        }
                    }
                    st = -1;
                    continue block38;
                }
                case 6: {
                    switch (c) {
                        case '?': {
                            st = 7;
                            continue block38;
                        }
                        case '\uffff': {
                            st = -2;
                            continue block38;
                        }
                    }
                    continue block38;
                }
                case 7: {
                    switch (c) {
                        case '>': 
                        case '\uffff': {
                            st = -2;
                            continue block38;
                        }
                    }
                    st = 6;
                    continue block38;
                }
            }
            this.panic(FAULT);
        }
        this.mChLen = this.mChIdx;
        this.mChIdx = 0;
        if (st == -1) {
            return enc;
        }
        this.mChIdx = 5;
        st = 0;
        block39: while (st >= 0) {
            char c = this.getch();
            switch (st) {
                case 0: {
                    if (this.chtyp(c) == ' ') continue block39;
                    this.bkch();
                    st = 1;
                    continue block39;
                }
                case 1: 
                case 2: 
                case 3: {
                    switch (this.chtyp(c)) {
                        case 'A': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            str = this.name(false).toLowerCase();
                            if ("version".equals(str)) {
                                if (st != 1) {
                                    this.panic(FAULT);
                                }
                                if (!"1.0".equals(this.eqstr('='))) {
                                    this.panic(FAULT);
                                }
                                this.mInp.xmlver = (char)256;
                                st = 2;
                                continue block39;
                            }
                            if ("encoding".equals(str)) {
                                if (st != 2) {
                                    this.panic(FAULT);
                                }
                                enc = this.mInp.xmlenc = this.eqstr('=').toUpperCase();
                                st = 3;
                                continue block39;
                            }
                            if ("standalone".equals(str)) {
                                if (st == 1 || this.mPh >= 0) {
                                    this.panic(FAULT);
                                }
                                if ((str = this.eqstr('=').toLowerCase()).equals("yes")) {
                                    this.mIsSAlone = true;
                                } else if (str.equals("no")) {
                                    this.mIsSAlone = false;
                                } else {
                                    this.panic(FAULT);
                                }
                                this.mIsSAloneSet = true;
                                st = 4;
                                continue block39;
                            }
                            this.panic(FAULT);
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                        case '?': {
                            if (st == 1) {
                                this.panic(FAULT);
                            }
                            this.bkch();
                            st = 4;
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
                case 4: {
                    switch (this.chtyp(c)) {
                        case '?': {
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            if (this.mPh <= 0) {
                                this.mPh = 1;
                            }
                            st = -1;
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
            }
            this.panic(FAULT);
        }
        return enc;
    }

    private Reader enc(String name, InputStream is) throws UnsupportedEncodingException {
        if (name.equals("UTF-8")) {
            return new ReaderUTF8(is);
        }
        if (name.equals("UTF-16LE")) {
            return new ReaderUTF16(is, 'l');
        }
        if (name.equals("UTF-16BE")) {
            return new ReaderUTF16(is, 'b');
        }
        return new InputStreamReader(is, name);
    }

    protected void push(Input inp) {
        this.mInp.chLen = this.mChLen;
        this.mInp.chIdx = this.mChIdx;
        inp.next = this.mInp;
        this.mInp = inp;
        this.mChars = inp.chars;
        this.mChLen = inp.chLen;
        this.mChIdx = inp.chIdx;
    }

    protected void pop() {
        if (this.mInp.src != null) {
            try {
                this.mInp.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mInp.src = null;
        }
        this.mInp = this.mInp.next;
        if (this.mInp != null) {
            this.mChars = this.mInp.chars;
            this.mChLen = this.mInp.chLen;
            this.mChIdx = this.mInp.chIdx;
        } else {
            this.mChars = null;
            this.mChLen = 0;
            this.mChIdx = 0;
        }
    }

    protected char chtyp(char ch) {
        if (ch < '\u0080') {
            return (char)asctyp[ch];
        }
        return ch != '\uffff' ? (char)'X' : 'Z';
    }

    protected char getch() throws IOException {
        if (this.mChIdx >= this.mChLen) {
            if (this.mInp.src == null) {
                this.pop();
                return this.getch();
            }
            int Num = this.mInp.src.read(this.mChars, 0, this.mChars.length);
            if (Num < 0) {
                if (this.mInp != this.mDoc) {
                    this.pop();
                    return this.getch();
                }
                this.mChars[0] = 65535;
                this.mChLen = 1;
            } else {
                this.mChLen = Num;
            }
            this.mChIdx = 0;
        }
        return this.mChars[this.mChIdx++];
    }

    protected void bkch() throws Exception {
        if (this.mChIdx <= 0) {
            this.panic(FAULT);
        }
        --this.mChIdx;
    }

    protected void setch(char ch) {
        this.mChars[this.mChIdx] = ch;
    }

    protected Pair find(Pair chain, char[] qname) {
        Pair pair = chain;
        while (pair != null) {
            if (pair.eqname(qname)) {
                return pair;
            }
            pair = pair.next;
        }
        return null;
    }

    protected Pair pair(Pair next) {
        Pair pair;
        if (this.mDltd != null) {
            pair = this.mDltd;
            this.mDltd = pair.next;
        } else {
            pair = new Pair();
        }
        pair.next = next;
        return pair;
    }

    protected Pair del(Pair pair) {
        Pair next = pair.next;
        pair.name = null;
        pair.value = null;
        pair.chars = null;
        pair.list = null;
        pair.next = this.mDltd;
        this.mDltd = pair;
        return next;
    }

    static {
        int i;
        NONS = new char[1];
        Parser.NONS[0] = '\u0000';
        XML = new char[4];
        Parser.XML[0] = 4;
        Parser.XML[1] = 120;
        Parser.XML[2] = 109;
        Parser.XML[3] = 108;
        XMLNS = new char[6];
        Parser.XMLNS[0] = 6;
        Parser.XMLNS[1] = 120;
        Parser.XMLNS[2] = 109;
        Parser.XMLNS[3] = 108;
        Parser.XMLNS[4] = 110;
        Parser.XMLNS[5] = 115;
        asctyp = new byte[128];
        for (i = 0; i < 32; i = (int)((short)(i + 1))) {
            int n = i;
            Parser.asctyp[n] = 122;
        }
        Parser.asctyp[9] = 32;
        Parser.asctyp[13] = 32;
        Parser.asctyp[10] = 32;
        while (i < 48) {
            int n = i;
            int n2 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n2;
        }
        while (i <= 57) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 100;
        }
        while (i < 65) {
            int n = i;
            int n3 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n3;
        }
        while (i <= 90) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 65;
        }
        while (i < 97) {
            int n = i;
            int n4 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n4;
        }
        while (i <= 122) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 97;
        }
        while (i < 128) {
            int n = i;
            int n5 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n5;
        }
        nmttyp = new byte[128];
        for (i = 0; i < 48; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        while (i <= 57) {
            int n = i;
            i = (short)(i + 1);
            Parser.nmttyp[n] = 2;
        }
        while (i < 65) {
            int n = i;
            i = (short)(i + 1);
            Parser.nmttyp[n] = -1;
        }
        for (i = 91; i < 97; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        for (i = 123; i < 128; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        Parser.nmttyp[95] = 0;
        Parser.nmttyp[58] = 1;
        Parser.nmttyp[46] = 2;
        Parser.nmttyp[45] = 2;
        Parser.nmttyp[32] = 3;
        Parser.nmttyp[9] = 3;
        Parser.nmttyp[13] = 3;
        Parser.nmttyp[10] = 3;
    }
}

