/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import jdk.internal.org.xml.sax.ContentHandler;
import jdk.internal.org.xml.sax.DTDHandler;
import jdk.internal.org.xml.sax.EntityResolver;
import jdk.internal.org.xml.sax.ErrorHandler;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.Locator;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.SAXParseException;
import jdk.internal.org.xml.sax.XMLReader;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.impl.Input;
import jdk.internal.util.xml.impl.Parser;

final class ParserSAX
extends Parser
implements XMLReader,
Locator {
    public static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_PREF = "http://xml.org/sax/features/namespace-prefixes";
    private boolean mFNamespaces = true;
    private boolean mFPrefixes = false;
    private DefaultHandler mHand = new DefaultHandler();
    private ContentHandler mHandCont = this.mHand;
    private DTDHandler mHandDtd = this.mHand;
    private ErrorHandler mHandErr = this.mHand;
    private EntityResolver mHandEnt = this.mHand;

    @Override
    public ContentHandler getContentHandler() {
        return this.mHandCont != this.mHand ? this.mHandCont : null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.mHandCont = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.mHandDtd != this.mHand ? this.mHandDtd : null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.mHandDtd = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.mHandErr != this.mHand ? this.mHandErr : null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.mHandErr = handler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.mHandEnt != this.mHand ? this.mHandEnt : null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.mHandEnt = resolver;
    }

    @Override
    public String getPublicId() {
        return this.mInp != null ? this.mInp.pubid : null;
    }

    @Override
    public String getSystemId() {
        return this.mInp != null ? this.mInp.sysid : null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void parse(InputSource is) throws IOException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("");
        }
        this.mInp = new Input(512);
        this.mPh = -1;
        try {
            this.setinp(is);
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            this.panic(e.toString());
        }
        this.parse();
    }

    public void parse(InputStream src, DefaultHandler handler) throws SAXException, IOException {
        if (src == null || handler == null) {
            throw new IllegalArgumentException("");
        }
        this.parse(new InputSource(src), handler);
    }

    public void parse(InputSource is, DefaultHandler handler) throws SAXException, IOException {
        if (is == null || handler == null) {
            throw new IllegalArgumentException("");
        }
        this.mHandCont = handler;
        this.mHandDtd = handler;
        this.mHandErr = handler;
        this.mHandEnt = handler;
        this.mInp = new Input(512);
        this.mPh = -1;
        try {
            this.setinp(is);
        }
        catch (IOException | RuntimeException | SAXException saxe) {
            throw saxe;
        }
        catch (Exception e) {
            this.panic(e.toString());
        }
        this.parse();
    }

    private void parse() throws SAXException, IOException {
        this.init();
        try {
            this.mHandCont.setDocumentLocator(this);
            this.mHandCont.startDocument();
            if (this.mPh != 1) {
                this.mPh = 1;
            }
            int evt = 0;
            do {
                this.wsskip();
                evt = this.step();
                switch (evt) {
                    case 1: 
                    case 2: {
                        this.mPh = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        if (this.mPh >= 3) {
                            this.panic("");
                        }
                        this.mPh = 3;
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
            } while (this.mPh < 4);
            do {
                switch (evt) {
                    case 1: 
                    case 2: {
                        if (this.mIsNSAware) {
                            this.mHandCont.startElement(this.mElm.value, this.mElm.name, "", this.mAttrs);
                        } else {
                            this.mHandCont.startElement("", "", this.mElm.name, this.mAttrs);
                        }
                        if (evt == 2) {
                            evt = this.step();
                            break;
                        }
                    }
                    case 3: {
                        if (this.mIsNSAware) {
                            this.mHandCont.endElement(this.mElm.value, this.mElm.name, "");
                        } else {
                            this.mHandCont.endElement("", "", this.mElm.name);
                        }
                        while (this.mPref.list == this.mElm) {
                            this.mHandCont.endPrefixMapping(this.mPref.name);
                            this.mPref = this.del(this.mPref);
                        }
                        this.mElm = this.del(this.mElm);
                        if (this.mElm == null) {
                            this.mPh = 5;
                            break;
                        }
                        evt = this.step();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        evt = this.step();
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
            } while (this.mPh == 4);
            while (this.wsskip() != '\uffff') {
                switch (this.step()) {
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
                if (this.mPh == 5) continue;
            }
            this.mPh = 6;
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            this.panic(e.toString());
        }
        finally {
            this.mHandCont.endDocument();
            this.cleanup();
        }
    }

    @Override
    protected void docType(String name, String pubid, String sysid) throws SAXException {
        this.mHandDtd.startDTD(name, pubid, sysid);
    }

    @Override
    public void startInternalSub() throws SAXException {
        this.mHandDtd.startInternalSub();
    }

    @Override
    protected void comm(char[] text, int length) {
    }

    @Override
    protected void pi(String target, String body) throws SAXException {
        this.mHandCont.processingInstruction(target, body);
    }

    @Override
    protected void newPrefix() throws SAXException {
        this.mHandCont.startPrefixMapping(this.mPref.name, this.mPref.value);
    }

    @Override
    protected void skippedEnt(String name) throws SAXException {
        this.mHandCont.skippedEntity(name);
    }

    @Override
    protected InputSource resolveEnt(String name, String pubid, String sysid) throws SAXException, IOException {
        return this.mHandEnt.resolveEntity(pubid, sysid);
    }

    @Override
    protected void notDecl(String name, String pubid, String sysid) throws SAXException {
        this.mHandDtd.notationDecl(name, pubid, sysid);
    }

    @Override
    protected void unparsedEntDecl(String name, String pubid, String sysid, String notation) throws SAXException {
        this.mHandDtd.unparsedEntityDecl(name, pubid, sysid, notation);
    }

    @Override
    protected void panic(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this);
        this.mHandErr.fatalError(spe);
        throw spe;
    }

    @Override
    protected void bflash() throws SAXException {
        if (this.mBuffIdx >= 0) {
            this.mHandCont.characters(this.mBuff, 0, this.mBuffIdx + 1);
            this.mBuffIdx = -1;
        }
    }

    @Override
    protected void bflash_ws() throws SAXException {
        if (this.mBuffIdx >= 0) {
            this.mHandCont.characters(this.mBuff, 0, this.mBuffIdx + 1);
            this.mBuffIdx = -1;
        }
    }

    @Override
    public boolean getFeature(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFeature(String name, boolean value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProperty(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProperty(String name, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

