/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.vm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public class VMSupport {
    private static Properties agentProps = null;

    public static synchronized Properties getAgentProperties() {
        if (agentProps == null) {
            agentProps = new Properties();
            VMSupport.initAgentProperties(agentProps);
        }
        return agentProps;
    }

    private static native Properties initAgentProperties(Properties var0);

    private static byte[] serializePropertiesToByteArray(Properties p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        Properties props = new Properties();
        Set<String> keyset = p.stringPropertyNames();
        for (String key : keyset) {
            String value = p.getProperty(key);
            props.put(key, value);
        }
        props.store(out, null);
        return out.toByteArray();
    }

    public static byte[] serializePropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(System.getProperties());
    }

    public static byte[] serializeAgentPropertiesToByteArray() throws IOException {
        return VMSupport.serializePropertiesToByteArray(VMSupport.getAgentProperties());
    }

    public static native String getVMTemporaryDirectory();
}

