/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.vm.vector;

import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.internal.misc.Unsafe;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public class VectorSupport {
    private static final Unsafe U;
    public static final int VECTOR_OP_ABS = 0;
    public static final int VECTOR_OP_NEG = 1;
    public static final int VECTOR_OP_SQRT = 2;
    public static final int VECTOR_OP_ADD = 4;
    public static final int VECTOR_OP_SUB = 5;
    public static final int VECTOR_OP_MUL = 6;
    public static final int VECTOR_OP_DIV = 7;
    public static final int VECTOR_OP_MIN = 8;
    public static final int VECTOR_OP_MAX = 9;
    public static final int VECTOR_OP_AND = 10;
    public static final int VECTOR_OP_OR = 11;
    public static final int VECTOR_OP_XOR = 12;
    public static final int VECTOR_OP_FMA = 13;
    public static final int VECTOR_OP_LSHIFT = 14;
    public static final int VECTOR_OP_RSHIFT = 15;
    public static final int VECTOR_OP_URSHIFT = 16;
    public static final int VECTOR_OP_CAST = 17;
    public static final int VECTOR_OP_REINTERPRET = 18;
    public static final int VECTOR_OP_MASK_TRUECOUNT = 19;
    public static final int VECTOR_OP_MASK_FIRSTTRUE = 20;
    public static final int VECTOR_OP_MASK_LASTTRUE = 21;
    public static final int VECTOR_OP_TAN = 101;
    public static final int VECTOR_OP_TANH = 102;
    public static final int VECTOR_OP_SIN = 103;
    public static final int VECTOR_OP_SINH = 104;
    public static final int VECTOR_OP_COS = 105;
    public static final int VECTOR_OP_COSH = 106;
    public static final int VECTOR_OP_ASIN = 107;
    public static final int VECTOR_OP_ACOS = 108;
    public static final int VECTOR_OP_ATAN = 109;
    public static final int VECTOR_OP_ATAN2 = 110;
    public static final int VECTOR_OP_CBRT = 111;
    public static final int VECTOR_OP_LOG = 112;
    public static final int VECTOR_OP_LOG10 = 113;
    public static final int VECTOR_OP_LOG1P = 114;
    public static final int VECTOR_OP_POW = 115;
    public static final int VECTOR_OP_EXP = 116;
    public static final int VECTOR_OP_EXPM1 = 117;
    public static final int VECTOR_OP_HYPOT = 118;
    public static final int BT_eq = 0;
    public static final int BT_ne = 4;
    public static final int BT_le = 5;
    public static final int BT_ge = 7;
    public static final int BT_lt = 3;
    public static final int BT_gt = 1;
    public static final int BT_overflow = 2;
    public static final int BT_no_overflow = 6;
    public static final int BT_unsigned_compare = 16;
    public static final int BT_ule = 21;
    public static final int BT_uge = 23;
    public static final int BT_ult = 19;
    public static final int BT_ugt = 17;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;

    @IntrinsicCandidate
    public static <VM, E, S extends VectorSpecies<E>> VM broadcastCoerced(Class<? extends VM> vmClass, Class<E> E, int length, long bits, S s, BroadcastOperation<VM, E, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.broadcast(bits, s);
    }

    @IntrinsicCandidate
    public static <E, S extends VectorSpecies<E>> VectorShuffle<E> shuffleIota(Class<?> E, Class<?> ShuffleClass, S s, int length, int start, int step, int wrap, ShuffleIotaOperation<E, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(length, start, step, s);
    }

    @IntrinsicCandidate
    public static <VM, Sh extends VectorShuffle<E>, E> VM shuffleToVector(Class<?> VM2, Class<?> E, Class<?> ShuffleClass, Sh s, int length, ShuffleToVectorOperation<VM, Sh, E> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(s);
    }

    public static <V extends Vector<E>, E, S extends VectorSpecies<E>> V indexVector(Class<? extends V> vClass, Class<E> E, int length, V v, int step, S s, IndexOperation<V, E, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.index(v, step, s);
    }

    @IntrinsicCandidate
    public static <V extends Vector<?>> long reductionCoerced(int oprId, Class<?> vectorClass, Class<?> elementType, int length, V v, Function<V, Long> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(v);
    }

    @IntrinsicCandidate
    public static <V extends Vector<?>> long extract(Class<?> vectorClass, Class<?> elementType, int vlen, V vec, int ix, VecExtractOp<V> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(vec, ix);
    }

    @IntrinsicCandidate
    public static <V extends Vector<?>> V insert(Class<? extends V> vectorClass, Class<?> elementType, int vlen, V vec, int ix, long val, VecInsertOp<V> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return (V)((Vector)defaultImpl.apply(vec, ix, val));
    }

    @IntrinsicCandidate
    public static <VM> VM unaryOp(int oprId, Class<? extends VM> vmClass, Class<?> elementType, int length, VM vm, Function<VM, VM> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(vm);
    }

    @IntrinsicCandidate
    public static <VM> VM binaryOp(int oprId, Class<? extends VM> vmClass, Class<?> elementType, int length, VM vm1, VM vm2, BiFunction<VM, VM, VM> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(vm1, vm2);
    }

    @IntrinsicCandidate
    public static <VM> VM ternaryOp(int oprId, Class<? extends VM> vmClass, Class<?> elementType, int length, VM vm1, VM vm2, VM vm3, TernaryOperation<VM> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(vm1, vm2, vm3);
    }

    @IntrinsicCandidate
    public static <C, VM, E, S extends VectorSpecies<E>> VM load(Class<? extends VM> vmClass, Class<E> E, int length, Object base, long offset, C container, int index, S s, LoadOperation<C, VM, E, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.load(container, index, s);
    }

    @IntrinsicCandidate
    public static <C, V extends Vector<?>, W extends Vector<Integer>, E, S extends VectorSpecies<E>> V loadWithMap(Class<?> vectorClass, Class<E> E, int length, Class<?> vectorIndexClass, Object base, long offset, W index_vector, C container, int index, int[] indexMap, int indexM, S s, LoadVectorOperationWithMap<C, V, E, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.loadWithMap(container, index, indexMap, indexM, s);
    }

    @IntrinsicCandidate
    public static <C, V extends Vector<?>> void store(Class<?> vectorClass, Class<?> elementType, int length, Object base, long offset, V v, C container, int index, StoreVectorOperation<C, V> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        defaultImpl.store(container, index, v);
    }

    @IntrinsicCandidate
    public static <C, V extends Vector<?>, W extends Vector<Integer>> void storeWithMap(Class<?> vectorClass, Class<?> elementType, int length, Class<?> vectorIndexClass, Object base, long offset, W index_vector, V v, C container, int index, int[] indexMap, int indexM, StoreVectorOperationWithMap<C, V> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        defaultImpl.storeWithMap(container, index, v, indexMap, indexM);
    }

    @IntrinsicCandidate
    public static <VM> boolean test(int cond, Class<?> vmClass, Class<?> elementType, int length, VM vm1, VM vm2, BiFunction<VM, VM, Boolean> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(vm1, vm2);
    }

    @IntrinsicCandidate
    public static <V extends Vector<E>, M extends VectorMask<E>, E> M compare(int cond, Class<? extends V> vectorClass, Class<M> maskClass, Class<?> elementType, int length, V v1, V v2, VectorCompareOp<V, M> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return (M)((VectorMask)defaultImpl.apply(cond, v1, v2));
    }

    @IntrinsicCandidate
    public static <V extends Vector<E>, Sh extends VectorShuffle<E>, E> V rearrangeOp(Class<? extends V> vectorClass, Class<Sh> shuffleClass, Class<?> elementType, int vlen, V v1, Sh sh, VectorRearrangeOp<V, Sh, E> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(v1, sh);
    }

    @IntrinsicCandidate
    public static <V extends Vector<E>, M extends VectorMask<E>, E> V blend(Class<? extends V> vectorClass, Class<M> maskClass, Class<?> elementType, int length, V v1, V v2, M m, VectorBlendOp<V, M, E> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(v1, v2, m);
    }

    @IntrinsicCandidate
    public static <V extends Vector<?>> V broadcastInt(int opr, Class<? extends V> vectorClass, Class<?> elementType, int length, V v, int n, VectorBroadcastIntOp<V> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(v, n);
    }

    @IntrinsicCandidate
    public static <VOUT extends VectorPayload, VIN extends VectorPayload, S extends VectorSpecies<?>> VOUT convert(int oprId, Class<?> fromVectorClass, Class<?> fromElementType, int fromVLen, Class<?> toVectorClass, Class<?> toElementType, int toVLen, VIN v, S s, VectorConvertOp<VOUT, VIN, S> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return (VOUT)((VectorPayload)defaultImpl.apply(v, s));
    }

    @IntrinsicCandidate
    public static <V> V maybeRebox(V v) {
        U.loadFence();
        return v;
    }

    @IntrinsicCandidate
    public static <E, M> int maskReductionCoerced(int oper, Class<? extends M> maskClass, Class<?> elemClass, int length, M m, VectorMaskOp<M> defaultImpl) {
        assert (VectorSupport.isNonCapturingLambda(defaultImpl)) : defaultImpl;
        return defaultImpl.apply(m);
    }

    public static native int getMaxLaneCount(Class<?> var0);

    public static boolean isNonCapturingLambda(Object o) {
        return o.getClass().getDeclaredFields().length == 0;
    }

    private static native int registerNatives();

    static {
        VectorSupport.registerNatives();
        U = Unsafe.getUnsafe();
    }

    public static interface BroadcastOperation<VM, E, S extends VectorSpecies<E>> {
        public VM broadcast(long var1, S var3);
    }

    public static class VectorSpecies<E> {
    }

    public static interface ShuffleIotaOperation<E, S extends VectorSpecies<E>> {
        public VectorShuffle<E> apply(int var1, int var2, int var3, S var4);
    }

    public static class VectorShuffle<E>
    extends VectorPayload {
        public VectorShuffle(Object payload) {
            super(payload);
        }
    }

    public static interface ShuffleToVectorOperation<VM, Sh, E> {
        public VM apply(Sh var1);
    }

    public static interface IndexOperation<V extends Vector<E>, E, S extends VectorSpecies<E>> {
        public V index(V var1, int var2, S var3);
    }

    public static class Vector<E>
    extends VectorPayload {
        public Vector(Object payload) {
            super(payload);
        }
    }

    public static interface VecExtractOp<V> {
        public long apply(V var1, int var2);
    }

    public static interface VecInsertOp<V> {
        public V apply(V var1, int var2, long var3);
    }

    public static interface TernaryOperation<V> {
        public V apply(V var1, V var2, V var3);
    }

    public static interface LoadOperation<C, V, E, S extends VectorSpecies<E>> {
        public V load(C var1, int var2, S var3);
    }

    public static interface LoadVectorOperationWithMap<C, V extends Vector<?>, E, S extends VectorSpecies<E>> {
        public V loadWithMap(C var1, int var2, int[] var3, int var4, S var5);
    }

    public static interface StoreVectorOperation<C, V extends Vector<?>> {
        public void store(C var1, int var2, V var3);
    }

    public static interface StoreVectorOperationWithMap<C, V extends Vector<?>> {
        public void storeWithMap(C var1, int var2, V var3, int[] var4, int var5);
    }

    public static interface VectorCompareOp<V, M> {
        public M apply(int var1, V var2, V var3);
    }

    public static class VectorMask<E>
    extends VectorPayload {
        public VectorMask(Object payload) {
            super(payload);
        }
    }

    public static interface VectorRearrangeOp<V extends Vector<E>, Sh extends VectorShuffle<E>, E> {
        public V apply(V var1, Sh var2);
    }

    public static interface VectorBlendOp<V extends Vector<E>, M extends VectorMask<E>, E> {
        public V apply(V var1, V var2, M var3);
    }

    public static interface VectorBroadcastIntOp<V extends Vector<?>> {
        public V apply(V var1, int var2);
    }

    public static interface VectorConvertOp<VOUT, VIN, S> {
        public VOUT apply(VIN var1, S var2);
    }

    public static class VectorPayload {
        private final Object payload;

        public VectorPayload(Object payload) {
            this.payload = payload;
        }

        protected final Object getPayload() {
            return VectorSupport.maybeRebox(this).payload;
        }
    }

    public static interface VectorMaskOp<M> {
        public int apply(M var1);
    }
}

