/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.Wrapper;

public class ValueConversions {
    private static final Class<?> THIS_CLASS = ValueConversions.class;
    private static final MethodHandles.Lookup IMPL_LOOKUP = MethodHandles.lookup();
    private static final WrapperCache[] UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
    private static final Integer ZERO_INT = 0;
    private static final Integer ONE_INT = 1;
    private static final WrapperCache[] BOX_CONVERSIONS = ValueConversions.newWrapperCaches(1);
    private static final WrapperCache[] CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(2);
    private static final WrapperCache[] CONVERT_PRIMITIVE_FUNCTIONS = ValueConversions.newWrapperCaches(10);

    private static WrapperCache[] newWrapperCaches(int n) {
        WrapperCache[] caches = new WrapperCache[n];
        for (int i = 0; i < n; ++i) {
            caches[i] = new WrapperCache();
        }
        return caches;
    }

    static int unboxInteger(Integer x) {
        return x;
    }

    static int unboxInteger(Object x, boolean cast) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.INT, x, cast).intValue();
    }

    static byte unboxByte(Byte x) {
        return x;
    }

    static byte unboxByte(Object x, boolean cast) {
        if (x instanceof Byte) {
            return (Byte)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.BYTE, x, cast).byteValue();
    }

    static short unboxShort(Short x) {
        return x;
    }

    static short unboxShort(Object x, boolean cast) {
        if (x instanceof Short) {
            return (Short)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.SHORT, x, cast).shortValue();
    }

    static boolean unboxBoolean(Boolean x) {
        return x;
    }

    static boolean unboxBoolean(Object x, boolean cast) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return (ValueConversions.primitiveConversion(Wrapper.BOOLEAN, x, cast).intValue() & 1) != 0;
    }

    static char unboxCharacter(Character x) {
        return x.charValue();
    }

    static char unboxCharacter(Object x, boolean cast) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return (char)ValueConversions.primitiveConversion(Wrapper.CHAR, x, cast).intValue();
    }

    static long unboxLong(Long x) {
        return x;
    }

    static long unboxLong(Object x, boolean cast) {
        if (x instanceof Long) {
            return (Long)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.LONG, x, cast).longValue();
    }

    static float unboxFloat(Float x) {
        return x.floatValue();
    }

    static float unboxFloat(Object x, boolean cast) {
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        return ValueConversions.primitiveConversion(Wrapper.FLOAT, x, cast).floatValue();
    }

    static double unboxDouble(Double x) {
        return x;
    }

    static double unboxDouble(Object x, boolean cast) {
        if (x instanceof Double) {
            return (Double)x;
        }
        return ValueConversions.primitiveConversion(Wrapper.DOUBLE, x, cast).doubleValue();
    }

    private static MethodType unboxType(Wrapper wrap, int kind) {
        if (kind == 0) {
            return MethodType.methodType(wrap.primitiveType(), wrap.wrapperType());
        }
        return MethodType.methodType(wrap.primitiveType(), Object.class, Boolean.TYPE);
    }

    private static MethodHandle unbox(Wrapper wrap, int kind) {
        WrapperCache cache = UNBOX_CONVERSIONS[kind];
        MethodHandle mh = cache.get(wrap);
        if (mh != null) {
            return mh;
        }
        switch (wrap) {
            case OBJECT: 
            case VOID: {
                throw new IllegalArgumentException("unbox " + (Object)((Object)wrap));
            }
        }
        String name = "unbox" + wrap.wrapperSimpleName();
        MethodType type = ValueConversions.unboxType(wrap, kind);
        try {
            mh = IMPL_LOOKUP.findStatic(THIS_CLASS, name, type);
        }
        catch (ReflectiveOperationException ex) {
            mh = null;
        }
        if (mh != null) {
            if (kind > 0) {
                boolean cast = kind != 2;
                mh = MethodHandles.insertArguments(mh, 1, cast);
            }
            if (kind == 1) {
                mh = mh.asType(ValueConversions.unboxType(wrap, 0));
            }
            return cache.put(wrap, mh);
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrap) + (kind <= 1 ? " (exact)" : (kind == 3 ? " (cast)" : "")));
    }

    public static MethodHandle unboxExact(Wrapper type) {
        return ValueConversions.unbox(type, 0);
    }

    public static MethodHandle unboxExact(Wrapper type, boolean throwNPE) {
        return ValueConversions.unbox(type, throwNPE ? 0 : 1);
    }

    public static MethodHandle unboxWiden(Wrapper type) {
        return ValueConversions.unbox(type, 2);
    }

    public static MethodHandle unboxCast(Wrapper type) {
        return ValueConversions.unbox(type, 3);
    }

    public static Number primitiveConversion(Wrapper wrap, Object x, boolean cast) {
        if (x == null) {
            if (!cast) {
                return null;
            }
            return ZERO_INT;
        }
        Number res = x instanceof Number ? (Number)((Number)x) : (Number)(x instanceof Boolean ? (Number)((Boolean)x != false ? ONE_INT : ZERO_INT) : (Number)(x instanceof Character ? (Number)Integer.valueOf(((Character)x).charValue()) : (Number)((Number)x)));
        Wrapper xwrap = Wrapper.findWrapperType(x.getClass());
        if (xwrap == null || !cast && !wrap.isConvertibleFrom(xwrap)) {
            return (Number)wrap.wrapperType().cast(x);
        }
        return res;
    }

    public static int widenSubword(Object x) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Boolean) {
            return ValueConversions.fromBoolean((Boolean)x);
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        return (Integer)x;
    }

    static Integer boxInteger(int x) {
        return x;
    }

    static Byte boxByte(byte x) {
        return x;
    }

    static Short boxShort(short x) {
        return x;
    }

    static Boolean boxBoolean(boolean x) {
        return x;
    }

    static Character boxCharacter(char x) {
        return Character.valueOf(x);
    }

    static Long boxLong(long x) {
        return x;
    }

    static Float boxFloat(float x) {
        return Float.valueOf(x);
    }

    static Double boxDouble(double x) {
        return x;
    }

    private static MethodType boxType(Wrapper wrap) {
        Class<?> boxType = wrap.wrapperType();
        return MethodType.methodType(boxType, wrap.primitiveType());
    }

    public static MethodHandle boxExact(Wrapper wrap) {
        WrapperCache cache = BOX_CONVERSIONS[0];
        MethodHandle mh = cache.get(wrap);
        if (mh != null) {
            return mh;
        }
        String name = "box" + wrap.wrapperSimpleName();
        MethodType type = ValueConversions.boxType(wrap);
        try {
            mh = IMPL_LOOKUP.findStatic(THIS_CLASS, name, type);
        }
        catch (ReflectiveOperationException ex) {
            mh = null;
        }
        if (mh != null) {
            return cache.put(wrap, mh);
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrap));
    }

    static void ignore(Object x) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrap) {
        WrapperCache cache = CONSTANT_FUNCTIONS[0];
        MethodHandle mh = cache.get(wrap);
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(wrap.primitiveType());
        switch (wrap) {
            case VOID: {
                mh = Handles.EMPTY;
                break;
            }
            case OBJECT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    mh = IMPL_LOOKUP.findStatic(THIS_CLASS, "zero" + wrap.wrapperSimpleName(), type);
                    break;
                }
                catch (ReflectiveOperationException ex) {
                    mh = null;
                }
            }
        }
        if (mh != null) {
            return cache.put(wrap, mh);
        }
        if (wrap.isSubwordOrInt() && wrap != Wrapper.INT) {
            mh = MethodHandles.explicitCastArguments(ValueConversions.zeroConstantFunction(Wrapper.INT), type);
            return cache.put(wrap, mh);
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrap));
    }

    public static MethodHandle ignore() {
        return Handles.IGNORE;
    }

    public static MethodHandle cast() {
        return Handles.CAST_REFERENCE;
    }

    static float doubleToFloat(double x) {
        return (float)x;
    }

    static long doubleToLong(double x) {
        return (long)x;
    }

    static int doubleToInt(double x) {
        return (int)x;
    }

    static short doubleToShort(double x) {
        return (short)x;
    }

    static char doubleToChar(double x) {
        return (char)x;
    }

    static byte doubleToByte(double x) {
        return (byte)x;
    }

    static boolean doubleToBoolean(double x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double floatToDouble(float x) {
        return x;
    }

    static long floatToLong(float x) {
        return (long)x;
    }

    static int floatToInt(float x) {
        return (int)x;
    }

    static short floatToShort(float x) {
        return (short)x;
    }

    static char floatToChar(float x) {
        return (char)x;
    }

    static byte floatToByte(float x) {
        return (byte)x;
    }

    static boolean floatToBoolean(float x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double longToDouble(long x) {
        return x;
    }

    static float longToFloat(long x) {
        return x;
    }

    static int longToInt(long x) {
        return (int)x;
    }

    static short longToShort(long x) {
        return (short)x;
    }

    static char longToChar(long x) {
        return (char)x;
    }

    static byte longToByte(long x) {
        return (byte)x;
    }

    static boolean longToBoolean(long x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double intToDouble(int x) {
        return x;
    }

    static float intToFloat(int x) {
        return x;
    }

    static long intToLong(int x) {
        return x;
    }

    static short intToShort(int x) {
        return (short)x;
    }

    static char intToChar(int x) {
        return (char)x;
    }

    static byte intToByte(int x) {
        return (byte)x;
    }

    static boolean intToBoolean(int x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double shortToDouble(short x) {
        return x;
    }

    static float shortToFloat(short x) {
        return x;
    }

    static long shortToLong(short x) {
        return x;
    }

    static int shortToInt(short x) {
        return x;
    }

    static char shortToChar(short x) {
        return (char)x;
    }

    static byte shortToByte(short x) {
        return (byte)x;
    }

    static boolean shortToBoolean(short x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double charToDouble(char x) {
        return x;
    }

    static float charToFloat(char x) {
        return x;
    }

    static long charToLong(char x) {
        return x;
    }

    static int charToInt(char x) {
        return x;
    }

    static short charToShort(char x) {
        return (short)x;
    }

    static byte charToByte(char x) {
        return (byte)x;
    }

    static boolean charToBoolean(char x) {
        return ValueConversions.toBoolean((byte)x);
    }

    static double byteToDouble(byte x) {
        return x;
    }

    static float byteToFloat(byte x) {
        return x;
    }

    static long byteToLong(byte x) {
        return x;
    }

    static int byteToInt(byte x) {
        return x;
    }

    static short byteToShort(byte x) {
        return x;
    }

    static char byteToChar(byte x) {
        return (char)x;
    }

    static boolean byteToBoolean(byte x) {
        return ValueConversions.toBoolean(x);
    }

    static double booleanToDouble(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static float booleanToFloat(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static long booleanToLong(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static int booleanToInt(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static short booleanToShort(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static char booleanToChar(boolean x) {
        return (char)ValueConversions.fromBoolean(x);
    }

    static byte booleanToByte(boolean x) {
        return ValueConversions.fromBoolean(x);
    }

    static boolean toBoolean(byte x) {
        return (x & 1) != 0;
    }

    static byte fromBoolean(boolean x) {
        return x ? (byte)1 : 0;
    }

    public static MethodHandle convertPrimitive(Wrapper wsrc, Wrapper wdst) {
        WrapperCache cache = CONVERT_PRIMITIVE_FUNCTIONS[wsrc.ordinal()];
        MethodHandle mh = cache.get(wdst);
        if (mh != null) {
            return mh;
        }
        Class<?> src = wsrc.primitiveType();
        Class<?> dst = wdst.primitiveType();
        MethodType type = MethodType.methodType(dst, src);
        if (wsrc == wdst) {
            mh = MethodHandles.identity(src);
        } else {
            assert (src.isPrimitive() && dst.isPrimitive());
            try {
                mh = IMPL_LOOKUP.findStatic(THIS_CLASS, src.getSimpleName() + "To" + ValueConversions.capitalize(dst.getSimpleName()), type);
            }
            catch (ReflectiveOperationException ex) {
                mh = null;
            }
        }
        if (mh != null) {
            assert (mh.type() == type) : mh;
            return cache.put(wdst, mh);
        }
        throw new IllegalArgumentException("cannot find primitive conversion function for " + src.getSimpleName() + " -> " + dst.getSimpleName());
    }

    public static MethodHandle convertPrimitive(Class<?> src, Class<?> dst) {
        return ValueConversions.convertPrimitive(Wrapper.forPrimitiveType(src), Wrapper.forPrimitiveType(dst));
    }

    private static String capitalize(String x) {
        return Character.toUpperCase(x.charAt(0)) + x.substring(1);
    }

    private static InternalError newInternalError(String message, Throwable cause) {
        return new InternalError(message, cause);
    }

    private static InternalError newInternalError(Throwable cause) {
        return new InternalError(cause);
    }

    private static class WrapperCache {
        @Stable
        private final MethodHandle[] map = new MethodHandle[10];

        private WrapperCache() {
        }

        public MethodHandle get(Wrapper w) {
            return this.map[w.ordinal()];
        }

        public synchronized MethodHandle put(Wrapper w, MethodHandle mh) {
            MethodHandle prev = this.map[w.ordinal()];
            if (prev != null) {
                return prev;
            }
            this.map[w.ordinal()] = mh;
            return mh;
        }
    }

    private static class Handles {
        static final MethodHandle CAST_REFERENCE;
        static final MethodHandle IGNORE;
        static final MethodHandle EMPTY;

        private Handles() {
        }

        static {
            try {
                MethodType idType = MethodType.genericMethodType(1);
                MethodType ignoreType = idType.changeReturnType(Void.TYPE);
                CAST_REFERENCE = IMPL_LOOKUP.findVirtual(Class.class, "cast", idType);
                IGNORE = IMPL_LOOKUP.findStatic(THIS_CLASS, "ignore", ignoreType);
                EMPTY = IMPL_LOOKUP.findStatic(THIS_CLASS, "empty", ignoreType.dropParameterTypes(0, 1));
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw ValueConversions.newInternalError("uncaught exception", ex);
            }
        }
    }
}

