/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.misc.VM;
import jdk.internal.reflect.Reflection;

public class VerifyAccess {
    private static final int UNCONDITIONAL_ALLOWED = 32;
    private static final int ORIGINAL_ALLOWED = 64;
    private static final int MODULE_ALLOWED = 16;
    private static final int PACKAGE_ONLY = 0;
    private static final int PACKAGE_ALLOWED = 8;
    private static final int PROTECTED_OR_PACKAGE_ALLOWED = 12;
    private static final int ALL_ACCESS_MODES = 7;

    private VerifyAccess() {
    }

    public static boolean isMemberAccessible(Class<?> refc, Class<?> defc, int mods, Class<?> lookupClass, Class<?> prevLookupClass, int allowedModes) {
        if (allowedModes == 0) {
            return false;
        }
        assert ((allowedModes & 0xFFFFFF80) == 0);
        if (!VerifyAccess.isClassAccessible(refc, lookupClass, prevLookupClass, allowedModes)) {
            return false;
        }
        if (defc == lookupClass && (allowedModes & 2) != 0) {
            return true;
        }
        switch (mods & 7) {
            case 1: {
                assert ((allowedModes & 1) != 0 || (allowedModes & 0x20) != 0);
                return true;
            }
            case 4: {
                assert (!defc.isInterface());
                if ((allowedModes & 0xC) != 0 && VerifyAccess.isSamePackage(defc, lookupClass)) {
                    return true;
                }
                if ((allowedModes & 4) == 0) {
                    return false;
                }
                if ((mods & 8) != 0 && !VerifyAccess.isRelatedClass(refc, lookupClass)) {
                    return false;
                }
                return (allowedModes & 4) != 0 && VerifyAccess.isSubClass(lookupClass, defc);
            }
            case 0: {
                assert (!defc.isInterface());
                return (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(defc, lookupClass);
            }
            case 2: {
                boolean canAccess;
                boolean bl = canAccess = (allowedModes & 2) != 0 && Reflection.areNestMates(defc, lookupClass);
                assert (canAccess && refc == defc || !canAccess);
                return canAccess;
            }
        }
        throw new IllegalArgumentException("bad modifiers: " + Modifier.toString(mods));
    }

    static boolean isRelatedClass(Class<?> refc, Class<?> lookupClass) {
        return refc == lookupClass || VerifyAccess.isSubClass(refc, lookupClass) || VerifyAccess.isSubClass(lookupClass, refc);
    }

    static boolean isSubClass(Class<?> lookupClass, Class<?> defc) {
        return defc.isAssignableFrom(lookupClass) && !lookupClass.isInterface();
    }

    static int getClassModifiers(Class<?> c) {
        if (c.isArray() || c.isPrimitive()) {
            return c.getModifiers();
        }
        return Reflection.getClassAccessFlags(c);
    }

    public static boolean isClassAccessible(Class<?> refc, Class<?> lookupClass, Class<?> prevLookupClass, int allowedModes) {
        if (allowedModes == 0) {
            return false;
        }
        assert ((allowedModes & 0xFFFFFF80) == 0);
        if ((allowedModes & 8) != 0 && VerifyAccess.isSamePackage(lookupClass, refc)) {
            return true;
        }
        int mods = VerifyAccess.getClassModifiers(refc);
        if (Modifier.isPublic(mods)) {
            Module prevLookupModule;
            Module lookupModule = lookupClass.getModule();
            Module refModule = refc.getModule();
            if (lookupModule == null) {
                assert (refModule == null);
                return true;
            }
            if ((allowedModes & 0x20) != 0) {
                return refModule.isExported(refc.getPackageName());
            }
            if (lookupModule == refModule && prevLookupClass == null) {
                if ((allowedModes & 0x10) != 0) {
                    return true;
                }
                assert ((allowedModes & 1) != 0);
                return refModule.isExported(refc.getPackageName());
            }
            Module module = prevLookupModule = prevLookupClass != null ? prevLookupClass.getModule() : null;
            assert (refModule != lookupModule || refModule != prevLookupModule);
            if (VerifyAccess.isModuleAccessible(refc, lookupModule, prevLookupModule)) {
                return true;
            }
            return !VM.isModuleSystemInited();
        }
        return false;
    }

    public static boolean isModuleAccessible(Class<?> refc, Module m1, Module m2) {
        String pn;
        Module refModule = refc.getModule();
        assert (refModule != m1 || refModule != m2);
        int mods = VerifyAccess.getClassModifiers(refc);
        return !(!Modifier.isPublic(mods) || !m1.canRead(refModule) || m2 != null && !m2.canRead(refModule) || !refModule.isExported(pn = refc.getPackageName(), m1) || m2 != null && !refModule.isExported(pn, m2));
    }

    public static boolean isTypeVisible(Class<?> type, Class<?> refc) {
        ClassLoader refcLoader;
        if (type == refc) {
            return true;
        }
        while (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.isPrimitive() || type == Object.class) {
            return true;
        }
        ClassLoader typeLoader = type.getClassLoader();
        if (typeLoader == (refcLoader = refc.getClassLoader())) {
            return true;
        }
        if (refcLoader == null && typeLoader != null) {
            return false;
        }
        if (typeLoader == null && type.getName().startsWith("java.")) {
            return true;
        }
        final String name = type.getName();
        Class res = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(name, false, refcLoader);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    return null;
                }
            }
        });
        return type == res;
    }

    public static boolean isTypeVisible(MethodType type, Class<?> refc) {
        if (!VerifyAccess.isTypeVisible(type.returnType(), refc)) {
            return false;
        }
        int max = type.parameterCount();
        for (int n = 0; n < max; ++n) {
            if (VerifyAccess.isTypeVisible(type.parameterType(n), refc)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameModule(Class<?> class1, Class<?> class2) {
        return class1.getModule() == class2.getModule();
    }

    public static boolean isSamePackage(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return true;
        }
        if (class1.getClassLoader() != class2.getClassLoader()) {
            return false;
        }
        return class1.getPackageName() == class2.getPackageName();
    }

    public static boolean isSamePackageMember(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return true;
        }
        if (!VerifyAccess.isSamePackage(class1, class2)) {
            return false;
        }
        return VerifyAccess.getOutermostEnclosingClass(class1) == VerifyAccess.getOutermostEnclosingClass(class2);
    }

    private static Class<?> getOutermostEnclosingClass(Class<?> c) {
        Class<?> pkgmem = c;
        Class<?> enc = c;
        while ((enc = enc.getEnclosingClass()) != null) {
            pkgmem = enc;
        }
        return pkgmem;
    }

    private static boolean loadersAreRelated(ClassLoader loader1, ClassLoader loader2, boolean loader1MustBeParent) {
        if (loader1 == loader2 || loader1 == null || loader2 == null && !loader1MustBeParent) {
            return true;
        }
        for (ClassLoader scan2 = loader2; scan2 != null; scan2 = scan2.getParent()) {
            if (scan2 != loader1) continue;
            return true;
        }
        if (loader1MustBeParent) {
            return false;
        }
        for (ClassLoader scan1 = loader1; scan1 != null; scan1 = scan1.getParent()) {
            if (scan1 != loader2) continue;
            return true;
        }
        return false;
    }

    public static boolean classLoaderIsAncestor(Class<?> parentClass, Class<?> childClass) {
        return VerifyAccess.loadersAreRelated(parentClass.getClassLoader(), childClass.getClassLoader(), true);
    }
}

