/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleBootstrap;
import jdk.internal.module.Modules;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;

public final class LauncherHelper {
    private static final String JAVAFX_APPLICATION_MARKER = "JavaFX-Application-Class";
    private static final String JAVAFX_APPLICATION_CLASS_NAME = "javafx.application.Application";
    private static final String JAVAFX_FXHELPER_CLASS_NAME_SUFFIX = "sun.launcher.LauncherHelper$FXHelper";
    private static final String LAUNCHER_AGENT_CLASS = "Launcher-Agent-Class";
    private static final String MAIN_CLASS = "Main-Class";
    private static final String ADD_EXPORTS = "Add-Exports";
    private static final String ADD_OPENS = "Add-Opens";
    private static StringBuilder outBuf = new StringBuilder();
    private static final String INDENT = "    ";
    private static final String VM_SETTINGS = "VM settings:";
    private static final String PROP_SETTINGS = "Property settings:";
    private static final String LOCALE_SETTINGS = "Locale settings:";
    private static final String diagprop = "sun.java.launcher.diag";
    static final boolean trace = VM.getSavedProperty("sun.java.launcher.diag") != null;
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static PrintStream ostream;
    private static Class<?> appClass;
    private static final int LM_UNKNOWN = 0;
    private static final int LM_CLASS = 1;
    private static final int LM_JAR = 2;
    private static final int LM_MODULE = 3;
    private static final int LM_SOURCE = 4;
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding;
    private static boolean isCharsetSupported;

    private LauncherHelper() {
    }

    static void showSettings(boolean printToStderr, String optionFlag, long initialHeapSize, long maxHeapSize, long stackSize) {
        String optStr;
        LauncherHelper.initOutput(printToStderr);
        String[] opts = optionFlag.split(":");
        switch (optStr = opts.length > 1 && opts[1] != null ? opts[1].trim() : "all") {
            case "vm": {
                LauncherHelper.printVmSettings(initialHeapSize, maxHeapSize, stackSize);
                break;
            }
            case "properties": {
                LauncherHelper.printProperties();
                break;
            }
            case "locale": {
                LauncherHelper.printLocale();
                break;
            }
            case "system": {
                if (System.getProperty("os.name").contains("Linux")) {
                    LauncherHelper.printSystemMetrics();
                    break;
                }
            }
            default: {
                LauncherHelper.printVmSettings(initialHeapSize, maxHeapSize, stackSize);
                LauncherHelper.printProperties();
                LauncherHelper.printLocale();
                if (!System.getProperty("os.name").contains("Linux")) break;
                LauncherHelper.printSystemMetrics();
            }
        }
    }

    private static void printVmSettings(long initialHeapSize, long maxHeapSize, long stackSize) {
        ostream.println(VM_SETTINGS);
        if (stackSize != 0L) {
            ostream.println("    Stack Size: " + SizePrefix.scaleValue(stackSize));
        }
        if (initialHeapSize != 0L) {
            ostream.println("    Min. Heap Size: " + SizePrefix.scaleValue(initialHeapSize));
        }
        if (maxHeapSize != 0L) {
            ostream.println("    Max. Heap Size: " + SizePrefix.scaleValue(maxHeapSize));
        } else {
            ostream.println("    Max. Heap Size (Estimated): " + SizePrefix.scaleValue(Runtime.getRuntime().maxMemory()));
        }
        ostream.println("    Using VM: " + System.getProperty("java.vm.name"));
        ostream.println();
    }

    private static void printProperties() {
        Properties p = System.getProperties();
        ostream.println(PROP_SETTINGS);
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        sortedPropertyKeys.addAll(p.stringPropertyNames());
        Collections.sort(sortedPropertyKeys);
        for (String x : sortedPropertyKeys) {
            LauncherHelper.printPropertyValue(x, p.getProperty(x));
        }
        ostream.println();
    }

    private static boolean isPath(String key) {
        return key.endsWith(".dirs") || key.endsWith(".path");
    }

    private static void printPropertyValue(String key, String value) {
        ostream.print(INDENT + key + " = ");
        if (key.equals("line.separator")) {
            block4: for (byte b : value.getBytes()) {
                switch (b) {
                    case 13: {
                        ostream.print("\\r ");
                        continue block4;
                    }
                    case 10: {
                        ostream.print("\\n ");
                        continue block4;
                    }
                    default: {
                        ostream.printf("0x%02X", b & 0xFF);
                    }
                }
            }
            ostream.println();
            return;
        }
        if (!LauncherHelper.isPath(key)) {
            ostream.println(value);
            return;
        }
        String[] values = value.split(System.getProperty("path.separator"));
        boolean first = true;
        for (String s : values) {
            if (first) {
                ostream.println(s);
                first = false;
                continue;
            }
            ostream.println("        " + s);
        }
    }

    private static void printLocale() {
        Locale locale = Locale.getDefault();
        ostream.println(LOCALE_SETTINGS);
        ostream.println("    default locale = " + locale.getDisplayName());
        ostream.println("    default display locale = " + Locale.getDefault(Locale.Category.DISPLAY).getDisplayName());
        ostream.println("    default format locale = " + Locale.getDefault(Locale.Category.FORMAT).getDisplayName());
        LauncherHelper.printLocales();
        ostream.println();
    }

    private static void printLocales() {
        int len;
        Locale[] tlocales = Locale.getAvailableLocales();
        int n = len = tlocales == null ? 0 : tlocales.length;
        if (len < 1) {
            return;
        }
        TreeSet<String> sortedSet = new TreeSet<String>();
        for (Locale l : tlocales) {
            sortedSet.add(l.toString());
        }
        ostream.print("    available locales = ");
        Iterator iter = sortedSet.iterator();
        int last = len - 1;
        int i = 0;
        while (iter.hasNext()) {
            String s = (String)iter.next();
            ostream.print(s);
            if (i != last) {
                ostream.print(", ");
            }
            if ((i + 1) % 8 == 0) {
                ostream.println();
                ostream.print("        ");
            }
            ++i;
        }
    }

    public static void printSystemMetrics() {
        int i;
        int[] mems;
        int i2;
        Metrics c = Container.metrics();
        ostream.println("Operating System Metrics:");
        if (c == null) {
            ostream.println("    No metrics available for this platform");
            return;
        }
        long longRetvalNotSupported = -2L;
        ostream.println("    Provider: " + c.getProvider());
        ostream.println("    Effective CPU Count: " + c.getEffectiveCpuCount());
        ostream.println(LauncherHelper.formatCpuVal(c.getCpuPeriod(), "    CPU Period: ", -2L));
        ostream.println(LauncherHelper.formatCpuVal(c.getCpuQuota(), "    CPU Quota: ", -2L));
        ostream.println(LauncherHelper.formatCpuVal(c.getCpuShares(), "    CPU Shares: ", -2L));
        int[] cpus = c.getCpuSetCpus();
        if (cpus != null) {
            ostream.println("    List of Processors, " + cpus.length + " total: ");
            ostream.print(INDENT);
            for (i2 = 0; i2 < cpus.length; ++i2) {
                ostream.print(cpus[i2] + " ");
            }
            if (cpus.length > 0) {
                ostream.println("");
            }
        } else {
            ostream.println("    List of Processors: N/A");
        }
        if ((cpus = c.getEffectiveCpuSetCpus()) != null) {
            ostream.println("    List of Effective Processors, " + cpus.length + " total: ");
            ostream.print(INDENT);
            for (i2 = 0; i2 < cpus.length; ++i2) {
                ostream.print(cpus[i2] + " ");
            }
            if (cpus.length > 0) {
                ostream.println("");
            }
        } else {
            ostream.println("    List of Effective Processors: N/A");
        }
        if ((mems = c.getCpuSetMems()) != null) {
            ostream.println("    List of Memory Nodes, " + mems.length + " total: ");
            ostream.print(INDENT);
            for (i = 0; i < mems.length; ++i) {
                ostream.print(mems[i] + " ");
            }
            if (mems.length > 0) {
                ostream.println("");
            }
        } else {
            ostream.println("    List of Memory Nodes: N/A");
        }
        if ((mems = c.getEffectiveCpuSetMems()) != null) {
            ostream.println("    List of Available Memory Nodes, " + mems.length + " total: ");
            ostream.print(INDENT);
            for (i = 0; i < mems.length; ++i) {
                ostream.print(mems[i] + " ");
            }
            if (mems.length > 0) {
                ostream.println("");
            }
        } else {
            ostream.println("    List of Available Memory Nodes: N/A");
        }
        long limit = c.getMemoryLimit();
        ostream.println(LauncherHelper.formatLimitString(limit, "    Memory Limit: ", -2L));
        limit = c.getMemorySoftLimit();
        ostream.println(LauncherHelper.formatLimitString(limit, "    Memory Soft Limit: ", -2L));
        limit = c.getMemoryAndSwapLimit();
        ostream.println(LauncherHelper.formatLimitString(limit, "    Memory & Swap Limit: ", -2L));
        ostream.println("");
    }

    private static String formatLimitString(long limit, String prefix, long unavailable) {
        if (limit >= 0L) {
            return prefix + SizePrefix.scaleValue(limit);
        }
        if (limit == unavailable) {
            return prefix + "N/A";
        }
        return prefix + "Unlimited";
    }

    private static String formatCpuVal(long cpuVal, String prefix, long unavailable) {
        if (cpuVal >= 0L) {
            return prefix + cpuVal + "us";
        }
        if (cpuVal == unavailable) {
            return prefix + "N/A";
        }
        return prefix + cpuVal;
    }

    private static String getLocalizedMessage(String key, Object ... args) {
        String msg = ResourceBundleHolder.RB.getString(key);
        return args != null ? MessageFormat.format(msg, args) : msg;
    }

    static void initHelpMessage(String progname) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", progname == null ? "java" : progname));
    }

    static void appendVmSelectMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", vm1, vm2));
    }

    static void appendVmSynonymMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", vm1, vm2));
    }

    static void printHelpMessage(boolean printToStderr) {
        LauncherHelper.initOutput(printToStderr);
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        ostream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean printToStderr) {
        LauncherHelper.initOutput(printToStderr);
        ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
        if (System.getProperty("os.name").contains("OS X")) {
            ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.macosx.usage", File.pathSeparator));
        }
    }

    static void initOutput(boolean printToStderr) {
        ostream = printToStderr ? System.err : System.out;
    }

    static void initOutput(PrintStream ps) {
        ostream = ps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getMainClassFromJar(String jarname) {
        try (JarFile jarFile = new JarFile(jarname);){
            String opens;
            String exports;
            String agentClass;
            String mainValue;
            Attributes mainAttrs;
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error2", jarname);
            }
            if ((mainAttrs = manifest.getMainAttributes()) == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error3", jarname);
            }
            if ((mainValue = mainAttrs.getValue(MAIN_CLASS)) == null) {
                LauncherHelper.abort(null, "java.launcher.jar.error3", jarname);
            }
            if ((agentClass = mainAttrs.getValue(LAUNCHER_AGENT_CLASS)) != null) {
                ModuleLayer.boot().findModule("java.instrument").ifPresent(m -> {
                    try {
                        String cn = "sun.instrument.InstrumentationImpl";
                        Class<?> clazz = Class.forName(cn, false, null);
                        Method loadAgent = clazz.getMethod("loadAgent", String.class);
                        loadAgent.invoke(null, jarname);
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = e.getCause();
                        }
                        LauncherHelper.abort(e, "java.launcher.jar.error4", jarname);
                    }
                });
            }
            if ((exports = mainAttrs.getValue(ADD_EXPORTS)) != null) {
                LauncherHelper.addExportsOrOpens(exports, false);
            }
            if ((opens = mainAttrs.getValue(ADD_OPENS)) != null) {
                LauncherHelper.addExportsOrOpens(opens, true);
            }
            if (mainAttrs.containsKey(new Attributes.Name(JAVAFX_APPLICATION_MARKER))) {
                FXHelper.setFXLaunchParameters(jarname, 2);
                String string = FXHelper.class.getName();
                return string;
            }
            String string = mainValue.trim();
            return string;
        }
        catch (IOException ioe) {
            LauncherHelper.abort(ioe, "java.launcher.jar.error1", jarname);
            return null;
        }
    }

    static void addExportsOrOpens(String value, boolean open) {
        for (String moduleAndPackage : value.split(" ")) {
            String[] s = moduleAndPackage.trim().split("/");
            if (s.length != 2) continue;
            String mn = s[0];
            String pn = s[1];
            ModuleLayer.boot().findModule(mn).filter(m -> m.getDescriptor().packages().contains(pn)).ifPresent(m -> {
                if (open) {
                    Modules.addOpensToAllUnnamed(m, pn);
                } else {
                    Modules.addExportsToAllUnnamed(m, pn);
                }
            });
        }
    }

    static void abort(Throwable t, String msgKey, Object ... args) {
        if (msgKey != null) {
            ostream.println(LauncherHelper.getLocalizedMessage(msgKey, args));
        }
        if (trace) {
            if (t != null) {
                t.printStackTrace();
            } else {
                Thread.dumpStack();
            }
        }
        System.exit(1);
    }

    public static Class<?> checkAndLoadMain(boolean printToStderr, int mode, String what) {
        LauncherHelper.initOutput(printToStderr);
        Class<Object> mainClass = null;
        switch (mode) {
            case 3: 
            case 4: {
                mainClass = LauncherHelper.loadModuleMainClass(what);
                break;
            }
            default: {
                mainClass = LauncherHelper.loadMainClass(mode, what);
            }
        }
        appClass = mainClass;
        if (JAVAFX_FXHELPER_CLASS_NAME_SUFFIX.equals(mainClass.getName()) || LauncherHelper.doesExtendFXApplication(mainClass)) {
            FXHelper.setFXLaunchParameters(what, mode);
            mainClass = FXHelper.class;
        }
        LauncherHelper.validateMainClass(mainClass);
        return mainClass;
    }

    private static Class<?> loadModuleMainClass(String what) {
        String mainClass;
        String mainModule;
        int i = what.indexOf(47);
        if (i == -1) {
            mainModule = what;
            mainClass = null;
        } else {
            mainModule = what.substring(0, i);
            mainClass = what.substring(i + 1);
        }
        ModuleLayer layer = ModuleLayer.boot();
        Optional<Module> om = layer.findModule(mainModule);
        if (!om.isPresent()) {
            throw new InternalError("Module " + mainModule + " not in boot Layer");
        }
        Module m = om.get();
        if (mainClass == null) {
            Optional<String> omc = m.getDescriptor().mainClass();
            if (!omc.isPresent()) {
                LauncherHelper.abort(null, "java.launcher.module.error1", mainModule);
            }
            mainClass = omc.get();
        }
        Class<?> c = null;
        try {
            c = Class.forName(m, mainClass);
            if (c == null && System.getProperty("os.name", "").contains("OS X") && Normalizer.isNormalized(mainClass, Normalizer.Form.NFD)) {
                String cn = Normalizer.normalize(mainClass, Normalizer.Form.NFC);
                c = Class.forName(m, cn);
            }
        }
        catch (LinkageError le) {
            LauncherHelper.abort(null, "java.launcher.module.error3", mainClass, m.getName(), le.getClass().getName() + ": " + le.getLocalizedMessage());
        }
        if (c == null) {
            LauncherHelper.abort(null, "java.launcher.module.error2", mainClass, mainModule);
        }
        System.setProperty("jdk.module.main.class", c.getName());
        return c;
    }

    private static Class<?> loadMainClass(int mode, String what) {
        Class<?> mainClass;
        block11: {
            String cn = switch (mode) {
                case 1 -> what;
                case 2 -> LauncherHelper.getMainClassFromJar(what);
                default -> throw new InternalError("" + mode + ": Unknown launch mode");
            };
            cn = cn.replace('/', '.');
            mainClass = null;
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            try {
                try {
                    mainClass = Class.forName(cn, false, scl);
                }
                catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
                    if (System.getProperty("os.name", "").contains("OS X") && Normalizer.isNormalized(cn, Normalizer.Form.NFD)) {
                        try {
                            String ncn = Normalizer.normalize(cn, Normalizer.Form.NFC);
                            mainClass = Class.forName(ncn, false, scl);
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError cnfe1) {
                            LauncherHelper.abort(cnfe1, "java.launcher.cls.error1", cn, cnfe1.getClass().getCanonicalName(), cnfe1.getMessage());
                        }
                        break block11;
                    }
                    LauncherHelper.abort(cnfe, "java.launcher.cls.error1", cn, cnfe.getClass().getCanonicalName(), cnfe.getMessage());
                }
            }
            catch (LinkageError le) {
                LauncherHelper.abort(le, "java.launcher.cls.error6", cn, le.getClass().getName() + ": " + le.getLocalizedMessage());
            }
        }
        return mainClass;
    }

    public static Class<?> getApplicationClass() {
        return appClass;
    }

    private static boolean doesExtendFXApplication(Class<?> mainClass) {
        for (Class<?> sc = mainClass.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            if (!sc.getName().equals(JAVAFX_APPLICATION_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }

    static void validateMainClass(Class<?> mainClass) {
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException nsme) {
            LauncherHelper.abort(null, "java.launcher.cls.error4", mainClass.getName(), JAVAFX_APPLICATION_CLASS_NAME);
        }
        catch (Throwable e) {
            if (mainClass.getModule().isNamed()) {
                LauncherHelper.abort(e, "java.launcher.module.error5", mainClass.getName(), mainClass.getModule().getName(), e.getClass().getName(), e.getLocalizedMessage());
            }
            LauncherHelper.abort(e, "java.launcher.cls.error7", mainClass.getName(), e.getClass().getName(), e.getLocalizedMessage());
        }
        int mod = mainMethod.getModifiers();
        if (!Modifier.isStatic(mod)) {
            LauncherHelper.abort(null, "java.launcher.cls.error2", "static", mainMethod.getDeclaringClass().getName());
        }
        if (mainMethod.getReturnType() != Void.TYPE) {
            LauncherHelper.abort(null, "java.launcher.cls.error3", mainMethod.getDeclaringClass().getName());
        }
    }

    static String makePlatformString(boolean printToStderr, byte[] inArray) {
        LauncherHelper.initOutput(printToStderr);
        if (encoding == null) {
            encoding = System.getProperty(encprop);
            isCharsetSupported = Charset.isSupported(encoding);
        }
        try {
            String out = isCharsetSupported ? new String(inArray, encoding) : new String(inArray);
            return out;
        }
        catch (UnsupportedEncodingException uee) {
            LauncherHelper.abort(uee, null, new Object[0]);
            return null;
        }
    }

    static String[] expandArgs(String[] argArray) {
        ArrayList<StdArg> aList = new ArrayList<StdArg>();
        for (String x : argArray) {
            aList.add(new StdArg(x));
        }
        return LauncherHelper.expandArgs(aList);
    }

    static String[] expandArgs(List<StdArg> argList) {
        ArrayList<String> out = new ArrayList<String>();
        if (trace) {
            System.err.println("Incoming arguments:");
        }
        for (StdArg a : argList) {
            if (trace) {
                System.err.println(a);
            }
            if (a.needsExpansion) {
                File x = new File(a.arg);
                File parent = x.getParentFile();
                String glob = x.getName();
                if (parent == null) {
                    parent = new File(".");
                }
                try (DirectoryStream<Path> dstream = Files.newDirectoryStream(parent.toPath(), glob);){
                    int entries = 0;
                    for (Path p : dstream) {
                        out.add(p.normalize().toString());
                        ++entries;
                    }
                    if (entries != 0) continue;
                    out.add(a.arg);
                }
                catch (Exception e) {
                    out.add(a.arg);
                    if (!trace) continue;
                    System.err.println("Warning: passing argument as-is " + a);
                    System.err.print(e);
                }
                continue;
            }
            out.add(a.arg);
        }
        String[] oarray = new String[out.size()];
        out.toArray(oarray);
        if (trace) {
            System.err.println("Expanded arguments:");
            for (String x : oarray) {
                System.err.println(x);
            }
        }
        return oarray;
    }

    static void listModules() {
        LauncherHelper.initOutput(System.out);
        ModuleBootstrap.limitedFinder().findAll().stream().sorted(new JrtFirstComparator()).forEach(LauncherHelper::showModule);
    }

    static void showResolvedModules() {
        LauncherHelper.initOutput(System.out);
        ModuleLayer bootLayer = ModuleLayer.boot();
        Configuration cf = bootLayer.configuration();
        cf.modules().stream().map(ResolvedModule::reference).sorted(new JrtFirstComparator()).forEach(LauncherHelper::showModule);
    }

    static void describeModule(String moduleName) {
        LauncherHelper.initOutput(System.out);
        ModuleFinder finder = ModuleBootstrap.limitedFinder();
        ModuleReference mref = finder.find(moduleName).orElse(null);
        if (mref == null) {
            LauncherHelper.abort(null, "java.launcher.module.error4", moduleName);
        }
        ModuleDescriptor md = mref.descriptor();
        LauncherHelper.showModule(mref);
        md.exports().stream().filter(e -> !e.isQualified()).sorted(Comparator.comparing(ModuleDescriptor.Exports::source)).map(e -> Stream.concat(Stream.of(e.source()), LauncherHelper.toStringStream(e.modifiers())).collect(Collectors.joining(" "))).forEach(sourceAndMods -> ostream.format("exports %s%n", sourceAndMods));
        for (ModuleDescriptor.Requires r : md.requires()) {
            String nameAndMods = Stream.concat(Stream.of(r.name()), LauncherHelper.toStringStream(r.modifiers())).collect(Collectors.joining(" "));
            ostream.format("requires %s", nameAndMods);
            finder.find(r.name()).map(ModuleReference::descriptor).filter(ModuleDescriptor::isAutomatic).ifPresent(any -> ostream.print(" automatic"));
            ostream.println();
        }
        for (String s : md.uses()) {
            ostream.format("uses %s%n", s);
        }
        for (ModuleDescriptor.Provides ps : md.provides()) {
            String names = ps.providers().stream().collect(Collectors.joining(" "));
            ostream.format("provides %s with %s%n", ps.service(), names);
        }
        for (ModuleDescriptor.Exports e2 : md.exports()) {
            if (!e2.isQualified()) continue;
            String who = e2.targets().stream().collect(Collectors.joining(" "));
            ostream.format("qualified exports %s to %s%n", e2.source(), who);
        }
        for (ModuleDescriptor.Opens opens : md.opens()) {
            if (opens.isQualified()) {
                ostream.print("qualified ");
            }
            String sourceAndMods2 = Stream.concat(Stream.of(opens.source()), LauncherHelper.toStringStream(opens.modifiers())).collect(Collectors.joining(" "));
            ostream.format("opens %s", sourceAndMods2);
            if (opens.isQualified()) {
                String who = opens.targets().stream().collect(Collectors.joining(" "));
                ostream.format(" to %s", who);
            }
            ostream.println();
        }
        TreeSet<String> concealed = new TreeSet<String>(md.packages());
        md.exports().stream().map(ModuleDescriptor.Exports::source).forEach(concealed::remove);
        md.opens().stream().map(ModuleDescriptor.Opens::source).forEach(concealed::remove);
        concealed.forEach(p -> ostream.format("contains %s%n", p));
    }

    private static void showModule(ModuleReference mref) {
        ModuleDescriptor md = mref.descriptor();
        ostream.print(md.toNameAndVersion());
        mref.location().filter(uri -> !LauncherHelper.isJrt(uri)).ifPresent(uri -> ostream.format(" %s", uri));
        if (md.isOpen()) {
            ostream.print(" open");
        }
        if (md.isAutomatic()) {
            ostream.print(" automatic");
        }
        ostream.println();
    }

    private static <T> Stream<String> toStringStream(Set<T> s) {
        return s.stream().map(e -> e.toString().toLowerCase());
    }

    private static boolean isJrt(ModuleReference mref) {
        return LauncherHelper.isJrt(mref.location().orElse(null));
    }

    private static boolean isJrt(URI uri) {
        return uri != null && uri.getScheme().equalsIgnoreCase("jrt");
    }

    static {
        encoding = null;
        isCharsetSupported = false;
    }

    private static enum SizePrefix {
        KILO(1024L, "K"),
        MEGA(0x100000L, "M"),
        GIGA(0x40000000L, "G"),
        TERA(0x10000000000L, "T");

        long size;
        String abbrev;

        private SizePrefix(long size, String abbrev) {
            this.size = size;
            this.abbrev = abbrev;
        }

        private static String scale(long v, SizePrefix prefix) {
            return BigDecimal.valueOf(v).divide(BigDecimal.valueOf(prefix.size), 2, RoundingMode.HALF_EVEN).toPlainString() + prefix.abbrev;
        }

        static String scaleValue(long v) {
            if (v < SizePrefix.MEGA.size) {
                return SizePrefix.scale(v, KILO);
            }
            if (v < SizePrefix.GIGA.size) {
                return SizePrefix.scale(v, MEGA);
            }
            if (v < SizePrefix.TERA.size) {
                return SizePrefix.scale(v, GIGA);
            }
            return SizePrefix.scale(v, TERA);
        }
    }

    private static class ResourceBundleHolder {
        private static final ResourceBundle RB = ResourceBundle.getBundle("sun.launcher.resources.launcher");

        private ResourceBundleHolder() {
        }
    }

    static final class FXHelper {
        private static final String JAVAFX_GRAPHICS_MODULE_NAME = "javafx.graphics";
        private static final String JAVAFX_LAUNCHER_CLASS_NAME = "com.sun.javafx.application.LauncherImpl";
        private static final String JAVAFX_LAUNCH_MODE_CLASS = "LM_CLASS";
        private static final String JAVAFX_LAUNCH_MODE_JAR = "LM_JAR";
        private static final String JAVAFX_LAUNCH_MODE_MODULE = "LM_MODULE";
        private static String fxLaunchName = null;
        private static String fxLaunchMode = null;
        private static Class<?> fxLauncherClass = null;
        private static Method fxLauncherMethod = null;

        FXHelper() {
        }

        private static void setFXLaunchParameters(String what, int mode) {
            Optional<Module> om = ModuleLayer.boot().findModule(JAVAFX_GRAPHICS_MODULE_NAME);
            if (!om.isPresent()) {
                LauncherHelper.abort(null, "java.launcher.cls.error5", new Object[0]);
            }
            if ((fxLauncherClass = Class.forName(om.get(), JAVAFX_LAUNCHER_CLASS_NAME)) == null) {
                LauncherHelper.abort(null, "java.launcher.cls.error5", new Object[0]);
            }
            try {
                fxLauncherMethod = fxLauncherClass.getMethod("launchApplication", String.class, String.class, String[].class);
                int mod = fxLauncherMethod.getModifiers();
                if (!Modifier.isStatic(mod)) {
                    LauncherHelper.abort(null, "java.launcher.javafx.error1", new Object[0]);
                }
                if (fxLauncherMethod.getReturnType() != Void.TYPE) {
                    LauncherHelper.abort(null, "java.launcher.javafx.error1", new Object[0]);
                }
            }
            catch (NoSuchMethodException ex) {
                LauncherHelper.abort(ex, "java.launcher.cls.error5", ex);
            }
            fxLaunchName = what;
            switch (mode) {
                case 1: {
                    fxLaunchMode = JAVAFX_LAUNCH_MODE_CLASS;
                    break;
                }
                case 2: {
                    fxLaunchMode = JAVAFX_LAUNCH_MODE_JAR;
                    break;
                }
                case 3: {
                    fxLaunchMode = JAVAFX_LAUNCH_MODE_MODULE;
                    break;
                }
                default: {
                    throw new InternalError(mode + ": Unknown launch mode");
                }
            }
        }

        public static void main(String ... args) throws Exception {
            if (fxLauncherMethod == null || fxLaunchMode == null || fxLaunchName == null) {
                throw new RuntimeException("Invalid JavaFX launch parameters");
            }
            fxLauncherMethod.invoke(null, fxLaunchName, fxLaunchMode, args);
        }
    }

    private static class StdArg {
        final String arg;
        final boolean needsExpansion;

        StdArg(String arg, boolean expand) {
            this.arg = arg;
            this.needsExpansion = expand;
        }

        StdArg(String in) {
            this.arg = in.substring(1);
            this.needsExpansion = in.charAt(0) == 'T';
        }

        public String toString() {
            return "StdArg{arg=" + this.arg + ", needsExpansion=" + this.needsExpansion + '}';
        }
    }

    private static class JrtFirstComparator
    implements Comparator<ModuleReference> {
        private final Comparator<ModuleReference> real = Comparator.comparing(ModuleReference::descriptor);

        JrtFirstComparator() {
        }

        @Override
        public int compare(ModuleReference a, ModuleReference b) {
            if (LauncherHelper.isJrt(a)) {
                return LauncherHelper.isJrt(b) ? this.real.compare(a, b) : -1;
            }
            return LauncherHelper.isJrt(b) ? 1 : this.real.compare(a, b);
        }
    }
}

