/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.action.GetPropertyAction;

public class ResourceManager {
    private static final int DEFAULT_MAX_SOCKETS = 25;
    private static final int maxSockets;
    private static final AtomicInteger numSockets;

    public static void beforeUdpCreate() throws SocketException {
        if (System.getSecurityManager() != null && numSockets.incrementAndGet() > maxSockets) {
            numSockets.decrementAndGet();
            throw new SocketException("maximum number of DatagramSockets reached");
        }
    }

    public static void afterUdpClose() {
        if (System.getSecurityManager() != null) {
            numSockets.decrementAndGet();
        }
    }

    static {
        String prop = GetPropertyAction.privilegedGetProperty("sun.net.maxDatagramSockets");
        int defmax = 25;
        try {
            if (prop != null) {
                defmax = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        maxSockets = defmax;
        numSockets = new AtomicInteger();
    }
}

