/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jdk.internal.loader.BootLoader;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private static boolean changed = true;
    private static long lastRefresh;
    private static final long TIMEOUT_NANOS;
    private static String os_searchlist;
    private static String os_nameservers;
    private static ArrayList<String> searchlist;
    private static ArrayList<String> nameservers;

    private ArrayList<String> stringToList(String str) {
        String[] tokens = str.split(",");
        ArrayList<String> l = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.isEmpty() || l.contains(s)) continue;
            l.add(s);
        }
        l.trimToSize();
        return l;
    }

    private ArrayList<String> addressesToList(String str) {
        String[] tokens = str.split(",");
        ArrayList<String> l = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.isEmpty()) continue;
            if (s.indexOf(58) >= 0 && s.charAt(0) != '[') {
                s = '[' + s + ']';
            }
            if (s.isEmpty() || l.contains(s)) continue;
            l.add(s);
        }
        l.trimToSize();
        return l;
    }

    private void loadConfig() {
        assert (Thread.holdsLock(lock));
        if (changed) {
            changed = false;
        } else {
            long currTime = System.nanoTime();
            if (currTime - lastRefresh < TIMEOUT_NANOS) {
                return;
            }
        }
        ResolverConfigurationImpl.loadDNSconfig0();
        lastRefresh = System.nanoTime();
        searchlist = this.stringToList(os_searchlist);
        nameservers = this.addressesToList(os_nameservers);
        os_searchlist = null;
        os_nameservers = null;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> searchlist() {
        Object object2 = lock;
        synchronized (object2) {
            this.loadConfig();
            return (List)searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> nameservers() {
        Object object2 = lock;
        synchronized (object2) {
            this.loadConfig();
            return (List)nameservers.clone();
        }
    }

    @Override
    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native void init0();

    static native void loadDNSconfig0();

    static native int notifyAddrChange0();

    static {
        TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(120L);
        BootLoader.loadLibrary("net");
        ResolverConfigurationImpl.init0();
        AddressChangeListener thr = new AddressChangeListener();
        thr.setDaemon(true);
        thr.start();
    }

    static class AddressChangeListener
    extends Thread {
        AddressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ResolverConfigurationImpl.notifyAddrChange0() == 0) {
                Object object2 = lock;
                synchronized (object2) {
                    changed = true;
                }
            }
            return;
        }
    }
}

