/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceConfigurationError;
import sun.net.ftp.FtpClient;
import sun.net.ftp.impl.DefaultFtpClientProvider;

public abstract class FtpClientProvider {
    private static final Object lock = new Object();
    private static FtpClientProvider provider = null;

    public abstract FtpClient createFtpClient();

    protected FtpClientProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("ftpClientProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String cm = System.getProperty("sun.net.ftpClientProvider");
        if (cm == null) {
            return false;
        }
        try {
            Object o = Class.forName(cm, true, null).newInstance();
            provider = (FtpClientProvider)o;
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException x) {
            throw new ServiceConfigurationError(x.toString());
        }
    }

    private static boolean loadProviderAsService() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FtpClientProvider provider() {
        Object object2 = lock;
        synchronized (object2) {
            if (provider != null) {
                return provider;
            }
            return (FtpClientProvider)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (FtpClientProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (FtpClientProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = new DefaultFtpClientProvider();
                    return provider;
                }
            });
        }
    }
}

