/*
 * Decompiled with CFR 0.152.
 */
package sun.net.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.util.SecurityProperties;

public final class SocketExceptions {
    private static final boolean enhancedExceptionText = SecurityProperties.includedInExceptions("hostInfo");

    private SocketExceptions() {
    }

    public static IOException of(IOException e, SocketAddress addr) {
        if (!enhancedExceptionText || addr == null) {
            return e;
        }
        if (addr instanceof UnixDomainSocketAddress) {
            return SocketExceptions.ofUnixDomain(e, (UnixDomainSocketAddress)addr);
        }
        if (addr instanceof InetSocketAddress) {
            return SocketExceptions.ofInet(e, (InetSocketAddress)addr);
        }
        return e;
    }

    private static IOException ofInet(IOException e, InetSocketAddress addr) {
        int port = addr.getPort();
        String host = addr.getHostString();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        sb.append(": ");
        sb.append(host);
        sb.append(':');
        sb.append(Integer.toString(port));
        String enhancedMsg = sb.toString();
        return SocketExceptions.create(e, enhancedMsg);
    }

    private static IOException ofUnixDomain(IOException e, UnixDomainSocketAddress addr) {
        String path = addr.getPath().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        sb.append(": ");
        sb.append(path);
        String enhancedMsg = sb.toString();
        return SocketExceptions.create(e, enhancedMsg);
    }

    private static IOException create(final IOException e, final String msg) {
        return AccessController.doPrivileged(new PrivilegedAction<IOException>(){

            @Override
            public IOException run() {
                try {
                    Class<?> clazz = e.getClass();
                    Constructor<?> ctor = clazz.getConstructor(String.class);
                    IOException e1 = (IOException)ctor.newInstance(msg);
                    e1.setStackTrace(e.getStackTrace());
                    return e1;
                }
                catch (Exception e0) {
                    return e;
                }
            }
        });
    }
}

