/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.util.StringJoiner;
import java.util.StringTokenizer;

public class MimeEntry
implements Cloneable {
    private String typeName;
    private String tempFileNameTemplate;
    private int action;
    private String command;
    private String description;
    private String imageFileName;
    private String[] fileExtensions;
    boolean starred;
    public static final int UNKNOWN = 0;
    public static final int LOAD_INTO_BROWSER = 1;
    public static final int SAVE_TO_FILE = 2;
    public static final int LAUNCH_APPLICATION = 3;
    static final String[] actionKeywords = new String[]{"unknown", "browser", "save", "application"};

    public MimeEntry(String type) {
        this(type, 0, null, null, null);
    }

    MimeEntry(String type, String imageFileName, String extensionString) {
        this.typeName = type.toLowerCase();
        this.action = 0;
        this.command = null;
        this.imageFileName = imageFileName;
        this.setExtensions(extensionString);
        this.starred = this.isStarred(this.typeName);
    }

    MimeEntry(String typeName, int action, String command, String tempFileNameTemplate) {
        this.typeName = typeName.toLowerCase();
        this.action = action;
        this.command = command;
        this.imageFileName = null;
        this.fileExtensions = null;
        this.tempFileNameTemplate = tempFileNameTemplate;
    }

    MimeEntry(String typeName, int action, String command, String imageFileName, String[] fileExtensions) {
        this.typeName = typeName.toLowerCase();
        this.action = action;
        this.command = command;
        this.imageFileName = imageFileName;
        this.fileExtensions = fileExtensions;
        this.starred = this.isStarred(typeName);
    }

    public synchronized String getType() {
        return this.typeName;
    }

    public synchronized void setType(String type) {
        this.typeName = type.toLowerCase();
    }

    public synchronized int getAction() {
        return this.action;
    }

    public synchronized void setAction(int action, String command) {
        this.action = action;
        this.command = command;
    }

    public synchronized void setAction(int action) {
        this.action = action;
    }

    public synchronized String getLaunchString() {
        return this.command;
    }

    public synchronized void setCommand(String command) {
        this.command = command;
    }

    public synchronized String getDescription() {
        return this.description != null ? this.description : this.typeName;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public synchronized void setImageFileName(String filename) {
        File file = new File(filename);
        this.imageFileName = file.getParent() == null ? System.getProperty("java.net.ftp.imagepath." + filename) : filename;
        if (filename.lastIndexOf(46) < 0) {
            this.imageFileName = this.imageFileName + ".gif";
        }
    }

    public String getTempFileTemplate() {
        return this.tempFileNameTemplate;
    }

    public synchronized String[] getExtensions() {
        return this.fileExtensions;
    }

    public synchronized String getExtensionsAsList() {
        String extensionsAsString = "";
        if (this.fileExtensions != null) {
            for (int i = 0; i < this.fileExtensions.length; ++i) {
                extensionsAsString = extensionsAsString + this.fileExtensions[i];
                if (i >= this.fileExtensions.length - 1) continue;
                extensionsAsString = extensionsAsString + ",";
            }
        }
        return extensionsAsString;
    }

    public synchronized void setExtensions(String extensionString) {
        StringTokenizer extTokens = new StringTokenizer(extensionString, ",");
        int numExts = extTokens.countTokens();
        String[] extensionStrings = new String[numExts];
        for (int i = 0; i < numExts; ++i) {
            String ext = (String)extTokens.nextElement();
            extensionStrings[i] = ext.trim();
        }
        this.fileExtensions = extensionStrings;
    }

    private boolean isStarred(String typeName) {
        return typeName != null && typeName.endsWith("/*");
    }

    public boolean matches(String type) {
        if (this.starred) {
            return type.startsWith(this.typeName);
        }
        return type.equals(this.typeName);
    }

    public Object clone() {
        MimeEntry theClone = new MimeEntry(this.typeName);
        theClone.action = this.action;
        theClone.command = this.command;
        theClone.description = this.description;
        theClone.imageFileName = this.imageFileName;
        theClone.tempFileNameTemplate = this.tempFileNameTemplate;
        theClone.fileExtensions = this.fileExtensions;
        return theClone;
    }

    public synchronized String toProperty() {
        String description;
        String extensions;
        String image;
        String command;
        StringJoiner sj = new StringJoiner("; ");
        int action = this.getAction();
        if (action != 0) {
            sj.add("action=" + actionKeywords[action]);
        }
        if ((command = this.getLaunchString()) != null && command.length() > 0) {
            sj.add("application=" + command);
        }
        if ((image = this.getImageFileName()) != null) {
            sj.add("icon=" + image);
        }
        if (!(extensions = this.getExtensionsAsList()).isEmpty()) {
            sj.add("file_extensions=" + extensions);
        }
        if ((description = this.getDescription()) != null && !description.equals(this.getType())) {
            sj.add("description=" + description);
        }
        return sj.toString();
    }

    public String toString() {
        return "MimeEntry[contentType=" + this.typeName + ", image=" + this.imageFileName + ", action=" + this.action + ", command=" + this.command + ", extensions=" + this.getExtensionsAsList() + "]";
    }
}

