/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HexFormat;
import sun.nio.cs.UTF_8;

public final class ParseUtil {
    private static final HexFormat HEX_UPPERCASE = HexFormat.of().withUpperCase();
    private static final long L_DIGIT = 0x3FF000000000000L;
    private static final long H_DIGIT = 0L;
    private static final long L_HEX = 0x3FF000000000000L;
    private static final long H_HEX = 0x7E0000007EL;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = 0x7FFFFFEL;
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = 576460743713488896L;
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = 576460743847706622L;
    private static final long L_ALPHANUM = 0x3FF000000000000L;
    private static final long H_ALPHANUM = 576460743847706622L;
    private static final long L_MARK = 113808043409408L;
    private static final long H_MARK = 0x4000000080000000L;
    private static final long L_UNRESERVED = 288062709218410496L;
    private static final long H_UNRESERVED = 5188146764422578174L;
    private static final long L_RESERVED = -6052670429821140992L;
    private static final long H_RESERVED = 671088641L;
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = -5764607720602730495L;
    private static final long H_URIC = 5188146765093666815L;
    private static final long L_PCHAR = 2882162826460266497L;
    private static final long H_PCHAR = 5188146764422578175L;
    private static final long L_PATH = 3458764316252045313L;
    private static final long H_PATH = 5188146764422578175L;
    private static final long L_DASH = 0x200000000000L;
    private static final long H_DASH = 0L;
    private static final long L_USERINFO = 3458623578763689985L;
    private static final long H_USERINFO = 5188146764422578174L;
    private static final long L_REG_NAME = 3458623578763689985L;
    private static final long H_REG_NAME = 5188146764422578175L;
    private static final long L_SERVER = 3458623578763689985L;
    private static final long H_SERVER = 5188146765093666815L;
    private static final long L_ENCODED = -576319817246572545L;
    private static final long H_ENCODED = -5188146764422578176L;

    private ParseUtil() {
    }

    public static String encodePath(String path) {
        return ParseUtil.encodePath(path, true);
    }

    public static String encodePath(String path, boolean flag) {
        if (flag && File.separatorChar != '/') {
            return ParseUtil.encodePath(path, 0, File.separatorChar);
        }
        int index = ParseUtil.firstEncodeIndex(path);
        if (index > -1) {
            return ParseUtil.encodePath(path, index, '/');
        }
        return path;
    }

    private static int firstEncodeIndex(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '&' && c <= ':' || c >= 'A' && c <= 'Z' || c <= '\u007f' && !ParseUtil.match(c, -576319817246572545L, -5188146764422578176L)) continue;
            return i;
        }
        return -1;
    }

    private static String encodePath(String path, int index, char sep) {
        char[] pathCC = path.toCharArray();
        char[] retCC = new char[pathCC.length * 2 + 16 - index];
        if (index > 0) {
            System.arraycopy(pathCC, 0, retCC, 0, index);
        }
        int retLen = index;
        for (int i = index; i < pathCC.length; ++i) {
            char c = pathCC[i];
            if (c == sep) {
                retCC[retLen++] = 47;
            } else if (c <= '\u007f') {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                    retCC[retLen++] = c;
                } else if (ParseUtil.match(c, -576319817246572545L, -5188146764422578176L)) {
                    retLen = ParseUtil.escape(retCC, c, retLen);
                } else {
                    retCC[retLen++] = c;
                }
            } else if (c > '\u07ff') {
                retLen = ParseUtil.escape(retCC, (char)(0xE0 | c >> 12 & 0xF), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 6 & 0x3F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            } else {
                retLen = ParseUtil.escape(retCC, (char)(0xC0 | c >> 6 & 0x1F), retLen);
                retLen = ParseUtil.escape(retCC, (char)(0x80 | c >> 0 & 0x3F), retLen);
            }
            if (retLen + 9 <= retCC.length) continue;
            int newLen = retCC.length * 2 + 16;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            char[] buf = new char[newLen];
            System.arraycopy(retCC, 0, buf, 0, retLen);
            retCC = buf;
        }
        return new String(retCC, 0, retLen);
    }

    private static int escape(char[] cc, char c, int index) {
        cc[index++] = 37;
        cc[index++] = Character.forDigit(c >> 4 & 0xF, 16);
        cc[index++] = Character.forDigit(c & 0xF, 16);
        return index;
    }

    private static byte unescape(String s, int i) {
        return (byte)Integer.parseInt(s, i + 1, i + 3, 16);
    }

    public static String decode(String s) {
        int n = s.length();
        if (n == 0 || s.indexOf(37) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = UTF_8.INSTANCE.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        char c = s.charAt(0);
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c != '%') {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            int ui = i;
            do {
                assert (n - i >= 2);
                try {
                    bb.put(ParseUtil.unescape(s, i));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            } while ((i += 3) < n && (c = s.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            if (cr.isError()) {
                throw new IllegalArgumentException("Error decoding percent encoded characters");
            }
            cr = dec.flush(cb);
            if (cr.isError()) {
                throw new IllegalArgumentException("Error decoding percent encoded characters");
            }
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (!(path = ParseUtil.encodePath(path)).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static URI toURI(URL url) {
        URI uri;
        String protocol = url.getProtocol();
        String auth = url.getAuthority();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (auth != null && auth.endsWith(":-1")) {
            auth = auth.substring(0, auth.length() - 3);
        }
        try {
            uri = ParseUtil.createURI(protocol, auth, path, query, ref);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        return uri;
    }

    private static URI createURI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        String s = ParseUtil.toString(scheme, null, authority, null, null, -1, path, query, fragment);
        ParseUtil.checkPath(s, scheme, path);
        return new URI(s);
    }

    private static String toString(String scheme, String opaquePart, String authority, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        ParseUtil.appendSchemeSpecificPart(sb, opaquePart, authority, userInfo, host, port, path, query);
        ParseUtil.appendFragment(sb, fragment);
        return sb.toString();
    }

    private static void appendSchemeSpecificPart(StringBuilder sb, String opaquePart, String authority, String userInfo, String host, int port, String path, String query) {
        if (opaquePart != null) {
            if (opaquePart.startsWith("//[")) {
                int end = opaquePart.indexOf(93);
                if (end != -1 && opaquePart.indexOf(58) != -1) {
                    String doquote;
                    String dontquote;
                    if (end == opaquePart.length()) {
                        dontquote = opaquePart;
                        doquote = "";
                    } else {
                        dontquote = opaquePart.substring(0, end + 1);
                        doquote = opaquePart.substring(end + 1);
                    }
                    sb.append(dontquote);
                    sb.append(ParseUtil.quote(doquote, -5764607720602730495L, 5188146765093666815L));
                }
            } else {
                sb.append(ParseUtil.quote(opaquePart, -5764607720602730495L, 5188146765093666815L));
            }
        } else {
            ParseUtil.appendAuthority(sb, authority, userInfo, host, port);
            if (path != null) {
                sb.append(ParseUtil.quote(path, 3458764316252045313L, 5188146764422578175L));
            }
            if (query != null) {
                sb.append('?');
                sb.append(ParseUtil.quote(query, -5764607720602730495L, 5188146765093666815L));
            }
        }
    }

    private static void appendAuthority(StringBuilder sb, String authority, String userInfo, String host, int port) {
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(ParseUtil.quote(userInfo, 3458623578763689985L, 5188146764422578174L));
                sb.append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        } else if (authority != null) {
            sb.append("//");
            if (authority.startsWith("[")) {
                int end = authority.indexOf(93);
                if (end != -1 && authority.indexOf(58) != -1) {
                    String doquote;
                    String dontquote;
                    if (end == authority.length()) {
                        dontquote = authority;
                        doquote = "";
                    } else {
                        dontquote = authority.substring(0, end + 1);
                        doquote = authority.substring(end + 1);
                    }
                    sb.append(dontquote);
                    sb.append(ParseUtil.quote(doquote, 3458623578763689985L, 5188146765093666815L));
                }
            } else {
                sb.append(ParseUtil.quote(authority, 3458623578763689985L, 5188146765093666815L));
            }
        }
    }

    private static void appendFragment(StringBuilder sb, String fragment) {
        if (fragment != null) {
            sb.append('#');
            sb.append(ParseUtil.quote(fragment, -5764607720602730495L, 5188146765093666815L));
        }
    }

    private static String quote(String s, long lowMask, long highMask) {
        int n = s.length();
        StringBuilder sb = null;
        CharsetEncoder encoder = null;
        boolean allowNonASCII = (lowMask & 1L) != 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (!ParseUtil.match(c, lowMask, highMask) && !ParseUtil.isEscaped(s, i)) {
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append(s, 0, i);
                    }
                    ParseUtil.appendEscape(sb, (byte)c);
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (allowNonASCII && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (encoder == null) {
                    encoder = UTF_8.INSTANCE.newEncoder();
                }
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(s, 0, i);
                }
                ParseUtil.appendEncoded(encoder, sb, c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    private static boolean isEscaped(String s, int pos) {
        if (s == null || s.length() <= pos + 2) {
            return false;
        }
        return s.charAt(pos) == '%' && ParseUtil.match(s.charAt(pos + 1), 0x3FF000000000000L, 0x7E0000007EL) && ParseUtil.match(s.charAt(pos + 2), 0x3FF000000000000L, 0x7E0000007EL);
    }

    private static void appendEncoded(CharsetEncoder encoder, StringBuilder sb, char c) {
        Buffer bb;
        block4: {
            bb = null;
            try {
                bb = encoder.encode(CharBuffer.wrap("" + c));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (bb.hasRemaining()) {
            int b = ((ByteBuffer)bb).get() & 0xFF;
            if (b >= 128) {
                ParseUtil.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        HEX_UPPERCASE.toHexDigits(sb, b);
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static void checkPath(String s, String scheme, String path) throws URISyntaxException {
        if (scheme != null && path != null && !path.isEmpty() && path.charAt(0) != '/') {
            throw new URISyntaxException(s, "Relative path in absolute URI");
        }
    }
}

