/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.nio.cs.US_ASCII;

public class ChunkedOutputStream
extends OutputStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int CRLF_SIZE = CRLF.length;
    private static final byte[] FOOTER = CRLF;
    private static final int FOOTER_SIZE = CRLF_SIZE;
    private static final byte[] EMPTY_CHUNK_HEADER = ChunkedOutputStream.getHeader(0);
    private static final int EMPTY_CHUNK_HEADER_SIZE = ChunkedOutputStream.getHeaderSize(0);
    private byte[] buf;
    private int size;
    private int count;
    private int spaceInCurrentChunk;
    private PrintStream out;
    private int preferredChunkDataSize;
    private int preferedHeaderSize;
    private int preferredChunkGrossSize;
    private byte[] completeHeader;
    private final Lock writeLock = new ReentrantLock();

    private static int getHeaderSize(int size) {
        return Integer.toHexString(size).length() + CRLF_SIZE;
    }

    private static byte[] getHeader(int size) {
        String hexStr = Integer.toHexString(size);
        byte[] hexBytes = hexStr.getBytes(US_ASCII.INSTANCE);
        byte[] header = new byte[ChunkedOutputStream.getHeaderSize(size)];
        for (int i = 0; i < hexBytes.length; ++i) {
            header[i] = hexBytes[i];
        }
        header[hexBytes.length] = CRLF[0];
        header[hexBytes.length + 1] = CRLF[1];
        return header;
    }

    public ChunkedOutputStream(PrintStream o) {
        this(o, 4096);
    }

    public ChunkedOutputStream(PrintStream o, int size) {
        this.out = o;
        if (size <= 0) {
            size = 4096;
        }
        if (size > 0) {
            int adjusted_size = size - ChunkedOutputStream.getHeaderSize(size) - FOOTER_SIZE;
            if (ChunkedOutputStream.getHeaderSize(adjusted_size + 1) < ChunkedOutputStream.getHeaderSize(size)) {
                ++adjusted_size;
            }
            size = adjusted_size;
        }
        this.preferredChunkDataSize = size > 0 ? size : 4096 - ChunkedOutputStream.getHeaderSize(4096) - FOOTER_SIZE;
        this.preferedHeaderSize = ChunkedOutputStream.getHeaderSize(this.preferredChunkDataSize);
        this.preferredChunkGrossSize = this.preferedHeaderSize + this.preferredChunkDataSize + FOOTER_SIZE;
        this.completeHeader = ChunkedOutputStream.getHeader(this.preferredChunkDataSize);
        this.buf = new byte[this.preferredChunkGrossSize];
        this.reset();
    }

    private void flush(boolean flushAll) {
        if (this.spaceInCurrentChunk == 0) {
            this.out.write(this.buf, 0, this.preferredChunkGrossSize);
            this.out.flush();
            this.reset();
        } else if (flushAll) {
            if (this.size > 0) {
                int adjustedHeaderStartIndex = this.preferedHeaderSize - ChunkedOutputStream.getHeaderSize(this.size);
                System.arraycopy(ChunkedOutputStream.getHeader(this.size), 0, this.buf, adjustedHeaderStartIndex, ChunkedOutputStream.getHeaderSize(this.size));
                this.buf[this.count++] = FOOTER[0];
                this.buf[this.count++] = FOOTER[1];
                this.out.write(this.buf, adjustedHeaderStartIndex, this.count - adjustedHeaderStartIndex);
            } else {
                this.out.write(EMPTY_CHUNK_HEADER, 0, EMPTY_CHUNK_HEADER_SIZE);
            }
            this.out.flush();
            this.reset();
        }
    }

    public boolean checkError() {
        PrintStream out = this.out;
        return out == null || out.checkError();
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeLock.lock();
        try {
            this.ensureOpen();
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int bytesToWrite = len;
            int inputIndex = off;
            do {
                if (bytesToWrite >= this.spaceInCurrentChunk) {
                    for (int i = 0; i < this.completeHeader.length; ++i) {
                        this.buf[i] = this.completeHeader[i];
                    }
                    System.arraycopy(b, inputIndex, this.buf, this.count, this.spaceInCurrentChunk);
                    inputIndex += this.spaceInCurrentChunk;
                    bytesToWrite -= this.spaceInCurrentChunk;
                    this.count += this.spaceInCurrentChunk;
                    this.buf[this.count++] = FOOTER[0];
                    this.buf[this.count++] = FOOTER[1];
                    this.spaceInCurrentChunk = 0;
                    this.flush(false);
                    if (!this.checkError()) continue;
                    break;
                }
                System.arraycopy(b, inputIndex, this.buf, this.count, bytesToWrite);
                this.count += bytesToWrite;
                this.size += bytesToWrite;
                this.spaceInCurrentChunk -= bytesToWrite;
                bytesToWrite = 0;
            } while (bytesToWrite > 0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void write(int _b) throws IOException {
        this.writeLock.lock();
        try {
            byte[] b = new byte[]{(byte)_b};
            this.write(b, 0, 1);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reset() {
        this.writeLock.lock();
        try {
            this.count = this.preferedHeaderSize;
            this.size = 0;
            this.spaceInCurrentChunk = this.preferredChunkDataSize;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            if (this.out == null) {
                return;
            }
            if (this.size > 0) {
                this.flush(true);
            }
            this.flush(true);
            this.out = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeLock.lock();
        try {
            this.ensureOpen();
            if (this.size > 0) {
                this.flush(true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

