/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.concurrent.locks.ReentrantLock;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;

class ClientVector
extends ArrayDeque<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    private final ReentrantLock lock = new ReentrantLock();
    int nap;

    ClientVector(int nap) {
        this.nap = nap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpClient get() {
        this.lock();
        try {
            if (this.isEmpty()) {
                HttpClient httpClient = null;
                return httpClient;
            }
            HttpClient hc = null;
            long currentTime = System.currentTimeMillis();
            do {
                KeepAliveEntry e = (KeepAliveEntry)this.pop();
                if (currentTime - e.idleStartTime > (long)this.nap) {
                    e.hc.closeServer();
                    continue;
                }
                hc = e.hc;
            } while (hc == null && !this.isEmpty());
            HttpClient httpClient = hc;
            return httpClient;
        }
        finally {
            this.unlock();
        }
    }

    void put(HttpClient h) {
        this.lock();
        try {
            if (this.size() >= KeepAliveCache.getMaxConnections()) {
                h.closeServer();
            } else {
                this.push(new KeepAliveEntry(h, System.currentTimeMillis()));
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(HttpClient h) {
        this.lock();
        try {
            for (KeepAliveEntry curr : this) {
                if (curr.hc != h) continue;
                boolean bl = super.remove(curr);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    final void lock() {
        this.lock.lock();
    }

    final void unlock() {
        this.lock.unlock();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

