/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import jdk.internal.misc.InnocuousThread;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends HashMap<KeepAliveKey, ClientVector>
implements Runnable {
    private static final long serialVersionUID = -2937172892064557949L;
    static final int MAX_CONNECTIONS = 5;
    static int result = -1;
    static final int LIFETIME = 5000;
    private final ReentrantLock cacheLock = new ReentrantLock();
    private Thread keepAliveTimer = null;

    static int getMaxConnections() {
        if (result == -1 && (result = AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 5)).intValue()) <= 0) {
            result = 5;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URL url, Object obj, HttpClient http) {
        this.cacheLock.lock();
        try {
            KeepAliveKey key;
            ClientVector v;
            boolean startThread;
            boolean bl = startThread = this.keepAliveTimer == null;
            if (!startThread && !this.keepAliveTimer.isAlive()) {
                startThread = true;
            }
            if (startThread) {
                this.clear();
                final KeepAliveCache cache = this;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        KeepAliveCache.this.keepAliveTimer = InnocuousThread.newSystemThread("Keep-Alive-Timer", cache);
                        KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                        KeepAliveCache.this.keepAliveTimer.setPriority(8);
                        KeepAliveCache.this.keepAliveTimer.start();
                        return null;
                    }
                });
            }
            if ((v = (ClientVector)super.get(key = new KeepAliveKey(url, obj))) == null) {
                int keepAliveTimeout = http.getKeepAliveTimeout();
                v = new ClientVector(keepAliveTimeout > 0 ? keepAliveTimeout * 1000 : 5000);
                v.put(http);
                super.put(key, v);
            } else {
                v.put(http);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HttpClient h, Object obj) {
        this.cacheLock.lock();
        try {
            KeepAliveKey key = new KeepAliveKey(h.url, obj);
            ClientVector v = (ClientVector)super.get(key);
            if (v != null) {
                v.remove(h);
                if (v.isEmpty()) {
                    this.removeVector(key);
                }
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void removeVector(KeepAliveKey k) {
        assert (this.cacheLock.isHeldByCurrentThread());
        super.remove(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient get(URL url, Object obj) {
        this.cacheLock.lock();
        try {
            KeepAliveKey key = new KeepAliveKey(url, obj);
            ClientVector v = (ClientVector)super.get(key);
            if (v == null) {
                HttpClient httpClient = null;
                return httpClient;
            }
            HttpClient httpClient = v.get();
            return httpClient;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cacheLock.lock();
            try {
                long currentTime = System.currentTimeMillis();
                ArrayList<KeepAliveKey> keysToRemove = new ArrayList<KeepAliveKey>();
                for (KeepAliveKey key : this.keySet()) {
                    ClientVector v = (ClientVector)this.get(key);
                    v.lock();
                    try {
                        KeepAliveEntry e = (KeepAliveEntry)v.peek();
                        while (e != null && currentTime - e.idleStartTime > (long)v.nap) {
                            v.poll();
                            e.hc.closeServer();
                            e = (KeepAliveEntry)v.peek();
                        }
                        if (!v.isEmpty()) continue;
                        keysToRemove.add(key);
                    }
                    finally {
                        v.unlock();
                    }
                }
                for (KeepAliveKey key : keysToRemove) {
                    this.removeVector(key);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        } while (!this.isEmpty());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

