/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetBooleanAction;

public abstract class AuthenticationInfo
extends AuthCacheValue
implements Cloneable {
    static final long serialVersionUID = -2588378268010453259L;
    public static final char SERVER_AUTHENTICATION = 's';
    public static final char PROXY_AUTHENTICATION = 'p';
    static final boolean serializeAuth = AccessController.doPrivileged(new GetBooleanAction("http.auth.serializeRequests"));
    protected transient PasswordAuthentication pw;
    private static final HashMap<String, Thread> requests = new HashMap();
    private static final ReentrantLock requestLock = new ReentrantLock();
    private static final Condition requestFinished = requestLock.newCondition();
    char type;
    AuthScheme authScheme;
    String protocol;
    String host;
    int port;
    String realm;
    String path;
    String authenticatorKey;
    String s1;
    String s2;

    @Override
    public PasswordAuthentication credentials() {
        return this.pw;
    }

    @Override
    public AuthCacheValue.Type getAuthType() {
        return this.type == 's' ? AuthCacheValue.Type.Server : AuthCacheValue.Type.Proxy;
    }

    @Override
    AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProtocolScheme() {
        return this.protocol;
    }

    protected boolean useAuthCache() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthenticationInfo requestAuthentication(String key, Function<String, AuthenticationInfo> cache) {
        AuthenticationInfo cached = cache.apply(key);
        if (cached != null || !serializeAuth) {
            return cached;
        }
        requestLock.lock();
        try {
            cached = cache.apply(key);
            if (cached != null) {
                AuthenticationInfo authenticationInfo = cached;
                return authenticationInfo;
            }
            Thread c = Thread.currentThread();
            Thread t = requests.get(key);
            if (t == null) {
                requests.put(key, c);
                assert (cached == null);
                AuthenticationInfo authenticationInfo = cached;
                return authenticationInfo;
            }
            if (t == c) {
                assert (cached == null);
                AuthenticationInfo authenticationInfo = cached;
                return authenticationInfo;
            }
            while (requests.containsKey(key)) {
                requestFinished.awaitUninterruptibly();
            }
        }
        finally {
            requestLock.unlock();
        }
        return cache.apply(key);
    }

    private static void requestCompleted(String key) {
        requestLock.lock();
        try {
            Thread thread = requests.get(key);
            if (thread != null && thread == Thread.currentThread()) {
                boolean waspresent;
                boolean bl = waspresent = requests.remove(key) != null;
                assert (waspresent);
            }
            requestFinished.signalAll();
        }
        finally {
            requestLock.unlock();
        }
    }

    public AuthenticationInfo(char type, AuthScheme authScheme, String host, int port, String realm, String authenticatorKey) {
        this.type = type;
        this.authScheme = authScheme;
        this.protocol = "";
        this.host = host.toLowerCase();
        this.port = port;
        this.realm = realm;
        this.path = null;
        this.authenticatorKey = Objects.requireNonNull(authenticatorKey);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AuthenticationInfo(char type, AuthScheme authScheme, URL url, String realm, String authenticatorKey) {
        this.type = type;
        this.authScheme = authScheme;
        this.protocol = url.getProtocol().toLowerCase();
        this.host = url.getHost().toLowerCase();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = url.getDefaultPort();
        }
        this.realm = realm;
        String urlPath = url.getPath();
        this.path = urlPath.isEmpty() ? urlPath : AuthenticationInfo.reducePath(urlPath);
        this.authenticatorKey = Objects.requireNonNull(authenticatorKey);
    }

    public final String getAuthenticatorKey() {
        return this.authenticatorKey;
    }

    static String reducePath(String urlPath) {
        int sepIndex = urlPath.lastIndexOf(47);
        int targetSuffixIndex = urlPath.lastIndexOf(46);
        if (sepIndex != -1) {
            if (sepIndex < targetSuffixIndex) {
                return urlPath.substring(0, sepIndex + 1);
            }
            return urlPath;
        }
        return urlPath;
    }

    static AuthenticationInfo getServerAuth(URL url, String authenticatorKey) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String key = "s:" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port + ";auth=" + authenticatorKey;
        return AuthenticationInfo.getAuth(key, url);
    }

    static String getServerAuthKey(URL url, String realm, AuthScheme scheme, String authenticatorKey) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String key = "s:" + (Object)((Object)scheme) + ":" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port + ":" + realm + ";auth=" + authenticatorKey;
        return key;
    }

    private static AuthenticationInfo getCachedServerAuth(String key) {
        return AuthenticationInfo.getAuth(key, null);
    }

    static AuthenticationInfo getServerAuth(String key) {
        if (!serializeAuth) {
            return AuthenticationInfo.getCachedServerAuth(key);
        }
        return AuthenticationInfo.requestAuthentication(key, AuthenticationInfo::getCachedServerAuth);
    }

    static AuthenticationInfo getAuth(String key, URL url) {
        if (url == null) {
            return (AuthenticationInfo)cache.get(key, null);
        }
        return (AuthenticationInfo)cache.get(key, url.getPath());
    }

    static AuthenticationInfo getProxyAuth(String host, int port, String authenticatorKey) {
        String key = "p::" + host.toLowerCase() + ":" + port + ";auth=" + authenticatorKey;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key, null);
        return result;
    }

    static String getProxyAuthKey(String host, int port, String realm, AuthScheme scheme, String authenticatorKey) {
        String key = "p:" + (Object)((Object)scheme) + "::" + host.toLowerCase() + ":" + port + ":" + realm + ";auth=" + authenticatorKey;
        return key;
    }

    private static AuthenticationInfo getCachedProxyAuth(String key) {
        return (AuthenticationInfo)cache.get(key, null);
    }

    static AuthenticationInfo getProxyAuth(String key) {
        if (!serializeAuth) {
            return AuthenticationInfo.getCachedProxyAuth(key);
        }
        return AuthenticationInfo.requestAuthentication(key, AuthenticationInfo::getCachedProxyAuth);
    }

    void addToCache() {
        String key = this.cacheKey(true);
        if (this.useAuthCache()) {
            cache.put(key, this);
            if (this.supportsPreemptiveAuthorization()) {
                cache.put(this.cacheKey(false), this);
            }
        }
        AuthenticationInfo.endAuthRequest(key);
    }

    static void endAuthRequest(String key) {
        if (!serializeAuth) {
            return;
        }
        AuthenticationInfo.requestCompleted(key);
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    public abstract boolean supportsPreemptiveAuthorization();

    public String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    public abstract String getHeaderValue(URL var1, String var2);

    public abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2, String var3);

    public abstract boolean isAuthorizationStale(String var1);

    String cacheKey(boolean includeRealm) {
        String authenticatorKey = this.getAuthenticatorKey();
        if (includeRealm) {
            return this.type + ":" + (Object)((Object)this.authScheme) + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm + ";auth=" + authenticatorKey;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port + ";auth=" + authenticatorKey;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.pw = new PasswordAuthentication(this.s1, this.s2.toCharArray());
        this.s1 = null;
        this.s2 = null;
        if (this.authenticatorKey == null) {
            this.authenticatorKey = "default";
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Objects.requireNonNull(this.authenticatorKey);
        this.s1 = this.pw.getUserName();
        this.s2 = new String(this.pw.getPassword());
        s.defaultWriteObject();
    }
}

