/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.UTF_8;

class BasicAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    final String auth;

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, PasswordAuthentication pw, boolean isUTF8, String authenticatorKey) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, host, port, realm, Objects.requireNonNull(authenticatorKey));
        this.auth = BasicAuthentication.authValueFrom(pw, isUTF8);
        this.pw = pw;
    }

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, String auth, String authenticatorKey) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, host, port, realm, Objects.requireNonNull(authenticatorKey));
        this.auth = "Basic " + auth;
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, PasswordAuthentication pw, boolean isUTF8, String authenticatorKey) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, url, realm, Objects.requireNonNull(authenticatorKey));
        this.auth = BasicAuthentication.authValueFrom(pw, isUTF8);
        this.pw = pw;
    }

    private static String authValueFrom(PasswordAuthentication pw, boolean isUTF8) {
        String plain2 = pw.getUserName() + ":";
        char[] password = pw.getPassword();
        CharBuffer cbuf = CharBuffer.allocate(plain2.length() + password.length);
        cbuf.put(plain2).put(password).flip();
        Charset charset = isUTF8 ? UTF_8.INSTANCE : ISO_8859_1.INSTANCE;
        ByteBuffer buf = charset.encode(cbuf);
        ByteBuffer enc = Base64.getEncoder().encode(buf);
        String ret = "Basic " + new String(enc.array(), enc.position(), enc.remaining(), ISO_8859_1.INSTANCE);
        Arrays.fill(buf.array(), (byte)0);
        Arrays.fill(enc.array(), (byte)0);
        Arrays.fill(cbuf.array(), '\u0000');
        return ret;
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, String auth, String authenticatorKey) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, url, realm, Objects.requireNonNull(authenticatorKey));
        this.auth = "Basic " + auth;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return true;
    }

    @Override
    public boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        assert (conn.isLockHeldByCurrentThread());
        conn.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue(null, null));
        return true;
    }

    @Override
    public String getHeaderValue(URL url, String method) {
        return this.auth;
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    static String getRootPath(String npath, String opath) {
        int index = 0;
        try {
            npath = new URI(npath).normalize().getPath();
            opath = new URI(opath).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        while (index < opath.length()) {
            int toindex = opath.indexOf(47, index + 1);
            if (toindex != -1 && opath.regionMatches(0, npath, 0, toindex + 1)) {
                index = toindex;
                continue;
            }
            return opath.substring(0, index + 1);
        }
        return npath;
    }
}

