/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.URL;

public final class HttpCallerInfo {
    public final URL url;
    public final String host;
    public final String protocol;
    public final String prompt;
    public final String scheme;
    public final int port;
    public final InetAddress addr;
    public final Authenticator.RequestorType authType;
    public final Authenticator authenticator;

    public HttpCallerInfo(HttpCallerInfo old, String scheme) {
        this.url = old.url;
        this.host = old.host;
        this.protocol = old.protocol;
        this.prompt = old.prompt;
        this.port = old.port;
        this.addr = old.addr;
        this.authType = old.authType;
        this.scheme = scheme;
        this.authenticator = old.authenticator;
    }

    public HttpCallerInfo(URL url, Authenticator a) {
        InetAddress ia;
        this.url = url;
        this.prompt = "";
        this.host = url.getHost();
        int p = url.getPort();
        this.port = p == -1 ? url.getDefaultPort() : p;
        try {
            ia = InetAddress.getByName(url.getHost());
        }
        catch (Exception e) {
            ia = null;
        }
        this.addr = ia;
        this.protocol = url.getProtocol();
        this.authType = Authenticator.RequestorType.SERVER;
        this.scheme = "";
        this.authenticator = a;
    }

    public HttpCallerInfo(URL url, String host, int port, Authenticator a) {
        this.url = url;
        this.host = host;
        this.port = port;
        this.prompt = "";
        this.addr = null;
        this.protocol = url.getProtocol();
        this.authType = Authenticator.RequestorType.PROXY;
        this.scheme = "";
        this.authenticator = a;
    }
}

