/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.net.URL;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.util.logging.PlatformLogger;

class NTLMAuthenticationProxy {
    private static Method supportsTA;
    private static Method isTrustedSite;
    private static final String clazzStr = "sun.net.www.protocol.http.ntlm.NTLMAuthentication";
    private static final String supportsTAStr = "supportsTransparentAuth";
    private static final String isTrustedSiteStr = "isTrustedSite";
    static final NTLMAuthenticationProxy proxy;
    static final boolean supported;
    static final boolean supportsTransparentAuth;
    private final Constructor<? extends AuthenticationInfo> fourArgCtr;
    private final Constructor<? extends AuthenticationInfo> sixArgCtr;

    private NTLMAuthenticationProxy(Constructor<? extends AuthenticationInfo> fourArgCtr, Constructor<? extends AuthenticationInfo> sixArgCtr) {
        this.fourArgCtr = fourArgCtr;
        this.sixArgCtr = sixArgCtr;
    }

    AuthenticationInfo create(boolean isProxy, URL url, PasswordAuthentication pw, String authenticatorKey) {
        try {
            return this.fourArgCtr.newInstance(isProxy, url, pw, authenticatorKey);
        }
        catch (ReflectiveOperationException roe) {
            NTLMAuthenticationProxy.finest(roe);
            return null;
        }
    }

    AuthenticationInfo create(boolean isProxy, String host, int port, PasswordAuthentication pw, String authenticatorKey) {
        try {
            return this.sixArgCtr.newInstance(isProxy, host, port, pw, authenticatorKey);
        }
        catch (ReflectiveOperationException roe) {
            NTLMAuthenticationProxy.finest(roe);
            return null;
        }
    }

    private static boolean supportsTransparentAuth() {
        try {
            return (Boolean)supportsTA.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException roe) {
            NTLMAuthenticationProxy.finest(roe);
            return false;
        }
    }

    public static boolean isTrustedSite(URL url) {
        try {
            return (Boolean)isTrustedSite.invoke(null, url);
        }
        catch (ReflectiveOperationException roe) {
            NTLMAuthenticationProxy.finest(roe);
            return false;
        }
    }

    private static NTLMAuthenticationProxy tryLoadNTLMAuthentication() {
        try {
            Class<?> cl = Class.forName(clazzStr, true, null);
            if (cl != null) {
                Constructor<?> fourArg = cl.getConstructor(Boolean.TYPE, URL.class, PasswordAuthentication.class, String.class);
                Constructor<?> sixArg = cl.getConstructor(Boolean.TYPE, String.class, Integer.TYPE, PasswordAuthentication.class, String.class);
                supportsTA = cl.getDeclaredMethod(supportsTAStr, new Class[0]);
                isTrustedSite = cl.getDeclaredMethod(isTrustedSiteStr, URL.class);
                return new NTLMAuthenticationProxy(fourArg, sixArg);
            }
        }
        catch (ClassNotFoundException cnfe) {
            NTLMAuthenticationProxy.finest(cnfe);
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        return null;
    }

    static void finest(Exception e) {
        PlatformLogger logger = HttpURLConnection.getHttpLogger();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("NTLMAuthenticationProxy: " + e);
        }
    }

    static {
        proxy = NTLMAuthenticationProxy.tryLoadNTLMAuthentication();
        supported = proxy != null;
        supportsTransparentAuth = supported ? NTLMAuthenticationProxy.supportsTransparentAuth() : false;
    }
}

