/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.AuthenticatorKeys;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetPropertyAction;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private final HttpCallerInfo hci;
    static HashMap<String, Boolean> supported = null;
    static ThreadLocal<HashMap<String, Negotiator>> cache = null;
    private static final ReentrantLock negotiateLock = new ReentrantLock();
    private static final boolean cacheSPNEGO;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(HttpCallerInfo hci) {
        super(Authenticator.RequestorType.PROXY == hci.authType ? (char)'p' : 's', hci.scheme.equalsIgnoreCase("Negotiate") ? AuthScheme.NEGOTIATE : AuthScheme.KERBEROS, hci.url, "", AuthenticatorKeys.getKey(hci.authenticator));
        this.hci = hci;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupported(HttpCallerInfo hci) {
        negotiateLock.lock();
        try {
            if (supported == null) {
                supported = new HashMap();
            }
            String hostname = hci.host;
            if (supported.containsKey(hostname = hostname.toLowerCase())) {
                boolean bl = supported.get(hostname);
                return bl;
            }
            Negotiator neg = Negotiator.getNegotiator(hci);
            if (neg != null) {
                supported.put(hostname, true);
                if (cache == null) {
                    cache = new ThreadLocal<HashMap<String, Negotiator>>(){

                        @Override
                        protected HashMap<String, Negotiator> initialValue() {
                            return new HashMap<String, Negotiator>();
                        }
                    };
                }
                cache.get().put(hostname, neg);
                boolean bl = true;
                return bl;
            }
            supported.put(hostname, false);
            boolean bl = false;
            return bl;
        }
        finally {
            negotiateLock.unlock();
        }
    }

    private static HashMap<String, Negotiator> getCache() {
        negotiateLock.lock();
        try {
            if (cache == null) {
                HashMap<String, Negotiator> hashMap = null;
                return hashMap;
            }
            HashMap<String, Negotiator> hashMap = cache.get();
            return hashMap;
        }
        finally {
            negotiateLock.unlock();
        }
    }

    @Override
    protected boolean useAuthCache() {
        return super.useAuthCache() && cacheSPNEGO;
    }

    @Override
    public String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    @Override
    public boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        assert (conn.isLockHeldByCurrentThread());
        try {
            byte[] incoming = null;
            String[] parts = raw.split("\\s+");
            if (parts.length > 1) {
                incoming = Base64.getDecoder().decode(parts[1]);
            }
            String response = this.hci.scheme + " " + Base64.getEncoder().encodeToString(incoming == null ? this.firstToken() : this.nextToken(incoming));
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        HashMap<String, Negotiator> cachedMap = NegotiateAuthentication.getCache();
        if (cachedMap != null) {
            this.negotiator = cachedMap.get(this.getHost());
            if (this.negotiator != null) {
                cachedMap.remove(this.getHost());
            }
        }
        if (this.negotiator == null) {
            this.negotiator = Negotiator.getNegotiator(this.hci);
            if (this.negotiator == null) {
                IOException ioe = new IOException("Cannot initialize Negotiator");
                throw ioe;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] token) throws IOException {
        return this.negotiator.nextToken(token);
    }

    static {
        String spnegoCacheProp = GetPropertyAction.privilegedGetProperty("jdk.spnego.cache", "true");
        cacheSPNEGO = Boolean.parseBoolean(spnegoCacheProp);
    }
}

