/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import java.io.IOException;
import java.util.Base64;

public class NTLMAuthSequence {
    private String username;
    private String password;
    private String ntdomain;
    private int state;
    private long crdHandle;
    private long ctxHandle;
    Status status;

    NTLMAuthSequence(String username, String password, String ntdomain) throws IOException {
        this.username = username;
        this.password = password;
        this.ntdomain = ntdomain;
        this.status = new Status();
        this.state = 0;
        this.crdHandle = this.getCredentialsHandle(username, ntdomain, password);
        if (this.crdHandle == 0L) {
            throw new IOException("could not get credentials handle");
        }
    }

    public String getAuthHeader(String token) throws IOException {
        byte[] b;
        byte[] input = null;
        assert (!this.status.sequenceComplete);
        if (token != null) {
            input = Base64.getDecoder().decode(token);
        }
        if ((b = this.getNextToken(this.crdHandle, input, this.status)) == null) {
            throw new IOException("Internal authentication error");
        }
        return Base64.getEncoder().encodeToString(b);
    }

    public boolean isComplete() {
        return this.status.sequenceComplete;
    }

    private static native void initFirst(Class<Status> var0);

    private native long getCredentialsHandle(String var1, String var2, String var3);

    private native byte[] getNextToken(long var1, byte[] var3, Status var4);

    static {
        NTLMAuthSequence.initFirst(Status.class);
    }

    static class Status {
        boolean sequenceComplete;

        Status() {
        }
    }
}

