/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.net.util.URLUtil;
import sun.net.www.protocol.jar.URLJarFile;

class JarFileFactory
implements URLJarFile.URLJarFileCloseController {
    private static final HashMap<String, JarFile> fileCache = new HashMap();
    private static final HashMap<JarFile, URL> urlCache = new HashMap();
    private static final JarFileFactory instance = new JarFileFactory();

    private JarFileFactory() {
    }

    public static JarFileFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection getConnection(JarFile jarFile) throws IOException {
        URL u;
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            u = urlCache.get(jarFile);
        }
        if (u != null) {
            return u.openConnection();
        }
        return null;
    }

    public JarFile get(URL url) throws IOException {
        return this.get(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile getOrCreate(URL url, boolean useCaches) throws IOException {
        JarFile result;
        if (!useCaches) {
            return this.get(url, false);
        }
        URL patched = this.urlFor(url);
        if (!URLJarFile.isFileURL(patched)) {
            return this.get(url, useCaches);
        }
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            result = this.getCachedJarFile(patched);
        }
        if (result == null) {
            result = URLJarFile.getJarFile(patched, this);
        }
        if (result == null) {
            throw new FileNotFoundException(url.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeIfNotCached(URL url, JarFile jarFile) throws IOException {
        JarFile result;
        url = this.urlFor(url);
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            result = this.getCachedJarFile(url);
        }
        if (result != jarFile) {
            jarFile.close();
        }
        return result != jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cacheIfAbsent(URL url, JarFile jarFile) {
        JarFile cached;
        try {
            url = this.urlFor(url);
        }
        catch (IOException x) {
            return false;
        }
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            String key = this.urlKey(url);
            cached = fileCache.get(key);
            if (cached == null) {
                fileCache.put(key, jarFile);
                urlCache.put(jarFile, url);
            }
        }
        return cached == null || cached == jarFile;
    }

    private URL urlFor(URL url) throws IOException {
        String host;
        if (url.getProtocol().equalsIgnoreCase("file") && (host = url.getHost()) != null && !host.isEmpty() && !host.equalsIgnoreCase("localhost")) {
            url = new URL("file", "", "//" + host + url.getPath());
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile get(URL url, boolean useCaches) throws IOException {
        JarFile result;
        url = this.urlFor(url);
        if (useCaches) {
            JarFileFactory jarFileFactory = instance;
            synchronized (jarFileFactory) {
                result = this.getCachedJarFile(url);
            }
            if (result == null) {
                JarFile local_result = URLJarFile.getJarFile(url, this);
                jarFileFactory = instance;
                synchronized (jarFileFactory) {
                    result = this.getCachedJarFile(url);
                    if (result == null) {
                        fileCache.put(this.urlKey(url), local_result);
                        urlCache.put(local_result, url);
                        result = local_result;
                    } else if (local_result != null) {
                        local_result.close();
                    }
                }
            }
        } else {
            result = URLJarFile.getJarFile(url, this);
        }
        if (result == null) {
            throw new FileNotFoundException(url.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(JarFile jarFile) {
        JarFileFactory jarFileFactory = instance;
        synchronized (jarFileFactory) {
            URL urlRemoved = urlCache.remove(jarFile);
            if (urlRemoved != null) {
                fileCache.remove(this.urlKey(urlRemoved));
            }
        }
    }

    private JarFile getCachedJarFile(URL url) {
        Permission perm;
        SecurityManager sm;
        assert (Thread.holdsLock(instance));
        JarFile result = fileCache.get(this.urlKey(url));
        if (result != null && (sm = System.getSecurityManager()) != null && (perm = this.getPermission(result)) != null) {
            try {
                sm.checkPermission(perm);
            }
            catch (SecurityException se) {
                if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                    sm.checkRead(perm.getName());
                }
                if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                    sm.checkConnect(url.getHost(), url.getPort());
                }
                throw se;
            }
        }
        return result;
    }

    private String urlKey(URL url) {
        String urlstr = URLUtil.urlNoFragString(url);
        if ("runtime".equals(url.getRef())) {
            urlstr = urlstr + "#runtime";
        }
        return urlstr;
    }

    private Permission getPermission(JarFile jarFile) {
        try {
            URLConnection uc = this.getConnection(jarFile);
            if (uc != null) {
                return uc.getPermission();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

