/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jrt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import jdk.internal.jimage.ImageLocation;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jimage.ImageReaderFactory;
import jdk.internal.loader.Resource;
import jdk.internal.loader.URLClassPath;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;

public class JavaRuntimeURLConnection
extends URLConnection {
    private static final ImageReader reader;
    private final String module;
    private final String name;
    private volatile Resource resource;

    JavaRuntimeURLConnection(URL url) throws IOException {
        super(url);
        String path = url.getPath();
        if (path.isEmpty() || path.charAt(0) != '/') {
            throw new MalformedURLException(url + " missing path or /");
        }
        if (path.length() == 1) {
            this.module = null;
            this.name = null;
        } else {
            int pos = path.indexOf(47, 1);
            if (pos == -1) {
                this.module = path.substring(1);
                this.name = null;
            } else {
                this.module = path.substring(1, pos);
                this.name = ParseUtil.decode(path.substring(pos + 1));
            }
        }
    }

    private static Resource findResource(final String module, final String name) {
        if (reader != null) {
            final URL url = JavaRuntimeURLConnection.toJrtURL(module, name);
            final ImageLocation location = reader.findLocation(module, name);
            if (location != null && URLClassPath.checkURL(url) != null) {
                return new Resource(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public URL getURL() {
                        return url;
                    }

                    @Override
                    public URL getCodeSourceURL() {
                        return JavaRuntimeURLConnection.toJrtURL(module);
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        byte[] resource = reader.getResource(location);
                        return new ByteArrayInputStream(resource);
                    }

                    @Override
                    public int getContentLength() {
                        long size = location.getUncompressedSize();
                        return size > Integer.MAX_VALUE ? -1 : (int)size;
                    }
                };
            }
        }
        return null;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            if (this.name == null) {
                String s = this.module == null ? "" : this.module;
                throw new IOException("cannot connect to jrt:/" + s);
            }
            this.resource = JavaRuntimeURLConnection.findResource(this.module, this.name);
            if (this.resource == null) {
                throw new IOException(this.module + "/" + this.name + " not found");
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.resource.getInputStream();
    }

    @Override
    public long getContentLengthLong() {
        try {
            this.connect();
            return this.resource.getContentLength();
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    @Override
    public int getContentLength() {
        long len = this.getContentLengthLong();
        return len > Integer.MAX_VALUE ? -1 : (int)len;
    }

    @Override
    public Permission getPermission() {
        return new RuntimePermission("accessSystemModules");
    }

    private static URL toJrtURL(String module, String name) {
        try {
            return new URL("jrt:/" + module + "/" + name);
        }
        catch (MalformedURLException e) {
            throw new InternalError(e);
        }
    }

    private static URL toJrtURL(String module) {
        try {
            return new URL("jrt:/" + module);
        }
        catch (MalformedURLException e) {
            throw new InternalError(e);
        }
    }

    static {
        PrivilegedAction<ImageReader> pa = ImageReaderFactory::getImageReader;
        reader = AccessController.doPrivileged(pa);
    }
}

