/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.Channel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sun.nio.ch.Invoker;
import sun.nio.ch.ThreadPool;
import sun.security.action.GetIntegerAction;

abstract class AsynchronousChannelGroupImpl
extends AsynchronousChannelGroup
implements Executor {
    private static final int internalThreadCount = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.internalThreadPoolSize", 1));
    private final ThreadPool pool;
    private final AtomicInteger threadCount = new AtomicInteger();
    private ScheduledThreadPoolExecutor timeoutExecutor;
    private final Queue<Runnable> taskQueue;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Object shutdownNowLock = new Object();
    private volatile boolean terminateInitiated;

    AsynchronousChannelGroupImpl(AsynchronousChannelProvider provider, ThreadPool pool) {
        super(provider);
        this.pool = pool;
        this.taskQueue = pool.isFixedThreadPool() ? new ConcurrentLinkedQueue<Runnable>() : null;
        this.timeoutExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, ThreadPool.defaultThreadFactory());
        this.timeoutExecutor.setRemoveOnCancelPolicy(true);
    }

    final ExecutorService executor() {
        return this.pool.executor();
    }

    final boolean isFixedThreadPool() {
        return this.pool.isFixedThreadPool();
    }

    final int fixedThreadCount() {
        if (this.isFixedThreadPool()) {
            return this.pool.poolSize();
        }
        return this.pool.poolSize() + internalThreadCount;
    }

    private Runnable bindToGroup(final Runnable task) {
        final AsynchronousChannelGroupImpl thisGroup = this;
        return new Runnable(){

            @Override
            public void run() {
                Invoker.bindToGroup(thisGroup);
                task.run();
            }
        };
    }

    private void startInternalThread(final Runnable task) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ThreadPool.defaultThreadFactory().newThread(task).start();
                return null;
            }
        });
    }

    protected final void startThreads(Runnable task) {
        int i;
        if (!this.isFixedThreadPool()) {
            for (i = 0; i < internalThreadCount; ++i) {
                this.startInternalThread(task);
                this.threadCount.incrementAndGet();
            }
        }
        if (this.pool.poolSize() > 0) {
            task = this.bindToGroup(task);
            try {
                for (i = 0; i < this.pool.poolSize(); ++i) {
                    this.pool.executor().execute(task);
                    this.threadCount.incrementAndGet();
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    final int threadCount() {
        return this.threadCount.get();
    }

    final int threadExit(Runnable task, boolean replaceMe) {
        if (replaceMe) {
            try {
                if (Invoker.isBoundToAnyGroup()) {
                    this.pool.executor().execute(this.bindToGroup(task));
                } else {
                    this.startInternalThread(task);
                }
                return this.threadCount.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return this.threadCount.decrementAndGet();
    }

    abstract void executeOnHandlerTask(Runnable var1);

    final void executeOnPooledThread(Runnable task) {
        if (this.isFixedThreadPool()) {
            this.executeOnHandlerTask(task);
        } else {
            this.pool.executor().execute(this.bindToGroup(task));
        }
    }

    final void offerTask(Runnable task) {
        this.taskQueue.offer(task);
    }

    final Runnable pollTask() {
        return this.taskQueue == null ? null : this.taskQueue.poll();
    }

    final Future<?> schedule(Runnable task, long timeout, TimeUnit unit) {
        try {
            return this.timeoutExecutor.schedule(task, timeout, unit);
        }
        catch (RejectedExecutionException rej) {
            if (this.terminateInitiated) {
                return null;
            }
            throw new AssertionError((Object)rej);
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public final boolean isTerminated() {
        return this.pool.executor().isTerminated();
    }

    abstract boolean isEmpty();

    abstract Object attachForeignChannel(Channel var1, FileDescriptor var2) throws IOException;

    abstract void detachForeignChannel(Object var1);

    abstract void closeAllChannels() throws IOException;

    abstract void shutdownHandlerTasks();

    private void shutdownExecutors() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                AsynchronousChannelGroupImpl.this.pool.executor().shutdown();
                AsynchronousChannelGroupImpl.this.timeoutExecutor.shutdown();
                return null;
            }
        }, null, new RuntimePermission("modifyThread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (!this.isEmpty()) {
            return;
        }
        Object object2 = this.shutdownNowLock;
        synchronized (object2) {
            if (!this.terminateInitiated) {
                this.terminateInitiated = true;
                this.shutdownHandlerTasks();
                this.shutdownExecutors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow() throws IOException {
        this.shutdown.set(true);
        Object object2 = this.shutdownNowLock;
        synchronized (object2) {
            if (!this.terminateInitiated) {
                this.terminateInitiated = true;
                this.closeAllChannels();
                this.shutdownHandlerTasks();
                this.shutdownExecutors();
            }
        }
    }

    final void detachFromThreadPool() {
        if (this.shutdown.getAndSet(true)) {
            throw new AssertionError((Object)"Already shutdown");
        }
        if (!this.isEmpty()) {
            throw new AssertionError((Object)"Group not empty");
        }
        this.shutdownHandlerTasks();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.executor().awaitTermination(timeout, unit);
    }

    @Override
    public final void execute(Runnable task) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            final AccessControlContext acc = AccessController.getContext();
            final Runnable delegate = task;
            task = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Void run() {
                            delegate.run();
                            return null;
                        }
                    }, acc);
                }
            };
        }
        this.executeOnPooledThread(task);
    }
}

