/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Cleaner;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.MembershipKey;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import jdk.internal.ref.CleanerFactory;
import sun.net.ResourceManager;
import sun.net.ext.ExtendedSocketOptions;
import sun.net.util.IPAddressUtil;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.MembershipKeyImpl;
import sun.nio.ch.MembershipRegistry;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeSocketAddress;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOptionRegistry;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static final NativeDispatcher nd = new DatagramDispatcher();
    private final boolean interruptible;
    private final ProtocolFamily family;
    private final FileDescriptor fd;
    private final int fdVal;
    private NativeSocketAddress sourceSockAddr;
    private NativeSocketAddress cachedSockAddr;
    private InetSocketAddress cachedInetSocketAddress;
    private final NativeSocketAddress targetSockAddr;
    private InetSocketAddress previousTarget;
    private int previousSockAddrLength;
    private final Cleaner.Cleanable cleaner;
    private final ReentrantLock readLock;
    private final ReentrantLock writeLock;
    private final Object stateLock;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTED = 1;
    private static final int ST_CLOSING = 2;
    private static final int ST_CLOSED = 3;
    private int state;
    private long readerThread;
    private long writerThread;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress initialLocalAddress;
    private static final VarHandle SOCKET;
    private volatile DatagramSocket socket;
    private MembershipRegistry registry;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    DatagramChannelImpl(SelectorProvider sp, boolean interruptible) throws IOException {
        this(sp, Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET, interruptible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatagramChannelImpl(SelectorProvider sp, ProtocolFamily family, boolean interruptible) throws IOException {
        NativeSocketAddress[] sockAddrs;
        FileDescriptor fd;
        block12: {
            block13: {
                super(sp);
                this.readLock = new ReentrantLock();
                this.writeLock = new ReentrantLock();
                this.stateLock = new Object();
                Objects.requireNonNull(family, "'family' is null");
                if (family != StandardProtocolFamily.INET && family != StandardProtocolFamily.INET6) {
                    throw new UnsupportedOperationException("Protocol family not supported");
                }
                if (family == StandardProtocolFamily.INET6 && !Net.isIPv6Available()) {
                    throw new UnsupportedOperationException("IPv6 not available");
                }
                fd = null;
                sockAddrs = null;
                ResourceManager.beforeUdpCreate();
                boolean initialized = false;
                try {
                    this.interruptible = interruptible;
                    this.family = family;
                    this.fd = fd = Net.socket(family, false);
                    this.fdVal = IOUtil.fdVal(fd);
                    sockAddrs = NativeSocketAddress.allocate(3);
                    this.readLock.lock();
                    try {
                        this.sourceSockAddr = sockAddrs[0];
                        this.cachedSockAddr = sockAddrs[1];
                    }
                    finally {
                        this.readLock.unlock();
                    }
                    this.targetSockAddr = sockAddrs[2];
                    initialized = true;
                    if (initialized) break block12;
                    if (sockAddrs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (!initialized) {
                        if (sockAddrs != null) {
                            NativeSocketAddress.freeAll(sockAddrs);
                        }
                        if (fd != null) {
                            nd.close(fd);
                        }
                        ResourceManager.afterUdpClose();
                    }
                    throw throwable;
                }
                NativeSocketAddress.freeAll(sockAddrs);
            }
            if (fd != null) {
                nd.close(fd);
            }
            ResourceManager.afterUdpClose();
        }
        Runnable releaser = DatagramChannelImpl.releaserFor(fd, sockAddrs);
        this.cleaner = CleanerFactory.cleaner().register(this, releaser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatagramChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
        NativeSocketAddress[] sockAddrs;
        block11: {
            block12: {
                super(sp);
                this.readLock = new ReentrantLock();
                this.writeLock = new ReentrantLock();
                this.stateLock = new Object();
                sockAddrs = null;
                ResourceManager.beforeUdpCreate();
                boolean initialized = false;
                try {
                    this.interruptible = true;
                    this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                    this.fd = fd;
                    this.fdVal = IOUtil.fdVal(fd);
                    sockAddrs = NativeSocketAddress.allocate(3);
                    this.readLock.lock();
                    try {
                        this.sourceSockAddr = sockAddrs[0];
                        this.cachedSockAddr = sockAddrs[1];
                    }
                    finally {
                        this.readLock.unlock();
                    }
                    this.targetSockAddr = sockAddrs[2];
                    initialized = true;
                    if (initialized) break block11;
                    if (sockAddrs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (!initialized) {
                        if (sockAddrs != null) {
                            NativeSocketAddress.freeAll(sockAddrs);
                        }
                        nd.close(fd);
                        ResourceManager.afterUdpClose();
                    }
                    throw throwable;
                }
                NativeSocketAddress.freeAll(sockAddrs);
            }
            nd.close(fd);
            ResourceManager.afterUdpClose();
        }
        Runnable releaser = DatagramChannelImpl.releaserFor(fd, sockAddrs);
        this.cleaner = CleanerFactory.cleaner().register(this, releaser);
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.localAddress = Net.localAddress(fd);
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public DatagramSocket socket() {
        DatagramSocket socket = this.socket;
        if (socket == null && !SOCKET.compareAndSet(this, null, socket = DatagramSocketAdaptor.create(this))) {
            socket = this.socket;
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            return this.remoteAddress;
        }
    }

    private ProtocolFamily familyFor(SocketOption<?> name) {
        assert (Thread.holdsLock(this.stateLock));
        if (SocketOptionRegistry.findOption(name, Net.UNSPEC) != null) {
            return Net.UNSPEC;
        }
        if (this.family == StandardProtocolFamily.INET) {
            return StandardProtocolFamily.INET;
        }
        if (this.localAddress == null) {
            return StandardProtocolFamily.INET6;
        }
        InetAddress address = this.localAddress.getAddress();
        if (address.isAnyLocalAddress() || address instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        if (Net.canUseIPv6OptionsWithIPv4LocalAddress()) {
            return StandardProtocolFamily.INET6;
        }
        return StandardProtocolFamily.INET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public <T> DatagramChannel setOption(SocketOption<T> name, T value) throws IOException {
        boolean needToSetIPv4Option;
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        if (!name.type().isInstance(value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "'");
        }
        Object object2 = this.stateLock;
        // MONITORENTER : object2
        this.ensureOpen();
        ProtocolFamily family = this.familyFor(name);
        boolean bl = needToSetIPv4Option = family != Net.UNSPEC && this.family == StandardProtocolFamily.INET6 && Net.shouldSetBothIPv4AndIPv6Options();
        if (name == StandardSocketOptions.IP_MULTICAST_IF) {
            assert (family != Net.UNSPEC);
            NetworkInterface interf = (NetworkInterface)value;
            if (family == StandardProtocolFamily.INET6) {
                int index = interf.getIndex();
                if (index == -1) {
                    throw new IOException("Network interface cannot be identified");
                }
                Net.setInterface6(this.fd, index);
            }
            if (family == StandardProtocolFamily.INET || needToSetIPv4Option) {
                Inet4Address target = Net.anyInet4Address(interf);
                if (target != null) {
                    try {
                        Net.setInterface4(this.fd, Net.inet4AsInt(target));
                        return this;
                    }
                    catch (IOException ioe) {
                        if (family != StandardProtocolFamily.INET) return this;
                        throw ioe;
                    }
                } else if (family == StandardProtocolFamily.INET) {
                    throw new IOException("Network interface not configured for IPv4");
                }
            }
            // MONITOREXIT : object2
            return this;
        }
        if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind() && this.localAddress != null) {
            this.reuseAddressEmulated = true;
            this.isReuseAddress = (Boolean)value;
        }
        Net.setSocketOption(this.fd, family, name, value);
        if (needToSetIPv4Option && family != StandardProtocolFamily.INET) {
            try {
                Net.setSocketOption(this.fd, StandardProtocolFamily.INET, name, value);
                return this;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        // MONITOREXIT : object2
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            ProtocolFamily family = this.familyFor(name);
            if (name == StandardSocketOptions.IP_MULTICAST_IF) {
                if (family == StandardProtocolFamily.INET) {
                    int address = Net.getInterface4(this.fd);
                    if (address == 0) {
                        return null;
                    }
                    InetAddress ia = Net.inet4FromInt(address);
                    NetworkInterface ni = NetworkInterface.getByInetAddress(ia);
                    if (ni == null) {
                        throw new IOException("Unable to map address to interface");
                    }
                    return (T)ni;
                }
                int index = Net.getInterface6(this.fd);
                if (index == 0) {
                    return null;
                }
                NetworkInterface ni = NetworkInterface.getByIndex(index);
                if (ni == null) {
                    throw new IOException("Unable to map index to interface");
                }
                return (T)ni;
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && this.reuseAddressEmulated) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            return (T)Net.getSocketOption(this.fd, family, name);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress beginRead(boolean blocking, boolean mustBeConnected) throws IOException {
        InetSocketAddress remote;
        if (blocking && this.interruptible) {
            this.begin();
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            remote = this.remoteAddress;
            if (remote == null && mustBeConnected) {
                throw new NotYetConnectedException();
            }
            if (this.localAddress == null) {
                this.bindInternal(null);
            }
            if (blocking) {
                this.readerThread = NativeThread.current();
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.readerThread = 0L;
                if (this.state == 2) {
                    this.tryFinishClose();
                }
            }
            if (this.interruptible) {
                this.end(completed);
            } else if (!completed && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress receive(ByteBuffer dst) throws IOException {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        this.readLock.lock();
        try {
            SocketAddress socketAddress;
            boolean blocking = this.isBlocking();
            SocketAddress sender = null;
            try {
                SocketAddress remote = this.beginRead(blocking, false);
                boolean connected = remote != null;
                SecurityManager sm = System.getSecurityManager();
                if (connected || sm == null) {
                    int n = this.receive(dst, connected);
                    if (blocking) {
                        while (IOStatus.okayToRetry(n) && this.isOpen()) {
                            this.park(Net.POLLIN);
                            n = this.receive(dst, connected);
                        }
                    }
                    if (n >= 0) {
                        sender = this.sourceSocketAddress();
                    }
                } else {
                    sender = this.untrustedReceive(dst);
                }
                socketAddress = sender;
                this.endRead(blocking, sender != null);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, sender != null);
                throw throwable;
            }
            return socketAddress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private SocketAddress untrustedReceive(ByteBuffer dst) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        assert (this.readLock.isHeldByCurrentThread() && sm != null && this.remoteAddress == null);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(dst.remaining());
        try {
            boolean blocking = this.isBlocking();
            while (true) {
                int n = this.receive(bb, false);
                if (blocking) {
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        this.park(Net.POLLIN);
                        n = this.receive(bb, false);
                    }
                }
                if (n >= 0) {
                    InetSocketAddress isa = this.sourceSocketAddress();
                    try {
                        sm.checkAccept(isa.getAddress().getHostAddress(), isa.getPort());
                        bb.flip();
                        dst.put(bb);
                        InetSocketAddress inetSocketAddress = isa;
                        return inetSocketAddress;
                    }
                    catch (SecurityException se) {
                        bb.clear();
                    }
                } else {
                    SocketAddress socketAddress = null;
                    return socketAddress;
                }
            }
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketAddress blockingReceive(ByteBuffer dst, long nanos) throws IOException {
        this.readLock.lock();
        try {
            SocketAddress sender;
            this.ensureOpen();
            if (!this.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            SecurityManager sm = System.getSecurityManager();
            boolean connected = this.isConnected();
            do {
                sender = nanos > 0L ? this.trustedBlockingReceive(dst, nanos) : this.trustedBlockingReceive(dst);
                if (sm == null || connected) continue;
                InetSocketAddress isa = (InetSocketAddress)sender;
                try {
                    sm.checkAccept(isa.getAddress().getHostAddress(), isa.getPort());
                }
                catch (SecurityException e) {
                    sender = null;
                }
            } while (sender == null);
            SocketAddress socketAddress = sender;
            return socketAddress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress trustedBlockingReceive(ByteBuffer dst) throws IOException {
        InetSocketAddress inetSocketAddress;
        assert (this.readLock.isHeldByCurrentThread() && this.isBlocking());
        InetSocketAddress sender = null;
        try {
            SocketAddress remote = this.beginRead(true, false);
            boolean connected = remote != null;
            int n = this.receive(dst, connected);
            while (IOStatus.okayToRetry(n) && this.isOpen()) {
                this.park(Net.POLLIN);
                n = this.receive(dst, connected);
            }
            if (n >= 0) {
                sender = this.sourceSocketAddress();
            }
            inetSocketAddress = sender;
            this.endRead(true, sender != null);
        }
        catch (Throwable throwable) {
            this.endRead(true, sender != null);
            throw throwable;
        }
        return inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private SocketAddress trustedBlockingReceive(ByteBuffer dst, long nanos) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() && this.isBlocking());
        InetSocketAddress sender = null;
        SocketAddress remote = this.beginRead(true, false);
        boolean connected = remote != null;
        this.lockedConfigureBlocking(false);
        long startNanos = System.nanoTime();
        int n = this.receive(dst, connected);
        while (n == -2 && this.isOpen()) {
            long remainingNanos = nanos - (System.nanoTime() - startNanos);
            if (remainingNanos <= 0L) {
                throw new SocketTimeoutException("Receive timed out");
            }
            this.park(Net.POLLIN, remainingNanos);
            n = this.receive(dst, connected);
        }
        if (n >= 0) {
            sender = this.sourceSocketAddress();
        }
        InetSocketAddress inetSocketAddress = sender;
        this.tryLockedConfigureBlocking(true);
        this.endRead(true, sender != null);
        return inetSocketAddress;
        {
            catch (Throwable throwable) {
                try {
                    this.tryLockedConfigureBlocking(true);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    this.endRead(true, sender != null);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(ByteBuffer dst, boolean connected) throws IOException {
        int rem;
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer && rem > 0) {
            return this.receiveIntoNativeBuffer(dst, rem, pos, connected);
        }
        int newSize = Math.max(rem, 1);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(newSize);
        try {
            int n2 = this.receiveIntoNativeBuffer(bb, newSize, 0, connected);
            bb.flip();
            if (n2 > 0 && rem > 0) {
                dst.put(bb);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int receiveIntoNativeBuffer(ByteBuffer bb, int rem, int pos, boolean connected) throws IOException {
        int n = DatagramChannelImpl.receive0(this.fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, this.sourceSockAddr.address(), connected);
        if (n > 0) {
            bb.position(pos + n);
        }
        return n;
    }

    private InetSocketAddress sourceSocketAddress() throws IOException {
        assert (this.readLock.isHeldByCurrentThread());
        if (this.cachedInetSocketAddress != null && this.sourceSockAddr.equals(this.cachedSockAddr)) {
            return this.cachedInetSocketAddress;
        }
        InetSocketAddress isa = this.sourceSockAddr.decode();
        NativeSocketAddress tmp = this.cachedSockAddr;
        this.cachedSockAddr = this.sourceSockAddr;
        this.sourceSockAddr = tmp;
        this.cachedInetSocketAddress = isa;
        return isa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        Objects.requireNonNull(src);
        InetSocketAddress isa = Net.checkAddress(target, this.family);
        this.writeLock.lock();
        try {
            int n;
            boolean blocking = this.isBlocking();
            boolean completed = false;
            try {
                SocketAddress remote = this.beginWrite(blocking, false);
                if (remote != null) {
                    if (!target.equals(remote)) {
                        throw new AlreadyConnectedException();
                    }
                    n = IOUtil.write(this.fd, src, -1L, nd);
                    if (blocking) {
                        while (IOStatus.okayToRetry(n) && this.isOpen()) {
                            this.park(Net.POLLOUT);
                            n = IOUtil.write(this.fd, src, -1L, nd);
                        }
                    }
                    completed = n > 0;
                } else {
                    SecurityManager sm = System.getSecurityManager();
                    InetAddress ia = isa.getAddress();
                    if (sm != null) {
                        if (ia.isMulticastAddress()) {
                            sm.checkMulticast(ia);
                        } else {
                            sm.checkConnect(ia.getHostAddress(), isa.getPort());
                        }
                    }
                    if (ia.isLinkLocalAddress()) {
                        isa = IPAddressUtil.toScopedAddress(isa);
                    }
                    if (isa.getPort() == 0) {
                        throw new SocketException("Can't send to port 0");
                    }
                    n = this.send(this.fd, src, isa);
                    if (blocking) {
                        while (IOStatus.okayToRetry(n) && this.isOpen()) {
                            this.park(Net.POLLOUT);
                            n = this.send(this.fd, src, isa);
                        }
                    }
                    completed = n >= 0;
                }
            }
            finally {
                this.endWrite(blocking, completed);
            }
            assert (n >= 0 || n == -2);
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void blockingSend(ByteBuffer src, SocketAddress target) throws IOException {
        this.writeLock.lock();
        try {
            this.ensureOpen();
            if (!this.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            this.send(src, target);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(FileDescriptor fd, ByteBuffer src, InetSocketAddress target) throws IOException {
        if (src instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fd, src, target);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = Util.getTemporaryDirectBuffer(rem);
        try {
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n = this.sendFromNativeBuffer(fd, bb, target);
            if (n > 0) {
                src.position(pos + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int sendFromNativeBuffer(FileDescriptor fd, ByteBuffer bb, InetSocketAddress target) throws IOException {
        int written;
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        try {
            int addressLen = this.targetSocketAddress(target);
            written = DatagramChannelImpl.send0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, this.targetSockAddr.address(), addressLen);
        }
        catch (PortUnreachableException pue) {
            if (this.isConnected()) {
                throw pue;
            }
            written = rem;
        }
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    private int targetSocketAddress(InetSocketAddress isa) {
        assert (this.writeLock.isHeldByCurrentThread());
        if (isa == this.previousTarget) {
            return this.previousSockAddrLength;
        }
        this.previousTarget = null;
        int len = this.targetSockAddr.encode(this.family, isa);
        this.previousTarget = isa;
        this.previousSockAddrLength = len;
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginRead(blocking, true);
                n = IOUtil.read(this.fd, buf, -1L, nd);
                if (blocking) {
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        this.park(Net.POLLIN);
                        n = IOUtil.read(this.fd, buf, -1L, nd);
                    }
                }
                this.endRead(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dsts.length);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginRead(blocking, true);
                n = IOUtil.read(this.fd, dsts, offset, length, nd);
                if (blocking) {
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        this.park(Net.POLLIN);
                        n = IOUtil.read(this.fd, dsts, offset, length, nd);
                    }
                }
                this.endRead(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress beginWrite(boolean blocking, boolean mustBeConnected) throws IOException {
        InetSocketAddress remote;
        if (blocking && this.interruptible) {
            this.begin();
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            remote = this.remoteAddress;
            if (remote == null && mustBeConnected) {
                throw new NotYetConnectedException();
            }
            if (this.localAddress == null) {
                this.bindInternal(null);
            }
            if (blocking) {
                this.writerThread = NativeThread.current();
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWrite(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.writerThread = 0L;
                if (this.state == 2) {
                    this.tryFinishClose();
                }
            }
            if (this.interruptible) {
                this.end(completed);
            } else if (!completed && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(blocking, true);
                n = IOUtil.write(this.fd, buf, -1L, nd);
                if (blocking) {
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        this.park(Net.POLLOUT);
                        n = IOUtil.write(this.fd, buf, -1L, nd);
                    }
                }
                this.endWrite(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, srcs.length);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginWrite(blocking, true);
                n = IOUtil.write(this.fd, srcs, offset, length, nd);
                if (blocking) {
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        this.park(Net.POLLOUT);
                        n = IOUtil.write(this.fd, srcs, offset, length, nd);
                    }
                }
                this.endWrite(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                this.lockedConfigureBlocking(block);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockedConfigureBlocking(boolean block) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.ensureOpen();
            IOUtil.configureBlocking(this.fd, block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockedConfigureBlocking(boolean block) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (this.isOpen()) {
                IOUtil.configureBlocking(this.fd, block);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress localAddress() {
        Object object2 = this.stateLock;
        synchronized (object2) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress remoteAddress() {
        Object object2 = this.stateLock;
        synchronized (object2) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel bind(SocketAddress local) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    this.bindInternal(local);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    private void bindInternal(SocketAddress local) throws IOException {
        assert (Thread.holdsLock(this.stateLock) && this.localAddress == null);
        InetSocketAddress isa = local == null ? (this.family == StandardProtocolFamily.INET ? new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0) : new InetSocketAddress(0)) : Net.checkAddress(local, this.family);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkListen(isa.getPort());
        }
        Net.bind(this.family, this.fd, isa.getAddress(), isa.getPort());
        this.localAddress = Net.localAddress(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object2 = this.stateLock;
        synchronized (object2) {
            return this.state == 1;
        }
    }

    @Override
    public DatagramChannel connect(SocketAddress sa) throws IOException {
        return this.connect(sa, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatagramChannel connect(SocketAddress sa, boolean check) throws IOException {
        InetSocketAddress isa = Net.checkAddress(sa, this.family);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            InetAddress ia = isa.getAddress();
            if (ia.isMulticastAddress()) {
                sm.checkMulticast(ia);
            } else {
                sm.checkConnect(ia.getHostAddress(), isa.getPort());
                sm.checkAccept(ia.getHostAddress(), isa.getPort());
            }
        }
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (check && this.state == 1) {
                        throw new AlreadyConnectedException();
                    }
                    if (isa.getPort() == 0) {
                        throw new SocketException("Can't connect to port 0");
                    }
                    if (this.localAddress == null) {
                        this.bindInternal(null);
                    }
                    this.initialLocalAddress = this.localAddress;
                    int n = Net.connect(this.family, this.fd, isa.getAddress(), isa.getPort());
                    if (n <= 0) {
                        throw new Error();
                    }
                    this.remoteAddress = isa;
                    this.state = 1;
                    this.localAddress = Net.localAddress(this.fd);
                    boolean blocking = this.isBlocking();
                    if (blocking) {
                        IOUtil.configureBlocking(this.fd, false);
                    }
                    try {
                        ByteBuffer buf = ByteBuffer.allocate(100);
                        while (this.receive(buf, false) >= 0) {
                            buf.clear();
                        }
                    }
                    finally {
                        if (blocking) {
                            IOUtil.configureBlocking(this.fd, true);
                        }
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel disconnect() throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    block17: {
                        if (this.isOpen() && this.state == 1) break block17;
                        DatagramChannelImpl datagramChannelImpl = this;
                        return datagramChannelImpl;
                    }
                    boolean isIPv6 = this.family == StandardProtocolFamily.INET6;
                    DatagramChannelImpl.disconnect0(this.fd, isIPv6);
                    this.remoteAddress = null;
                    this.state = 0;
                    this.localAddress = Net.localAddress(this.fd);
                    try {
                        if (!this.localAddress.equals(this.initialLocalAddress)) {
                            this.repairSocket(this.initialLocalAddress);
                            assert (this.localAddress != null && this.localAddress.equals(Net.localAddress(this.fd)) && this.localAddress.equals(this.initialLocalAddress));
                        }
                    }
                    finally {
                        this.initialLocalAddress = null;
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairSocket(InetSocketAddress target) throws IOException {
        Object value;
        SocketOption option;
        assert (Thread.holdsLock(this.stateLock));
        if (this.localAddress.getPort() == 0) {
            assert (this.localAddress.getAddress().equals(target.getAddress()));
            Net.bind(this.family, this.fd, target.getAddress(), target.getPort());
            this.localAddress = Net.localAddress(this.fd);
            return;
        }
        HashMap map = new HashMap();
        for (SocketOption<?> option2 : this.supportedOptions()) {
            Object value2 = this.getOption(option2);
            if (value2 == null) continue;
            map.put(option2, value2);
        }
        FileDescriptor newfd = Net.socket(this.family, false);
        try {
            for (Map.Entry e : map.entrySet()) {
                option = (SocketOption)e.getKey();
                if (SocketOptionRegistry.findOption(option, Net.UNSPEC) == null) continue;
                value = e.getValue();
                try {
                    Net.setSocketOption(newfd, Net.UNSPEC, option, value);
                }
                catch (IOException iOException) {}
            }
            if (!this.isBlocking()) {
                IOUtil.configureBlocking(newfd, false);
            }
            nd.dup(newfd, this.fd);
        }
        finally {
            nd.close(newfd);
        }
        try {
            Net.bind(this.family, this.fd, target.getAddress(), target.getPort());
        }
        catch (IOException ioe) {
            this.localAddress = null;
            throw ioe;
        }
        this.localAddress = Net.localAddress(this.fd);
        for (Map.Entry e : map.entrySet()) {
            option = (SocketOption)e.getKey();
            value = e.getValue();
            try {
                this.setOption(option, value);
            }
            catch (IOException iOException) {}
        }
        MembershipRegistry registry = this.registry;
        if (registry != null) {
            registry.forEach(k -> {
                if (k instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)k;
                    Net.join6(this.fd, key6.groupAddress(), key6.index(), key6.source());
                } else {
                    MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)k;
                    Net.join4(this.fd, key4.groupAddress(), key4.interfaceAddress(), key4.source());
                }
            });
        }
        AbstractSelectableChannels.forEach(this, SelectionKeyImpl::reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MembershipKey innerJoin(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        SecurityManager sm;
        if (!group.isMulticastAddress()) {
            throw new IllegalArgumentException("Group not a multicast address");
        }
        if (group instanceof Inet4Address) {
            if (this.family == StandardProtocolFamily.INET6 && !Net.canIPv6SocketJoinIPv4Group()) {
                throw new IllegalArgumentException("IPv6 socket cannot join IPv4 multicast group");
            }
        } else if (group instanceof Inet6Address) {
            if (this.family != StandardProtocolFamily.INET6) {
                throw new IllegalArgumentException("Only IPv6 sockets can join IPv6 multicast group");
            }
        } else {
            throw new IllegalArgumentException("Address type not supported");
        }
        if (source != null) {
            if (source.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (source.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (source.getClass() != group.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkMulticast(group);
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            MembershipKey key;
            this.ensureOpen();
            if (this.registry == null) {
                this.registry = new MembershipRegistry();
            } else {
                key = this.registry.checkMembership(group, interf, source);
                if (key != null) {
                    return key;
                }
            }
            if (this.family == StandardProtocolFamily.INET6 && (group instanceof Inet6Address || Net.canJoin6WithIPv4Group())) {
                byte[] sourceAddress;
                int index = interf.getIndex();
                if (index == -1) {
                    throw new IOException("Network interface cannot be identified");
                }
                byte[] groupAddress = Net.inet6AsByteArray(group);
                int n = Net.join6(this.fd, groupAddress, index, sourceAddress = source == null ? null : Net.inet6AsByteArray(source));
                if (n == -2) {
                    throw new UnsupportedOperationException();
                }
                key = new MembershipKeyImpl.Type6(this, group, interf, source, groupAddress, index, sourceAddress);
            } else {
                int sourceAddress;
                int targetAddress;
                Inet4Address target = Net.anyInet4Address(interf);
                if (target == null) {
                    throw new IOException("Network interface not configured for IPv4");
                }
                int groupAddress = Net.inet4AsInt(group);
                int n = Net.join4(this.fd, groupAddress, targetAddress = Net.inet4AsInt(target), sourceAddress = source == null ? 0 : Net.inet4AsInt(source));
                if (n == -2) {
                    throw new UnsupportedOperationException();
                }
                key = new MembershipKeyImpl.Type4(this, group, interf, source, groupAddress, targetAddress, sourceAddress);
            }
            this.registry.add((MembershipKeyImpl)key);
            return key;
        }
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf) throws IOException {
        return this.innerJoin(group, interf, null);
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        Objects.requireNonNull(source);
        return this.innerJoin(group, interf, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drop(MembershipKeyImpl key) {
        assert (key.channel() == this);
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (!key.isValid()) {
                return;
            }
            try {
                if (key instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                    Net.drop6(this.fd, key6.groupAddress(), key6.index(), key6.source());
                } else {
                    MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                    Net.drop4(this.fd, key4.groupAddress(), key4.interfaceAddress(), key4.source());
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            key.invalidate();
            this.registry.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MembershipKey findMembership(InetAddress group, NetworkInterface interf) {
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (this.registry != null) {
                return this.registry.checkMembership(group, interf, null);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void block(MembershipKeyImpl key, InetAddress source) throws IOException {
        assert (key.channel() == this);
        assert (key.sourceAddress() == null);
        Object object2 = this.stateLock;
        synchronized (object2) {
            int n;
            if (!key.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            if (source.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (source.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (source.getClass() != key.group().getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            if (key instanceof MembershipKeyImpl.Type6) {
                MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                n = Net.block6(this.fd, key6.groupAddress(), key6.index(), Net.inet6AsByteArray(source));
            } else {
                MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                n = Net.block4(this.fd, key4.groupAddress(), key4.interfaceAddress(), Net.inet4AsInt(source));
            }
            if (n == -2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblock(MembershipKeyImpl key, InetAddress source) {
        assert (key.channel() == this);
        assert (key.sourceAddress() == null);
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (!key.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            try {
                if (key instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                    Net.unblock6(this.fd, key6.groupAddress(), key6.index(), Net.inet6AsByteArray(source));
                } else {
                    MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                    Net.unblock4(this.fd, key4.groupAddress(), key4.interfaceAddress(), Net.inet4AsInt(source));
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
    }

    private boolean tryClose() throws IOException {
        assert (Thread.holdsLock(this.stateLock) && this.state == 2);
        if (this.readerThread == 0L && this.writerThread == 0L && !this.isRegistered()) {
            this.state = 3;
            try {
                this.cleaner.clean();
            }
            catch (UncheckedIOException ioe) {
                throw ioe.getCause();
            }
            return true;
        }
        return false;
    }

    private void tryFinishClose() {
        try {
            this.tryClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implCloseBlockingMode() throws IOException {
        Object object2 = this.stateLock;
        synchronized (object2) {
            assert (this.state < 2);
            this.state = 2;
            if (this.registry != null) {
                this.registry.invalidateAll();
            }
            if (!this.tryClose()) {
                long reader = this.readerThread;
                long writer = this.writerThread;
                if (reader != 0L || writer != 0L) {
                    nd.preClose(this.fd);
                    if (reader != 0L) {
                        NativeThread.signal(reader);
                    }
                    if (writer != 0L) {
                        NativeThread.signal(writer);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implCloseNonBlockingMode() throws IOException {
        Object object2 = this.stateLock;
        synchronized (object2) {
            assert (this.state < 2);
            this.state = 2;
            if (this.registry != null) {
                this.registry.invalidateAll();
            }
        }
        this.readLock.lock();
        this.readLock.unlock();
        this.writeLock.lock();
        this.writeLock.unlock();
        object2 = this.stateLock;
        synchronized (object2) {
            if (this.state == 2) {
                this.tryClose();
            }
        }
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        assert (!this.isOpen());
        if (this.isBlocking()) {
            this.implCloseBlockingMode();
        } else {
            this.implCloseNonBlockingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (this.state == 2) {
                this.tryFinishClose();
            }
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl ski) {
        int intOps = ski.nioInterestOps();
        int oldOps = ski.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            ski.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0) {
            newOps |= 4;
        }
        ski.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, ski.nioReadyOps(), ski);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, 0, ski);
    }

    @Override
    public int translateInterestOps(int ops) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        if ((ops & 8) != 0) {
            newOps |= Net.POLLIN;
        }
        return newOps;
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private static Runnable releaserFor(FileDescriptor fd, NativeSocketAddress ... sockAddrs) {
        return () -> {
            try {
                nd.close(fd);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            finally {
                ResourceManager.afterUdpClose();
                NativeSocketAddress.freeAll(sockAddrs);
            }
        };
    }

    private static native void disconnect0(FileDescriptor var0, boolean var1) throws IOException;

    private static native int receive0(FileDescriptor var0, long var1, int var3, long var4, boolean var6) throws IOException;

    private static native int send0(FileDescriptor var0, long var1, int var3, long var4, int var6) throws IOException;

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            SOCKET = l.findVarHandle(DatagramChannelImpl.class, "socket", DatagramSocket.class);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
        IOUtil.load();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet set = new HashSet();
            set.add(StandardSocketOptions.SO_SNDBUF);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            if (Net.isReusePortAvailable()) {
                set.add(StandardSocketOptions.SO_REUSEPORT);
            }
            set.add(StandardSocketOptions.SO_BROADCAST);
            set.add(StandardSocketOptions.IP_TOS);
            set.add(StandardSocketOptions.IP_MULTICAST_IF);
            set.add(StandardSocketOptions.IP_MULTICAST_TTL);
            set.add(StandardSocketOptions.IP_MULTICAST_LOOP);
            set.addAll(ExtendedSocketOptions.datagramSocketOptions());
            return Collections.unmodifiableSet(set);
        }
    }

    private static class AbstractSelectableChannels {
        private static final Method FOREACH;

        private AbstractSelectableChannels() {
        }

        static void forEach(AbstractSelectableChannel ch, Consumer<SelectionKeyImpl> action) {
            try {
                FOREACH.invoke(ch, action);
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }

        static {
            try {
                PrivilegedExceptionAction<Method> pae = () -> {
                    Method m = AbstractSelectableChannel.class.getDeclaredMethod("forEach", Consumer.class);
                    m.setAccessible(true);
                    return m;
                };
                FOREACH = AccessController.doPrivileged(pae);
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }
}

