/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.Util;

public class DatagramSocketAdaptor
extends MulticastSocket {
    private final DatagramChannelImpl dc;
    private volatile int timeout;
    private final ReentrantLock sendLock = new ReentrantLock();
    private final Object outgoingInterfaceLock = new Object();
    private NetworkInterface outgoingNetworkInterface;
    private InetAddress outgoingInetAddress;

    private DatagramSocketAdaptor(DatagramChannelImpl dc) throws IOException {
        super(DatagramSockets.NO_DELEGATE);
        this.dc = dc;
    }

    static DatagramSocket create(DatagramChannelImpl dc) {
        try {
            return new DatagramSocketAdaptor(dc);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void connectInternal(SocketAddress remote) throws SocketException {
        try {
            this.dc.connect(remote, false);
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public void bind(SocketAddress local) throws SocketException {
        local = local != null ? Net.asInetSocketAddress(local) : new InetSocketAddress(0);
        try {
            this.dc.bind(local);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public void connect(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        try {
            this.connectInternal(new InetSocketAddress(address, port));
        }
        catch (SocketException x) {
            throw new UncheckedIOException(x);
        }
    }

    @Override
    public void connect(SocketAddress remote) throws SocketException {
        if (remote == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(Net.asInetSocketAddress(remote));
    }

    @Override
    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    @Override
    public boolean isBound() {
        return this.dc.localAddress() != null;
    }

    @Override
    public boolean isConnected() {
        return this.dc.remoteAddress() != null;
    }

    @Override
    public InetAddress getInetAddress() {
        InetSocketAddress remote = this.dc.remoteAddress();
        return remote != null ? remote.getAddress() : null;
    }

    @Override
    public int getPort() {
        InetSocketAddress remote = this.dc.remoteAddress();
        return remote != null ? remote.getPort() : -1;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.dc.remoteAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        InetSocketAddress local = this.dc.localAddress();
        if (local == null || this.isClosed()) {
            return null;
        }
        InetAddress addr = local.getAddress();
        if (addr.isAnyLocalAddress()) {
            return local;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(addr.getHostAddress(), -1);
            }
            catch (SecurityException x) {
                return new InetSocketAddress(local.getPort());
            }
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        ByteBuffer bb = null;
        try {
            InetSocketAddress target;
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                int len = p.getLength();
                bb = Util.getTemporaryDirectBuffer(len);
                bb.put(p.getData(), p.getOffset(), len);
                bb.flip();
                if (p.getAddress() == null) {
                    InetSocketAddress remote = this.dc.remoteAddress();
                    if (remote == null) {
                        throw new IllegalArgumentException("Address not set");
                    }
                    p.setAddress(remote.getAddress());
                    p.setPort(remote.getPort());
                    target = remote;
                } else {
                    target = (InetSocketAddress)p.getSocketAddress();
                }
            }
            try {
                this.dc.blockingSend(bb, target);
            }
            catch (AlreadyConnectedException e) {
                throw new IllegalArgumentException("Connected and packet address differ");
            }
            catch (ClosedChannelException e) {
                SocketException exc = new SocketException("Socket closed");
                exc.initCause(e);
                throw exc;
            }
            if (bb == null) return;
        }
        catch (Throwable throwable) {
            if (bb == null) throw throwable;
            Util.offerFirstTemporaryDirectBuffer(bb);
            throw throwable;
        }
        Util.offerFirstTemporaryDirectBuffer(bb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(DatagramPacket p) throws IOException {
        int bufLength = DatagramPackets.getBufLength(p);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(bufLength);
        try {
            long nanos = TimeUnit.MILLISECONDS.toNanos(this.timeout);
            SocketAddress sender = this.dc.blockingReceive(bb, nanos);
            bb.flip();
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                int len = Math.min(bb.limit(), DatagramPackets.getBufLength(p));
                bb.get(p.getData(), p.getOffset(), len);
                DatagramPackets.setLength(p, len);
                p.setSocketAddress(sender);
            }
        }
        catch (ClosedChannelException e) {
            SocketException exc = new SocketException("Socket closed");
            exc.initCause(e);
            throw exc;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(bb);
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        InetSocketAddress local = this.dc.localAddress();
        if (local == null) {
            local = new InetSocketAddress(0);
        }
        InetAddress result = local.getAddress();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(result.getHostAddress(), -1);
            }
            catch (SecurityException x) {
                return new InetSocketAddress(0).getAddress();
            }
        }
        return result;
    }

    @Override
    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        InetSocketAddress local = this.dc.localAddress();
        if (local != null) {
            return local.getPort();
        }
        return 0;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.timeout = timeout;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    private void setBooleanOption(SocketOption<Boolean> name, boolean value) throws SocketException {
        try {
            this.dc.setOption((SocketOption)name, (Object)value);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    private void setIntOption(SocketOption<Integer> name, int value) throws SocketException {
        try {
            this.dc.setOption((SocketOption)name, (Object)value);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> name) throws SocketException {
        try {
            return this.dc.getOption(name);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> name) throws SocketException {
        try {
            return this.dc.getOption(name);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return -1;
        }
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void setBroadcast(boolean on) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_BROADCAST, on);
    }

    @Override
    public boolean getBroadcast() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_BROADCAST);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.setIntOption(StandardSocketOptions.IP_TOS, tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getIntOption(StandardSocketOptions.IP_TOS);
    }

    @Override
    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    @Override
    public DatagramChannel getChannel() {
        return this.dc;
    }

    @Override
    public <T> DatagramSocket setOption(SocketOption<T> name, T value) throws IOException {
        this.dc.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.dc.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.dc.supportedOptions();
    }

    @Override
    @Deprecated
    public void setTTL(byte ttl) throws IOException {
        this.setTimeToLive(Byte.toUnsignedInt(ttl));
    }

    @Override
    public void setTimeToLive(int ttl) throws IOException {
        this.sendLock.lock();
        try {
            this.setIntOption(StandardSocketOptions.IP_MULTICAST_TTL, ttl);
        }
        finally {
            this.sendLock.unlock();
        }
    }

    @Override
    @Deprecated
    public byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    @Override
    public int getTimeToLive() throws IOException {
        this.sendLock.lock();
        try {
            int n = this.getIntOption(StandardSocketOptions.IP_MULTICAST_TTL);
            return n;
        }
        finally {
            this.sendLock.unlock();
        }
    }

    @Override
    @Deprecated
    public void joinGroup(InetAddress group) throws IOException {
        Objects.requireNonNull(group);
        try {
            this.joinGroup(new InetSocketAddress(group, 0), null);
        }
        catch (IllegalArgumentException iae) {
            throw (SocketException)new SocketException("joinGroup failed").initCause(iae);
        }
    }

    @Override
    @Deprecated
    public void leaveGroup(InetAddress group) throws IOException {
        Objects.requireNonNull(group);
        try {
            this.leaveGroup(new InetSocketAddress(group, 0), null);
        }
        catch (IllegalArgumentException iae) {
            throw (SocketException)new SocketException("leaveGroup failed").initCause(iae);
        }
    }

    private static InetAddress checkGroup(SocketAddress mcastaddr) throws SocketException {
        if (!(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress addr = (InetSocketAddress)mcastaddr;
        InetAddress group = addr.getAddress();
        if (group == null) {
            throw new IllegalArgumentException("Unresolved address");
        }
        if (!group.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        NetworkInterface ni;
        InetAddress group = DatagramSocketAdaptor.checkGroup(mcastaddr);
        NetworkInterface networkInterface = ni = netIf != null ? netIf : this.defaultNetworkInterface();
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        DatagramSocketAdaptor datagramSocketAdaptor = this;
        synchronized (datagramSocketAdaptor) {
            MembershipKey key = this.dc.findMembership(group, ni);
            if (key != null) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkMulticast(group);
                }
                throw new SocketException("Already a member of group");
            }
            this.dc.join(group, ni);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        NetworkInterface ni;
        InetAddress group = DatagramSocketAdaptor.checkGroup(mcastaddr);
        NetworkInterface networkInterface = ni = netIf != null ? netIf : this.defaultNetworkInterface();
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkMulticast(group);
        }
        DatagramSocketAdaptor datagramSocketAdaptor = this;
        synchronized (datagramSocketAdaptor) {
            MembershipKey key = this.dc.findMembership(group, ni);
            if (key == null) {
                throw new SocketException("Not a member of group");
            }
            key.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setInterface(InetAddress inf) throws SocketException {
        if (inf == null) {
            throw new SocketException("Invalid value 'null'");
        }
        NetworkInterface ni = NetworkInterface.getByInetAddress(inf);
        if (ni == null) {
            String address = inf.getHostAddress();
            throw new SocketException("No network interface with address " + address);
        }
        Object object2 = this.outgoingInterfaceLock;
        synchronized (object2) {
            this.setNetworkInterface(ni);
            this.outgoingNetworkInterface = ni;
            this.outgoingInetAddress = inf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InetAddress getInterface() throws SocketException {
        Object object2 = this.outgoingInterfaceLock;
        synchronized (object2) {
            NetworkInterface ni = this.outgoingNetworkInterface();
            if (ni != null) {
                if (ni.equals(this.outgoingNetworkInterface)) {
                    return this.outgoingInetAddress;
                }
                PrivilegedAction<InetAddress> pa = () -> ni.inetAddresses().findFirst().orElse(null);
                InetAddress ia = AccessController.doPrivileged(pa);
                if (ia == null) {
                    throw new SocketException("Network interface has no IP address");
                }
                this.outgoingNetworkInterface = ni;
                this.outgoingInetAddress = ia;
                return ia;
            }
        }
        return this.anyInetAddress();
    }

    @Override
    public void setNetworkInterface(NetworkInterface netIf) throws SocketException {
        try {
            this.setOption(StandardSocketOptions.IP_MULTICAST_IF, netIf);
        }
        catch (IOException e) {
            Net.translateToSocketException(e);
        }
    }

    @Override
    public NetworkInterface getNetworkInterface() throws SocketException {
        NetworkInterface ni = this.outgoingNetworkInterface();
        if (ni == null) {
            ni = this.anyNetworkInterface();
        }
        return ni;
    }

    @Override
    @Deprecated
    public void setLoopbackMode(boolean disable) throws SocketException {
        boolean enable = !disable;
        this.setBooleanOption(StandardSocketOptions.IP_MULTICAST_LOOP, enable);
    }

    @Override
    @Deprecated
    public boolean getLoopbackMode() throws SocketException {
        boolean enabled = this.getBooleanOption(StandardSocketOptions.IP_MULTICAST_LOOP);
        return !enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void send(DatagramPacket p, byte ttl) throws IOException {
        this.sendLock.lock();
        try {
            int oldValue = this.getTimeToLive();
            try {
                this.setTTL(ttl);
                this.send(p);
            }
            finally {
                this.setTimeToLive(oldValue);
            }
        }
        finally {
            this.sendLock.unlock();
        }
    }

    private NetworkInterface outgoingNetworkInterface() throws SocketException {
        try {
            return this.getOption(StandardSocketOptions.IP_MULTICAST_IF);
        }
        catch (IOException e) {
            Net.translateToSocketException(e);
            return null;
        }
    }

    private NetworkInterface defaultNetworkInterface() throws SocketException {
        NetworkInterface ni = this.outgoingNetworkInterface();
        if (ni == null) {
            ni = NetworkInterfaces.getDefault();
        }
        if (ni == null) {
            ni = this.anyNetworkInterface();
        }
        return ni;
    }

    private NetworkInterface anyNetworkInterface() {
        InetAddress[] addrs = new InetAddress[]{this.anyInetAddress()};
        return NetworkInterfaces.newNetworkInterface(addrs[0].getHostName(), 0, addrs);
    }

    private InetAddress anyInetAddress() {
        return new InetSocketAddress(0).getAddress();
    }

    private static class DatagramSockets {
        private static final SocketAddress NO_DELEGATE;

        private DatagramSockets() {
        }

        static {
            try {
                PrivilegedExceptionAction<MethodHandles.Lookup> pa = () -> MethodHandles.privateLookupIn(DatagramSocket.class, MethodHandles.lookup());
                MethodHandles.Lookup l = AccessController.doPrivileged(pa);
                NO_DELEGATE = l.findStaticVarHandle(DatagramSocket.class, "NO_DELEGATE", SocketAddress.class).get();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class DatagramPackets {
        private static final VarHandle LENGTH;
        private static final VarHandle BUF_LENGTH;

        private DatagramPackets() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void setLength(DatagramPacket p, int value) {
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                LENGTH.set(p, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int getBufLength(DatagramPacket p) {
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                return BUF_LENGTH.get(p);
            }
        }

        static {
            try {
                PrivilegedExceptionAction<MethodHandles.Lookup> pa = () -> MethodHandles.privateLookupIn(DatagramPacket.class, MethodHandles.lookup());
                MethodHandles.Lookup l = AccessController.doPrivileged(pa);
                LENGTH = l.findVarHandle(DatagramPacket.class, "length", Integer.TYPE);
                BUF_LENGTH = l.findVarHandle(DatagramPacket.class, "bufLength", Integer.TYPE);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class NetworkInterfaces {
        static final MethodHandle GET_DEFAULT;
        static final MethodHandle CONSTRUCTOR;

        private NetworkInterfaces() {
        }

        static NetworkInterface getDefault() {
            try {
                return GET_DEFAULT.invokeExact();
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        static NetworkInterface newNetworkInterface(String name, int index, InetAddress[] addrs) {
            try {
                return CONSTRUCTOR.invoke(name, index, addrs);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        static {
            try {
                PrivilegedExceptionAction<MethodHandles.Lookup> pa = () -> MethodHandles.privateLookupIn(NetworkInterface.class, MethodHandles.lookup());
                MethodHandles.Lookup l = AccessController.doPrivileged(pa);
                MethodType methodType = MethodType.methodType(NetworkInterface.class);
                GET_DEFAULT = l.findStatic(NetworkInterface.class, "getDefault", methodType);
                methodType = MethodType.methodType(Void.TYPE, String.class, Integer.TYPE, InetAddress[].class);
                CONSTRUCTOR = l.findConstructor(NetworkInterface.class, methodType);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

