/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.nio.ch.EPoll;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class EPollPort
extends Port {
    private static final int MAX_EPOLL_EVENTS = 512;
    private static final int ENOENT = 2;
    private final int epfd;
    private final long address;
    private boolean closed;
    private final int[] sp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    EPollPort(AsynchronousChannelProvider provider, ThreadPool pool) throws IOException {
        super(provider, pool);
        this.epfd = EPoll.create();
        this.address = EPoll.allocatePollArray(512);
        try {
            long fds = IOUtil.makePipe(true);
            this.sp = new int[]{(int)(fds >>> 32), (int)fds};
        }
        catch (IOException ioe) {
            EPoll.freePollArray(this.address);
            FileDispatcherImpl.closeIntFD(this.epfd);
            throw ioe;
        }
        EPoll.ctl(this.epfd, 1, this.sp[0], 1);
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    EPollPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        EPollPort ePollPort = this;
        synchronized (ePollPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            FileDispatcherImpl.closeIntFD(this.epfd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileDispatcherImpl.closeIntFD(this.sp[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileDispatcherImpl.closeIntFD(this.sp[1]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EPoll.freePollArray(this.address);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                IOUtil.write1(this.sp[1], (byte)0);
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable task) {
        EPollPort ePollPort = this;
        synchronized (ePollPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(task);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int nThreads = this.threadCount();
        if (nThreads == 0) {
            this.implClose();
        } else {
            while (nThreads-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int fd, int events) {
        int err = EPoll.ctl(this.epfd, 3, fd, events | 0x40000000);
        if (err == 2) {
            err = EPoll.ctl(this.epfd, 1, fd, events | 0x40000000);
        }
        if (err != 0) {
            throw new AssertionError();
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel channel, int events) {
            this.channel = channel;
            this.events = events;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block10: while (true) {
                    int n;
                    if ((n = EPoll.wait(EPollPort.this.epfd, EPollPort.this.address, 512, -1)) == -3) {
                        continue;
                    }
                    EPollPort.this.fdToChannelLock.readLock().lock();
                    try {
                        while (true) {
                            if (n-- <= 0) continue block10;
                            long eventAddress = EPoll.getEvent(EPollPort.this.address, n);
                            int fd = EPoll.getDescriptor(eventAddress);
                            if (fd == EPollPort.this.sp[0]) {
                                if (EPollPort.this.wakeupCount.decrementAndGet() == 0) {
                                    int nread;
                                    while ((nread = IOUtil.drain1(EPollPort.this.sp[0])) == -3) {
                                    }
                                }
                                if (n <= 0) {
                                    Event nread = EPollPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return nread;
                                }
                                EPollPort.this.queue.offer(EPollPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            Port.PollableChannel channel = (Port.PollableChannel)EPollPort.this.fdToChannel.get(fd);
                            if (channel == null) continue;
                            int events = EPoll.getEvents(eventAddress);
                            Event ev = new Event(channel, events);
                            if (n <= 0) {
                                Event event = ev;
                                return event;
                            }
                            EPollPort.this.queue.offer(ev);
                        }
                    }
                    finally {
                        EPollPort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                EPollPort.this.queue.offer(EPollPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

