/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Objects;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.UnmapperProxy;
import jdk.internal.misc.ExtendedMapMode;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.ref.Cleaner;
import jdk.internal.ref.CleanerFactory;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;

public class FileChannelImpl
extends FileChannel {
    private static final long allocationGranularity;
    private static final JavaIOFileDescriptorAccess fdAccess;
    private static final int MAX_DIRECT_TRANSFER_SIZE;
    private final FileDispatcher nd;
    private final FileDescriptor fd;
    private final boolean writable;
    private final boolean readable;
    private final Object parent;
    private final String path;
    private final NativeThreadSet threads = new NativeThreadSet(2);
    private final Object positionLock = new Object();
    private volatile boolean uninterruptible;
    private final boolean direct;
    private final int alignment;
    private final Cleaner.Cleanable closer;
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final long MAPPED_TRANSFER_SIZE = 0x800000L;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_INVALID = -1;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private volatile FileLockTable fileLockTable;

    private FileChannelImpl(FileDescriptor fd, String path, boolean readable, boolean writable, boolean direct, Object parent) {
        this.fd = fd;
        this.readable = readable;
        this.writable = writable;
        this.parent = parent;
        this.path = path;
        this.direct = direct;
        this.nd = new FileDispatcherImpl();
        if (direct) {
            assert (path != null);
            this.alignment = this.nd.setDirectIO(fd, path);
        } else {
            this.alignment = -1;
        }
        this.closer = parent != null ? null : CleanerFactory.cleaner().register(this, new Closer(fd));
    }

    public static FileChannel open(FileDescriptor fd, String path, boolean readable, boolean writable, boolean direct, Object parent) {
        return new FileChannelImpl(fd, path, readable, writable, direct, parent);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    public void setUninterruptible() {
        this.uninterruptible = true;
    }

    private void beginBlocking() {
        if (!this.uninterruptible) {
            this.begin();
        }
    }

    private void endBlocking(boolean completed) throws AsynchronousCloseException {
        if (!this.uninterruptible) {
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        if (!this.fd.valid()) {
            return;
        }
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fl;
                FileLock fileLock = fl = iterator.next();
                synchronized (fileLock) {
                    if (fl.isValid()) {
                        this.nd.release(this.fd, fl.position(), fl.size());
                        ((FileLockImpl)fl).invalidate();
                    }
                }
            }
        }
        this.threads.signalAndWait();
        if (this.parent != null) {
            ((Closeable)this.parent).close();
        } else if (this.closer != null) {
            try {
                this.closer.clean();
            }
            catch (UncheckedIOException uioe) {
                throw uioe.getCause();
            }
        } else {
            fdAccess.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            int n3;
            int ti;
            int n;
            block11: {
                if (this.direct) {
                    Util.checkChannelPositionAligned(this.position(), this.alignment);
                }
                n = 0;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                int n2 = 0;
                this.threads.remove(ti);
                this.endBlocking(n > 0);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                while ((n = IOUtil.read(this.fd, dst, -1L, this.direct, this.alignment, this.nd)) == -3 && this.isOpen()) {
                }
                n3 = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.endBlocking(n > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dsts.length);
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            long l;
            int ti;
            long n;
            block11: {
                if (this.direct) {
                    Util.checkChannelPositionAligned(this.position(), this.alignment);
                }
                n = 0L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
                assert (IOStatus.check(n));
                return l2;
            }
            try {
                while ((n = IOUtil.read(this.fd, dsts, offset, length, this.direct, this.alignment, (NativeDispatcher)this.nd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            int n3;
            int ti;
            int n;
            block11: {
                if (this.direct) {
                    Util.checkChannelPositionAligned(this.position(), this.alignment);
                }
                n = 0;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                int n2 = 0;
                this.threads.remove(ti);
                this.endBlocking(n > 0);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                while ((n = IOUtil.write(this.fd, src, -1L, this.direct, this.alignment, this.nd)) == -3 && this.isOpen()) {
                }
                n3 = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.endBlocking(n > 0);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, srcs.length);
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            long l;
            int ti;
            long n;
            block11: {
                if (this.direct) {
                    Util.checkChannelPositionAligned(this.position(), this.alignment);
                }
                n = 0L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
                assert (IOStatus.check(n));
                return l2;
            }
            try {
                while ((n = IOUtil.write(this.fd, srcs, offset, length, this.direct, this.alignment, (NativeDispatcher)this.nd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(n);
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long position() throws IOException {
        this.ensureOpen();
        Object object2 = this.positionLock;
        synchronized (object2) {
            long l;
            int ti;
            long p;
            block9: {
                p = -1L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = 0L;
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
                assert (IOStatus.check(p));
                return l2;
            }
            try {
                boolean append = fdAccess.getAppend(this.fd);
                do {
                    long l3 = p = append ? this.nd.size(this.fd) : this.nd.seek(this.fd, -1L);
                } while (p == -3L && this.isOpen());
                l = IOStatus.normalize(p);
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
                assert (IOStatus.check(p));
                throw throwable;
            }
            assert (IOStatus.check(p));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            FileChannelImpl fileChannelImpl;
            int ti;
            long p;
            block10: {
                p = -1L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block10;
                FileChannel fileChannel = null;
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
                assert (IOStatus.check(p));
                return fileChannel;
            }
            try {
                while ((p = this.nd.seek(this.fd, newPosition)) == -3L && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(p > -1L);
                assert (IOStatus.check(p));
                throw throwable;
            }
            assert (IOStatus.check(p));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() throws IOException {
        this.ensureOpen();
        Object object2 = this.positionLock;
        synchronized (object2) {
            long l;
            int ti;
            long s;
            block9: {
                s = -1L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block9;
                long l2 = -1L;
                this.threads.remove(ti);
                this.endBlocking(s > -1L);
                assert (IOStatus.check(s));
                return l2;
            }
            try {
                while ((s = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(s);
                this.threads.remove(ti);
                this.endBlocking(s > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(s > -1L);
                assert (IOStatus.check(s));
                throw throwable;
            }
            assert (IOStatus.check(s));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileChannel truncate(long newSize) throws IOException {
        this.ensureOpen();
        if (newSize < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object2 = this.positionLock;
        synchronized (object2) {
            FileChannelImpl fileChannelImpl;
            long rp;
            int ti;
            long p;
            int rv;
            block25: {
                long size;
                block24: {
                    block23: {
                        block22: {
                            rv = -1;
                            p = -1L;
                            ti = -1;
                            rp = -1L;
                            this.beginBlocking();
                            ti = this.threads.add();
                            if (this.isOpen()) break block22;
                            FileChannel fileChannel = null;
                            this.threads.remove(ti);
                            this.endBlocking(rv > -1);
                            assert (IOStatus.check(rv));
                            return fileChannel;
                        }
                        while ((size = this.nd.size(this.fd)) == -3L && this.isOpen()) {
                        }
                        if (this.isOpen()) break block23;
                        FileChannel fileChannel = null;
                        this.threads.remove(ti);
                        this.endBlocking(rv > -1);
                        assert (IOStatus.check(rv));
                        return fileChannel;
                    }
                    while ((p = this.nd.seek(this.fd, -1L)) == -3L && this.isOpen()) {
                    }
                    if (this.isOpen()) break block24;
                    FileChannel fileChannel = null;
                    this.threads.remove(ti);
                    this.endBlocking(rv > -1);
                    assert (IOStatus.check(rv));
                    return fileChannel;
                }
                assert (p >= 0L);
                if (newSize >= size) break block25;
                while ((rv = this.nd.truncate(this.fd, newSize)) == -3 && this.isOpen()) {
                }
                if (this.isOpen()) break block25;
                FileChannel fileChannel = null;
                this.threads.remove(ti);
                this.endBlocking(rv > -1);
                assert (IOStatus.check(rv));
                return fileChannel;
            }
            try {
                if (p > newSize) {
                    p = newSize;
                }
                while ((rp = this.nd.seek(this.fd, p)) == -3L && this.isOpen()) {
                }
                fileChannelImpl = this;
                this.threads.remove(ti);
                this.endBlocking(rv > -1);
            }
            catch (Throwable throwable) {
                this.threads.remove(ti);
                this.endBlocking(rv > -1);
                assert (IOStatus.check(rv));
                throw throwable;
            }
            assert (IOStatus.check(rv));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean metaData) throws IOException {
        int ti;
        int rv;
        block7: {
            this.ensureOpen();
            rv = -1;
            ti = -1;
            this.beginBlocking();
            ti = this.threads.add();
            if (this.isOpen()) break block7;
            this.threads.remove(ti);
            this.endBlocking(rv > -1);
            assert (IOStatus.check(rv));
            return;
        }
        try {
            while ((rv = this.nd.force(this.fd, metaData)) == -3 && this.isOpen()) {
            }
            this.threads.remove(ti);
            this.endBlocking(rv > -1);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.endBlocking(rv > -1);
            assert (IOStatus.check(rv));
            throw throwable;
        }
        assert (IOStatus.check(rv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectlyInternal(long position, int icount, WritableByteChannel target, FileDescriptor targetFD) throws IOException {
        int ti;
        long n;
        block11: {
            block10: {
                long l;
                block9: {
                    assert (!this.nd.transferToDirectlyNeedsPositionLock() || Thread.holdsLock(this.positionLock));
                    n = -1L;
                    ti = -1;
                    this.beginBlocking();
                    ti = this.threads.add();
                    if (this.isOpen()) break block9;
                    long l2 = -1L;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    return l2;
                }
                try {
                    while ((n = this.transferTo0(this.fd, position, icount, targetFD)) == -3L && this.isOpen()) {
                    }
                    if (n != -6L) break block10;
                    if (target instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (target instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l = -6L;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                }
                catch (Throwable throwable) {
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    throw throwable;
                }
                return l;
            }
            if (n != -4L) break block11;
            transferSupported = false;
            long l = -4L;
            this.threads.remove(ti);
            this.end(n > -1L);
            return l;
        }
        long l = IOStatus.normalize(n);
        this.threads.remove(ti);
        this.end(n > -1L);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long position, int icount, WritableByteChannel target) throws IOException {
        int targetFDVal;
        if (!transferSupported) {
            return -4L;
        }
        FileDescriptor targetFD = null;
        if (target instanceof FileChannelImpl) {
            if (!fileSupported) {
                return -6L;
            }
            targetFD = ((FileChannelImpl)target).fd;
        } else if (target instanceof SelChImpl) {
            if (target instanceof SinkChannelImpl && !pipeSupported) {
                return -6L;
            }
            SelectableChannel sc = (SelectableChannel)((Object)target);
            if (!this.nd.canTransferToDirectly(sc)) {
                return -6L;
            }
            targetFD = ((SelChImpl)((Object)target)).getFD();
        }
        if (targetFD == null) {
            return -4L;
        }
        int thisFDVal = IOUtil.fdVal(this.fd);
        if (thisFDVal == (targetFDVal = IOUtil.fdVal(targetFD))) {
            return -4L;
        }
        if (this.nd.transferToDirectlyNeedsPositionLock()) {
            Object object2 = this.positionLock;
            synchronized (object2) {
                long l;
                long pos = this.position();
                try {
                    l = this.transferToDirectlyInternal(position, icount, target, targetFD);
                }
                catch (Throwable throwable) {
                    this.position(pos);
                    throw throwable;
                }
                this.position(pos);
                return l;
            }
        }
        return this.transferToDirectlyInternal(position, icount, target, targetFD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long position, long count, WritableByteChannel target) throws IOException {
        long posThis;
        boolean isSelChImpl = target instanceof SelChImpl;
        if (!(target instanceof FileChannelImpl) && !isSelChImpl) {
            return -4L;
        }
        if (target == this && (posThis = this.position()) - count + 1L <= position && position - count + 1L <= posThis && !this.nd.canTransferToFromOverlappedMap()) {
            return -6L;
        }
        long remaining = count;
        while (remaining > 0L) {
            long size = Math.min(remaining, 0x800000L);
            try {
                MappedByteBuffer dbb = this.map(FileChannel.MapMode.READ_ONLY, position, size);
                try {
                    int n = target.write(dbb);
                    assert (n >= 0);
                    remaining -= (long)n;
                    if (isSelChImpl) break;
                    assert (n > 0);
                    position += (long)n;
                }
                finally {
                    FileChannelImpl.unmap(dbb);
                }
            }
            catch (ClosedByInterruptException e) {
                assert (!target.isOpen());
                try {
                    this.close();
                }
                catch (Throwable suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            catch (IOException ioe) {
                if (remaining != count) break;
                throw ioe;
            }
        }
        return count - remaining;
    }

    private long transferToArbitraryChannel(long position, long count, WritableByteChannel target) throws IOException {
        int c = (int)Math.min(count, 8192L);
        ByteBuffer bb = ByteBuffer.allocate(c);
        long tw = 0L;
        long pos = position;
        try {
            while (tw < count) {
                bb.limit((int)Math.min(count - tw, 8192L));
                int nr = this.read(bb, pos);
                if (nr <= 0) break;
                bb.flip();
                int nw = target.write(bb);
                tw += (long)nw;
                if (nw != nr) break;
                pos += (long)nw;
                bb.clear();
            }
            return tw;
        }
        catch (IOException x) {
            if (tw > 0L) {
                return tw;
            }
            throw x;
        }
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        int icount;
        long n;
        this.ensureOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (target instanceof FileChannelImpl && !((FileChannelImpl)target).writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        long sz = this.size();
        if (position > sz) {
            return 0L;
        }
        if (sz - position < count) {
            count = sz - position;
        }
        if ((n = this.transferToDirectly(position, icount = (int)Math.min(count, (long)MAX_DIRECT_TRANSFER_SIZE), target)) >= 0L) {
            return n;
        }
        n = this.transferToTrustedChannel(position, count, target);
        if (n >= 0L) {
            return n;
        }
        return this.transferToArbitraryChannel(position, count, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromFileChannel(FileChannelImpl src, long position, long count) throws IOException {
        if (!src.readable) {
            throw new NonReadableChannelException();
        }
        Object object2 = src.positionLock;
        synchronized (object2) {
            long pos = src.position();
            long max = Math.min(count, src.size() - pos);
            if (src == this && this.position() - max + 1L <= pos && pos - max + 1L <= this.position() && !this.nd.canTransferToFromOverlappedMap()) {
                return -6L;
            }
            long remaining = max;
            long p = pos;
            while (remaining > 0L) {
                long size = Math.min(remaining, 0x800000L);
                MappedByteBuffer bb = src.map(FileChannel.MapMode.READ_ONLY, p, size);
                try {
                    long n = this.write(bb, position);
                    assert (n > 0L);
                    p += n;
                    position += n;
                    remaining -= n;
                }
                catch (IOException ioe) {
                    if (remaining != max) break;
                    throw ioe;
                }
                finally {
                    FileChannelImpl.unmap(bb);
                }
            }
            long nwritten = max - remaining;
            src.position(pos + nwritten);
            return nwritten;
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel src, long position, long count) throws IOException {
        int c = (int)Math.min(count, 8192L);
        ByteBuffer bb = ByteBuffer.allocate(c);
        long tw = 0L;
        long pos = position;
        try {
            while (tw < count) {
                bb.limit((int)Math.min(count - tw, 8192L));
                int nr = src.read(bb);
                if (nr <= 0) break;
                bb.flip();
                int nw = this.write(bb, pos);
                tw += (long)nw;
                if (nw != nr) break;
                pos += (long)nw;
                bb.clear();
            }
            return tw;
        }
        catch (IOException x) {
            if (tw > 0L) {
                return tw;
            }
            throw x;
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        FileChannelImpl fci;
        long n;
        this.ensureOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (position > this.size()) {
            return 0L;
        }
        if (src instanceof FileChannelImpl && (n = this.transferFromFileChannel(fci = (FileChannelImpl)src, position, count)) >= 0L) {
            return n;
        }
        return this.transferFromArbitraryChannel(src, position, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (this.direct) {
            Util.checkChannelPositionAligned(position, this.alignment);
        }
        if (this.nd.needsPositionLock()) {
            Object object2 = this.positionLock;
            synchronized (object2) {
                return this.readInternal(dst, position);
            }
        }
        return this.readInternal(dst, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInternal(ByteBuffer dst, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n2 = 0;
            ti = -1;
            this.beginBlocking();
            ti = this.threads.add();
            if (this.isOpen()) break block8;
            int n3 = -1;
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            while ((n2 = IOUtil.read(this.fd, dst, position, this.direct, this.alignment, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (src == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (this.direct) {
            Util.checkChannelPositionAligned(position, this.alignment);
        }
        if (this.nd.needsPositionLock()) {
            Object object2 = this.positionLock;
            synchronized (object2) {
                return this.writeInternal(src, position);
            }
        }
        return this.writeInternal(src, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeInternal(ByteBuffer src, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block8: {
            assert (!this.nd.needsPositionLock() || Thread.holdsLock(this.positionLock));
            n2 = 0;
            ti = -1;
            this.beginBlocking();
            ti = this.threads.add();
            if (this.isOpen()) break block8;
            int n3 = -1;
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            while ((n2 = IOUtil.write(this.fd, src, position, this.direct, this.alignment, this.nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
        }
        catch (Throwable throwable) {
            this.threads.remove(ti);
            this.endBlocking(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    private static void unmap(MappedByteBuffer bb) {
        Cleaner cl = ((DirectBuffer)((Object)bb)).cleaner();
        if (cl != null) {
            cl.clean();
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
        }
        boolean isSync = this.isSync(Objects.requireNonNull(mode, "Mode is null"));
        int prot = this.toProt(mode);
        Unmapper unmapper = this.mapInternal(mode, position, size, prot, isSync);
        if (unmapper == null) {
            FileDescriptor dummy = new FileDescriptor();
            if (!this.writable || prot == 0) {
                return Util.newMappedByteBufferR(0, 0L, dummy, null, isSync);
            }
            return Util.newMappedByteBuffer(0, 0L, dummy, null, isSync);
        }
        if (!this.writable || prot == 0) {
            return Util.newMappedByteBufferR((int)unmapper.cap, unmapper.address + (long)unmapper.pagePosition, unmapper.fd, unmapper, isSync);
        }
        return Util.newMappedByteBuffer((int)unmapper.cap, unmapper.address + (long)unmapper.pagePosition, unmapper.fd, unmapper, isSync);
    }

    public Unmapper mapInternal(FileChannel.MapMode mode, long position, long size) throws IOException {
        boolean isSync = this.isSync(Objects.requireNonNull(mode, "Mode is null"));
        int prot = this.toProt(mode);
        return this.mapInternal(mode, position, size, prot, isSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Unmapper mapInternal(FileChannel.MapMode mode, long position, long size, int prot, boolean isSync) throws IOException {
        long l;
        int ti;
        long addr;
        block31: {
            block30: {
                this.ensureOpen();
                if (mode == null) {
                    throw new NullPointerException("Mode is null");
                }
                if (position < 0L) {
                    throw new IllegalArgumentException("Negative position");
                }
                if (size < 0L) {
                    throw new IllegalArgumentException("Negative size");
                }
                if (position + size < 0L) {
                    throw new IllegalArgumentException("Position + size overflow");
                }
                this.checkMode(mode, prot, isSync);
                addr = -1L;
                ti = -1;
                this.beginBlocking();
                ti = this.threads.add();
                if (this.isOpen()) break block30;
                Unmapper unmapper = null;
                this.threads.remove(ti);
                this.endBlocking(IOStatus.checkAll(addr));
                return unmapper;
            }
            Object object2 = this.positionLock;
            // MONITORENTER : object2
            while ((l = this.nd.size(this.fd)) == -3L && this.isOpen()) {
            }
            if (this.isOpen()) break block31;
            Unmapper unmapper = null;
            // MONITOREXIT : object2
            this.threads.remove(ti);
            this.endBlocking(IOStatus.checkAll(addr));
            return unmapper;
        }
        if (l < position + size) {
            int rv;
            if (!this.writable) {
                throw new IOException("Channel not open for writing - cannot extend file to required size");
            }
            while ((rv = this.nd.truncate(this.fd, position + size)) == -3 && this.isOpen()) {
            }
            if (!this.isOpen()) {
                Unmapper unmapper = null;
                // MONITOREXIT : object2
                this.threads.remove(ti);
                this.endBlocking(IOStatus.checkAll(addr));
                return unmapper;
            }
        }
        if (size == 0L) {
            Unmapper rv = null;
            // MONITOREXIT : object2
            this.threads.remove(ti);
            this.endBlocking(IOStatus.checkAll(addr));
            return rv;
        }
        try {
            Unmapper unmapper;
            FileDescriptor mfd;
            int pagePosition = (int)(position % allocationGranularity);
            long mapPosition = position - (long)pagePosition;
            long mapSize = size + (long)pagePosition;
            try {
                addr = this.map0(prot, mapPosition, mapSize, isSync);
            }
            catch (OutOfMemoryError x) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException y) {
                    Thread.currentThread().interrupt();
                }
                try {
                    addr = this.map0(prot, mapPosition, mapSize, isSync);
                }
                catch (OutOfMemoryError y) {
                    throw new IOException("Map failed", y);
                }
            }
            try {
                mfd = this.nd.duplicateForMapping(this.fd);
            }
            catch (IOException iOException) {
                FileChannelImpl.unmap0(addr, mapSize);
                throw iOException;
            }
            assert (IOStatus.checkAll(addr));
            assert (addr % allocationGranularity == 0L);
            Unmapper unmapper2 = unmapper = isSync ? new SyncUnmapper(addr, mapSize, size, mfd, pagePosition) : new DefaultUnmapper(addr, mapSize, size, mfd, pagePosition);
            return unmapper2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.threads.remove(ti);
            this.endBlocking(IOStatus.checkAll(addr));
        }
    }

    private boolean isSync(FileChannel.MapMode mode) {
        return !VM.isModuleSystemInited() ? false : mode == ExtendedMapMode.READ_ONLY_SYNC || mode == ExtendedMapMode.READ_WRITE_SYNC;
    }

    private int toProt(FileChannel.MapMode mode) {
        int prot = mode == FileChannel.MapMode.READ_ONLY ? 0 : (mode == FileChannel.MapMode.READ_WRITE ? 1 : (mode == FileChannel.MapMode.PRIVATE ? 2 : (mode == ExtendedMapMode.READ_ONLY_SYNC ? 0 : (mode == ExtendedMapMode.READ_WRITE_SYNC ? 1 : -1))));
        return prot;
    }

    private void checkMode(FileChannel.MapMode mode, int prot, boolean isSync) {
        if (prot == -1) {
            throw new UnsupportedOperationException();
        }
        if (mode != FileChannel.MapMode.READ_ONLY && mode != ExtendedMapMode.READ_ONLY_SYNC && !this.writable) {
            throw new NonWritableChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (isSync && !Unsafe.isWritebackEnabled()) {
            throw new UnsupportedOperationException();
        }
    }

    public static VM.BufferPool getMappedBufferPool() {
        return new VM.BufferPool(){

            @Override
            public String getName() {
                return "mapped";
            }

            @Override
            public long getCount() {
                return DefaultUnmapper.count;
            }

            @Override
            public long getTotalCapacity() {
                return DefaultUnmapper.totalCapacity;
            }

            @Override
            public long getMemoryUsed() {
                return DefaultUnmapper.totalSize;
            }
        };
    }

    public static VM.BufferPool getSyncMappedBufferPool() {
        return new VM.BufferPool(){

            @Override
            public String getName() {
                return "mapped - 'non-volatile memory'";
            }

            @Override
            public long getCount() {
                return SyncUnmapper.count;
            }

            @Override
            public long getTotalCapacity() {
                return SyncUnmapper.totalCapacity;
            }

            @Override
            public long getMemoryUsed() {
                return SyncUnmapper.totalSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() throws IOException {
        if (this.fileLockTable == null) {
            FileChannelImpl fileChannelImpl = this;
            synchronized (fileChannelImpl) {
                if (this.fileLockTable == null) {
                    int ti = this.threads.add();
                    try {
                        this.ensureOpen();
                        this.fileLockTable = new FileLockTable(this, this.fd);
                    }
                    finally {
                        this.threads.remove(ti);
                    }
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        this.ensureOpen();
        if (shared && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = new FileLockImpl(this, position, size, shared);
        FileLockTable flt = this.fileLockTable();
        flt.add(fli);
        boolean completed = false;
        int ti = -1;
        try {
            int n;
            this.beginBlocking();
            ti = this.threads.add();
            if (!this.isOpen()) {
                FileLock fileLock = null;
                return fileLock;
            }
            while ((n = this.nd.lock(this.fd, true, position, size, shared)) == 2 && this.isOpen()) {
            }
            if (this.isOpen()) {
                if (n == 1) {
                    assert (shared);
                    FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
                    flt.replace(fli, fli2);
                    fli = fli2;
                }
                completed = true;
            }
        }
        finally {
            if (!completed) {
                flt.remove(fli);
            }
            this.threads.remove(ti);
            try {
                this.endBlocking(completed);
            }
            catch (ClosedByInterruptException e) {
                throw new FileLockInterruptionException();
            }
        }
        return fli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.ensureOpen();
        if (shared && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = new FileLockImpl(this, position, size, shared);
        FileLockTable flt = this.fileLockTable();
        flt.add(fli);
        int ti = this.threads.add();
        try {
            int result;
            try {
                this.ensureOpen();
                result = this.nd.lock(this.fd, false, position, size, shared);
            }
            catch (IOException e) {
                flt.remove(fli);
                throw e;
            }
            if (result == -1) {
                flt.remove(fli);
                FileLock e = null;
                return e;
            }
            if (result == 1) {
                assert (shared);
                FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
                flt.replace(fli, fli2);
                FileLockImpl fileLockImpl = fli2;
                return fileLockImpl;
            }
            FileLockImpl fileLockImpl = fli;
            return fileLockImpl;
        }
        finally {
            this.threads.remove(ti);
        }
    }

    void release(FileLockImpl fli) throws IOException {
        int ti = this.threads.add();
        try {
            this.ensureOpen();
            this.nd.release(this.fd, fli.position(), fli.size());
        }
        finally {
            this.threads.remove(ti);
        }
        assert (this.fileLockTable != null);
        this.fileLockTable.remove(fli);
    }

    private native long map0(int var1, long var2, long var4, boolean var6) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native long transferTo0(FileDescriptor var1, long var2, long var4, FileDescriptor var6);

    private static native int maxDirectTransferSize0();

    private static native long initIDs();

    static {
        fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        IOUtil.load();
        allocationGranularity = FileChannelImpl.initIDs();
        MAX_DIRECT_TRANSFER_SIZE = FileChannelImpl.maxDirectTransferSize0();
    }

    private static class Closer
    implements Runnable {
        private final FileDescriptor fd;

        Closer(FileDescriptor fd) {
            this.fd = fd;
        }

        @Override
        public void run() {
            try {
                fdAccess.close(this.fd);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("close", ioe);
            }
        }
    }

    private static abstract class Unmapper
    implements Runnable,
    UnmapperProxy {
        private static final NativeDispatcher nd = new FileDispatcherImpl();
        private volatile long address;
        protected final long size;
        protected final long cap;
        private final FileDescriptor fd;
        private final int pagePosition;

        private Unmapper(long address, long size, long cap, FileDescriptor fd, int pagePosition) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.cap = cap;
            this.fd = fd;
            this.pagePosition = pagePosition;
        }

        @Override
        public long address() {
            return this.address + (long)this.pagePosition;
        }

        @Override
        public FileDescriptor fileDescriptor() {
            return this.fd;
        }

        @Override
        public void run() {
            this.unmap();
        }

        @Override
        public void unmap() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
            if (this.fd.valid()) {
                try {
                    nd.close(this.fd);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.decrementStats();
        }

        protected abstract void incrementStats();

        protected abstract void decrementStats();
    }

    private static class SyncUnmapper
    extends Unmapper {
        static volatile int count;
        static volatile long totalSize;
        static volatile long totalCapacity;

        public SyncUnmapper(long address, long size, long cap, FileDescriptor fd, int pagePosition) {
            super(address, size, cap, fd, pagePosition);
            this.incrementStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void incrementStats() {
            Class<SyncUnmapper> clazz = SyncUnmapper.class;
            synchronized (SyncUnmapper.class) {
                ++count;
                totalSize += this.size;
                totalCapacity += this.cap;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void decrementStats() {
            Class<SyncUnmapper> clazz = SyncUnmapper.class;
            synchronized (SyncUnmapper.class) {
                --count;
                totalSize -= this.size;
                totalCapacity -= this.cap;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public boolean isSync() {
            return true;
        }
    }

    private static class DefaultUnmapper
    extends Unmapper {
        static volatile int count;
        static volatile long totalSize;
        static volatile long totalCapacity;

        public DefaultUnmapper(long address, long size, long cap, FileDescriptor fd, int pagePosition) {
            super(address, size, cap, fd, pagePosition);
            this.incrementStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void incrementStats() {
            Class<DefaultUnmapper> clazz = DefaultUnmapper.class;
            synchronized (DefaultUnmapper.class) {
                ++count;
                totalSize += this.size;
                totalCapacity += this.cap;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void decrementStats() {
            Class<DefaultUnmapper> clazz = DefaultUnmapper.class;
            synchronized (DefaultUnmapper.class) {
                --count;
                totalSize -= this.size;
                totalCapacity -= this.cap;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public boolean isSync() {
            return false;
        }
    }
}

