/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Reflect;
import sun.nio.ch.SelectorProviderImpl;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;

class InheritedChannel {
    private static final int UNKNOWN = -1;
    private static final int SOCK_STREAM = 1;
    private static final int SOCK_DGRAM = 2;
    static final int AF_UNKNOWN = -1;
    static final int AF_INET = 1;
    static final int AF_INET6 = 2;
    static final int AF_UNIX = 3;
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static int devnull = -1;
    private static boolean haveChannel = false;
    private static Channel channel = null;

    InheritedChannel() {
    }

    private static void detachIOStreams() {
        try {
            InheritedChannel.dup2(devnull, 0);
            InheritedChannel.dup2(devnull, 1);
            InheritedChannel.dup2(devnull, 2);
        }
        catch (IOException ioe) {
            throw new InternalError(ioe);
        }
    }

    static ProtocolFamily protocolFamily(SocketAddress sa) {
        if (sa instanceof UnixDomainSocketAddress) {
            return StandardProtocolFamily.UNIX;
        }
        InetSocketAddress isa = (InetSocketAddress)sa;
        return isa.getAddress() instanceof Inet6Address ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
    }

    static ProtocolFamily protocolFamily(int family) {
        return switch (family) {
            case 1 -> StandardProtocolFamily.INET;
            case 2 -> StandardProtocolFamily.INET6;
            case 3 -> StandardProtocolFamily.UNIX;
            default -> throw new IllegalArgumentException();
        };
    }

    private static void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("inheritedChannel"));
        }
    }

    private static Channel createChannel() throws IOException {
        AbstractSelectableChannel c;
        int fdVal = InheritedChannel.dup(0);
        int st = InheritedChannel.soType0(fdVal);
        if (st != 1 && st != 2) {
            InheritedChannel.close0(fdVal);
            return null;
        }
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Constructor<?> ctr = Reflect.lookupConstructor("java.io.FileDescriptor", paramTypes);
        Object[] args = new Object[]{fdVal};
        FileDescriptor fd = (FileDescriptor)Reflect.invoke(ctr, args);
        SelectorProvider provider = SelectorProvider.provider();
        assert (provider instanceof SelectorProviderImpl);
        if (st == 1) {
            int family = InheritedChannel.addressFamily(fdVal);
            if (family == -1) {
                return null;
            }
            ProtocolFamily pfamily = InheritedChannel.protocolFamily(family);
            if (family == 3) {
                if (InheritedChannel.isConnected(fdVal)) {
                    UnixDomainSocketAddress sa = UnixDomainSocketAddress.of(InheritedChannel.unixPeerAddress(fdVal));
                    return new InheritedSocketChannelImpl(provider, fd, sa);
                }
                return new InheritedServerSocketChannelImpl(provider, pfamily, fd);
            }
            InetAddress ia = InheritedChannel.inetPeerAddress0(fdVal);
            if (ia == null) {
                c = new InheritedServerSocketChannelImpl(provider, pfamily, fd);
            } else {
                int port = InheritedChannel.peerPort0(fdVal);
                assert (port > 0);
                InetSocketAddress isa = new InetSocketAddress(ia, port);
                c = new InheritedSocketChannelImpl(provider, fd, isa);
            }
        } else {
            c = new InheritedDatagramChannelImpl(provider, fd);
        }
        return c;
    }

    public static synchronized Channel getChannel() throws IOException {
        if (devnull < 0) {
            devnull = InheritedChannel.open0("/dev/null", 2);
        }
        if (!haveChannel) {
            channel = InheritedChannel.createChannel();
            haveChannel = true;
        }
        if (channel != null) {
            InheritedChannel.checkAccess();
        }
        return channel;
    }

    private static String unixPeerAddress(int fd) throws IOException {
        byte[] bytes = InheritedChannel.unixPeerAddress0(fd);
        return new String(bytes);
    }

    private static native void initIDs();

    private static native int dup(int var0) throws IOException;

    private static native void dup2(int var0, int var1) throws IOException;

    private static native int open0(String var0, int var1) throws IOException;

    private static native void close0(int var0) throws IOException;

    private static native int soType0(int var0);

    private static native int addressFamily(int var0);

    private static native InetAddress inetPeerAddress0(int var0);

    private static native byte[] unixPeerAddress0(int var0);

    private static native int peerPort0(int var0);

    private static native boolean isConnected(int var0);

    static {
        IOUtil.load();
        InheritedChannel.initIDs();
    }

    public static class InheritedSocketChannelImpl
    extends SocketChannelImpl {
        InheritedSocketChannelImpl(SelectorProvider sp, FileDescriptor fd, SocketAddress remote) throws IOException {
            super(sp, InheritedChannel.protocolFamily(remote), fd, remote);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedServerSocketChannelImpl
    extends ServerSocketChannelImpl {
        InheritedServerSocketChannelImpl(SelectorProvider sp, ProtocolFamily family, FileDescriptor fd) throws IOException {
            super(sp, family, fd, true);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedDatagramChannelImpl
    extends DatagramChannelImpl {
        InheritedDatagramChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
            super(sp, fd);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }
}

