/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdk.internal.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.ThreadPool;

class Iocp
extends AsynchronousChannelGroupImpl {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long INVALID_HANDLE_VALUE = -1L;
    private final ReadWriteLock keyToChannelLock = new ReentrantReadWriteLock();
    private final Map<Integer, OverlappedChannel> keyToChannel = new HashMap<Integer, OverlappedChannel>();
    private int nextCompletionKey = 1;
    private final long port;
    private boolean closed;
    private final Set<Long> staleIoSet = new HashSet<Long>();

    Iocp(AsynchronousChannelProvider provider, ThreadPool pool) throws IOException {
        super(provider, pool);
        this.port = Iocp.createIoCompletionPort(-1L, 0L, 0, this.fixedThreadCount());
    }

    Iocp start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implClose() {
        Object object2 = this;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Iocp.close0(this.port);
        object2 = this.staleIoSet;
        synchronized (object2) {
            for (Long ov : this.staleIoSet) {
                unsafe.freeMemory(ov);
            }
            this.staleIoSet.clear();
        }
    }

    @Override
    boolean isEmpty() {
        this.keyToChannelLock.writeLock().lock();
        try {
            boolean bl = this.keyToChannel.isEmpty();
            return bl;
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
    }

    @Override
    final Object attachForeignChannel(final Channel channel, FileDescriptor fdObj) throws IOException {
        int key = this.associate(new OverlappedChannel(){

            @Override
            public <V, A> PendingFuture<V, A> getByOverlapped(long overlapped) {
                return null;
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        }, 0L);
        return key;
    }

    @Override
    final void detachForeignChannel(Object key) {
        this.disassociate((Integer)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeAllChannels() {
        int count;
        int MAX_BATCH_SIZE = 32;
        OverlappedChannel[] channels = new OverlappedChannel[32];
        do {
            this.keyToChannelLock.writeLock().lock();
            count = 0;
            try {
                for (Integer key : this.keyToChannel.keySet()) {
                    channels[count++] = this.keyToChannel.get(key);
                    if (count < 32) continue;
                    break;
                }
            }
            finally {
                this.keyToChannelLock.writeLock().unlock();
            }
            for (int i = 0; i < count; ++i) {
                try {
                    channels[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } while (count > 0);
    }

    private void wakeup() {
        try {
            Iocp.postQueuedCompletionStatus(this.port, 0);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable task) {
        Iocp iocp = this;
        synchronized (iocp) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(task);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int nThreads = this.threadCount();
        while (nThreads-- > 0) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int associate(OverlappedChannel ch, long handle) throws IOException {
        int key;
        this.keyToChannelLock.writeLock().lock();
        try {
            if (this.isShutdown()) {
                throw new ShutdownChannelGroupException();
            }
            do {
                ++this.nextCompletionKey;
            } while (key == 0 || this.keyToChannel.containsKey(key));
            if (handle != 0L) {
                Iocp.createIoCompletionPort(handle, this.port, key, 0);
            }
            this.keyToChannel.put(key, ch);
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
        return key;
    }

    void disassociate(int key) {
        boolean checkForShutdown = false;
        this.keyToChannelLock.writeLock().lock();
        try {
            this.keyToChannel.remove(key);
            if (this.keyToChannel.isEmpty()) {
                checkForShutdown = true;
            }
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
        if (checkForShutdown && this.isShutdown()) {
            try {
                this.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeStale(Long overlapped) {
        Set<Long> set = this.staleIoSet;
        synchronized (set) {
            this.staleIoSet.add(overlapped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfStale(long ov) {
        Set<Long> set = this.staleIoSet;
        synchronized (set) {
            boolean removed = this.staleIoSet.remove(ov);
            if (removed) {
                unsafe.freeMemory(ov);
            }
        }
    }

    private static IOException translateErrorToIOException(int error) {
        String msg = Iocp.getErrorMessage(error);
        if (msg == null) {
            msg = "Unknown error: 0x0" + Integer.toHexString(error);
        }
        return new IOException(msg);
    }

    private static native void initIDs();

    private static native long createIoCompletionPort(long var0, long var2, int var4, int var5) throws IOException;

    private static native void close0(long var0);

    private static native void getQueuedCompletionStatus(long var0, CompletionStatus var2) throws IOException;

    private static native void postQueuedCompletionStatus(long var0, int var2) throws IOException;

    private static native String getErrorMessage(int var0);

    static {
        IOUtil.load();
        Iocp.initIDs();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Invoker.GroupAndInvokeCount myGroupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            boolean canInvokeDirect = myGroupAndInvokeCount != null;
            CompletionStatus ioResult = new CompletionStatus();
            boolean replaceMe = false;
            try {
                while (true) {
                    if (myGroupAndInvokeCount != null) {
                        myGroupAndInvokeCount.resetInvokeCount();
                    }
                    replaceMe = false;
                    try {
                        Iocp.getQueuedCompletionStatus(Iocp.this.port, ioResult);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        int remaining = Iocp.this.threadExit(this, replaceMe);
                        if (remaining == 0 && Iocp.this.isShutdown()) {
                            Iocp.this.implClose();
                        }
                        return;
                    }
                    if (ioResult.completionKey() == 0 && ioResult.overlapped() == 0L) {
                        Runnable task = Iocp.this.pollTask();
                        if (task == null) {
                            return;
                        }
                        replaceMe = true;
                        task.run();
                        continue;
                    }
                    OverlappedChannel ch = null;
                    Iocp.this.keyToChannelLock.readLock().lock();
                    try {
                        ch = Iocp.this.keyToChannel.get(ioResult.completionKey());
                        if (ch == null) {
                            Iocp.this.checkIfStale(ioResult.overlapped());
                            continue;
                        }
                    }
                    finally {
                        Iocp.this.keyToChannelLock.readLock().unlock();
                        continue;
                    }
                    PendingFuture result = ch.getByOverlapped(ioResult.overlapped());
                    if (result == null) {
                        Iocp.this.checkIfStale(ioResult.overlapped());
                        continue;
                    }
                    PendingFuture pendingFuture = result;
                    synchronized (pendingFuture) {
                        if (result.isDone()) {
                            continue;
                        }
                    }
                    int error = ioResult.error();
                    ResultHandler rh = (ResultHandler)result.getContext();
                    replaceMe = true;
                    if (error == 0) {
                        rh.completed(ioResult.bytesTransferred(), canInvokeDirect);
                        continue;
                    }
                    rh.failed(error, Iocp.translateErrorToIOException(error));
                }
            }
            finally {
                int remaining = Iocp.this.threadExit(this, replaceMe);
                if (remaining == 0 && Iocp.this.isShutdown()) {
                    Iocp.this.implClose();
                }
            }
        }
    }

    static interface OverlappedChannel
    extends Closeable {
        public <V, A> PendingFuture<V, A> getByOverlapped(long var1);
    }

    private static class CompletionStatus {
        private int error;
        private int bytesTransferred;
        private int completionKey;
        private long overlapped;

        private CompletionStatus() {
        }

        int error() {
            return this.error;
        }

        int bytesTransferred() {
            return this.bytesTransferred;
        }

        int completionKey() {
            return this.completionKey;
        }

        long overlapped() {
            return this.overlapped;
        }
    }

    static interface ResultHandler {
        public void completed(int var1, boolean var2);

        public void failed(int var1, IOException var2);
    }
}

