/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.KQueue;
import sun.nio.ch.Net;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class KQueueSelectorImpl
extends SelectorImpl {
    private static final int MAX_KEVENTS = 256;
    private final int kqfd;
    private final long pollArrayAddress;
    private final int fd0;
    private final int fd1;
    private final Map<Integer, SelectionKeyImpl> fdToKey = new HashMap<Integer, SelectionKeyImpl>();
    private final Object updateLock = new Object();
    private final Deque<SelectionKeyImpl> updateKeys = new ArrayDeque<SelectionKeyImpl>();
    private final Object interruptLock = new Object();
    private boolean interruptTriggered;
    private int pollCount;

    KQueueSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.kqfd = KQueue.create();
        this.pollArrayAddress = KQueue.allocatePollArray(256);
        try {
            long fds = IOUtil.makePipe(false);
            this.fd0 = (int)(fds >>> 32);
            this.fd1 = (int)fds;
        }
        catch (IOException ioe) {
            KQueue.freePollArray(this.pollArrayAddress);
            FileDispatcherImpl.closeIntFD(this.kqfd);
            throw ioe;
        }
        KQueue.register(this.kqfd, this.fd0, -1, 1);
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(Consumer<SelectionKey> action, long timeout) throws IOException {
        int numEntries;
        assert (Thread.holdsLock(this));
        long to = Math.min(timeout, Integer.MAX_VALUE);
        boolean blocking = to != 0L;
        boolean timedPoll = to > 0L;
        this.processUpdateQueue();
        this.processDeregisterQueue();
        try {
            this.begin(blocking);
            do {
                long adjust;
                long startTime = timedPoll ? System.nanoTime() : 0L;
                numEntries = KQueue.poll(this.kqfd, this.pollArrayAddress, 256, to);
                if (numEntries != -3 || !timedPoll || (to -= TimeUnit.MILLISECONDS.convert(adjust = System.nanoTime() - startTime, TimeUnit.NANOSECONDS)) > 0L) continue;
                numEntries = 0;
            } while (numEntries == -3);
            assert (IOStatus.check(numEntries));
        }
        finally {
            this.end(blocking);
        }
        this.processDeregisterQueue();
        return this.processEvents(numEntries, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateQueue() {
        assert (Thread.holdsLock(this));
        Object object2 = this.updateLock;
        synchronized (object2) {
            SelectionKeyImpl ski;
            while ((ski = this.updateKeys.pollFirst()) != null) {
                if (!ski.isValid()) continue;
                int fd = ski.getFDVal();
                SelectionKeyImpl previous = this.fdToKey.putIfAbsent(fd, ski);
                assert (previous == null || previous == ski);
                int newEvents = ski.translateInterestOps();
                int registeredEvents = ski.registeredEvents();
                if (ski.getAndClearReset() && registeredEvents != 0) {
                    KQueue.register(this.kqfd, fd, -1, 2);
                    registeredEvents = 0;
                }
                if (newEvents == registeredEvents) continue;
                if ((registeredEvents & Net.POLLIN) != 0) {
                    if ((newEvents & Net.POLLIN) == 0) {
                        KQueue.register(this.kqfd, fd, -1, 2);
                    }
                } else if ((newEvents & Net.POLLIN) != 0) {
                    KQueue.register(this.kqfd, fd, -1, 1);
                }
                if ((registeredEvents & Net.POLLOUT) != 0) {
                    if ((newEvents & Net.POLLOUT) == 0) {
                        KQueue.register(this.kqfd, fd, -2, 2);
                    }
                } else if ((newEvents & Net.POLLOUT) != 0) {
                    KQueue.register(this.kqfd, fd, -2, 1);
                }
                ski.registeredEvents(newEvents);
            }
        }
    }

    private int processEvents(int numEntries, Consumer<SelectionKey> action) throws IOException {
        assert (Thread.holdsLock(this));
        int numKeysUpdated = 0;
        boolean interrupted = false;
        ++this.pollCount;
        for (int i = 0; i < numEntries; ++i) {
            long kevent = KQueue.getEvent(this.pollArrayAddress, i);
            int fd = KQueue.getDescriptor(kevent);
            if (fd == this.fd0) {
                interrupted = true;
                continue;
            }
            SelectionKeyImpl ski = this.fdToKey.get(fd);
            if (ski == null) continue;
            int rOps = 0;
            short filter = KQueue.getFilter(kevent);
            if (filter == -1) {
                rOps |= Net.POLLIN;
            } else if (filter == -2) {
                rOps |= Net.POLLOUT;
            }
            int updated = this.processReadyEvents(rOps, ski, action);
            if (updated <= 0 || ski.lastPolled == this.pollCount) continue;
            ++numKeysUpdated;
            ski.lastPolled = this.pollCount;
        }
        if (interrupted) {
            this.clearInterrupt();
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        assert (!this.isOpen());
        assert (Thread.holdsLock(this));
        Object object2 = this.interruptLock;
        synchronized (object2) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.kqfd);
        KQueue.freePollArray(this.pollArrayAddress);
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        assert (!ski.isValid());
        assert (Thread.holdsLock(this));
        int fd = ski.getFDVal();
        int registeredEvents = ski.registeredEvents();
        if (this.fdToKey.remove(fd) != null) {
            if (registeredEvents != 0) {
                if ((registeredEvents & Net.POLLIN) != 0) {
                    KQueue.register(this.kqfd, fd, -1, 2);
                }
                if ((registeredEvents & Net.POLLOUT) != 0) {
                    KQueue.register(this.kqfd, fd, -2, 2);
                }
                ski.registeredEvents(0);
            }
        } else assert (registeredEvents == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventOps(SelectionKeyImpl ski) {
        this.ensureOpen();
        Object object2 = this.updateLock;
        synchronized (object2) {
            this.updateKeys.addLast(ski);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object2 = this.interruptLock;
        synchronized (object2) {
            if (!this.interruptTriggered) {
                try {
                    IOUtil.write1(this.fd1, (byte)0);
                }
                catch (IOException ioe) {
                    throw new InternalError(ioe);
                }
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInterrupt() throws IOException {
        Object object2 = this.interruptLock;
        synchronized (object2) {
            IOUtil.drain(this.fd0);
            this.interruptTriggered = false;
        }
    }
}

