/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.channels.MembershipKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.nio.ch.MembershipKeyImpl;

class MembershipRegistry {
    private Map<InetAddress, List<MembershipKeyImpl>> groups;

    MembershipRegistry() {
    }

    MembershipKey checkMembership(InetAddress group, NetworkInterface interf, InetAddress source) {
        List<MembershipKeyImpl> keys;
        if (this.groups != null && (keys = this.groups.get(group)) != null) {
            for (MembershipKeyImpl key : keys) {
                if (!key.networkInterface().equals(interf)) continue;
                if (source == null) {
                    if (key.sourceAddress() == null) {
                        return key;
                    }
                    throw new IllegalStateException("Already a member to receive all packets");
                }
                if (key.sourceAddress() == null) {
                    throw new IllegalStateException("Already have source-specific membership");
                }
                if (!source.equals(key.sourceAddress())) continue;
                return key;
            }
        }
        return null;
    }

    void add(MembershipKeyImpl key) {
        List<MembershipKeyImpl> keys;
        InetAddress group = key.group();
        if (this.groups == null) {
            this.groups = new HashMap<InetAddress, List<MembershipKeyImpl>>();
            keys = null;
        } else {
            keys = this.groups.get(group);
        }
        if (keys == null) {
            keys = new LinkedList<MembershipKeyImpl>();
            this.groups.put(group, keys);
        }
        keys.add(key);
    }

    void remove(MembershipKeyImpl key) {
        InetAddress group = key.group();
        List<MembershipKeyImpl> keys = this.groups.get(group);
        if (keys != null) {
            Iterator<MembershipKeyImpl> i = keys.iterator();
            while (i.hasNext()) {
                if (i.next() != key) continue;
                i.remove();
                break;
            }
            if (keys.isEmpty()) {
                this.groups.remove(group);
            }
        }
    }

    <X extends Throwable> void forEach(ThrowingConsumer<MembershipKeyImpl, X> action) throws X {
        if (this.groups != null) {
            for (List<MembershipKeyImpl> keys : this.groups.values()) {
                for (MembershipKeyImpl key : keys) {
                    action.accept(key);
                }
            }
        }
    }

    void invalidateAll() {
        this.forEach(MembershipKeyImpl::invalidate);
    }

    @FunctionalInterface
    static interface ThrowingConsumer<T, X extends Throwable> {
        public void accept(T var1) throws X;
    }
}

