/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.channels.UnsupportedAddressTypeException;
import jdk.internal.access.JavaNetInetAddressAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.ArraysSupport;
import sun.nio.ch.IOUtil;

class NativeSocketAddress {
    private static final JavaNetInetAddressAccess JNINA = SharedSecrets.getJavaNetInetAddressAccess();
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int AF_INET = NativeSocketAddress.AFINET();
    private static final int AF_INET6 = NativeSocketAddress.AFINET6();
    private static final int SIZEOF_SOCKADDR4 = NativeSocketAddress.sizeofSockAddr4();
    private static final int SIZEOF_SOCKADDR6 = NativeSocketAddress.sizeofSockAddr6();
    private static final int SIZEOF_SOCKETADDRESS = Math.max(SIZEOF_SOCKADDR4, SIZEOF_SOCKADDR6);
    private static final int SIZEOF_FAMILY = NativeSocketAddress.sizeofFamily();
    private static final int OFFSET_FAMILY = NativeSocketAddress.offsetFamily();
    private static final int OFFSET_SIN4_PORT = NativeSocketAddress.offsetSin4Port();
    private static final int OFFSET_SIN4_ADDR = NativeSocketAddress.offsetSin4Addr();
    private static final int OFFSET_SIN6_PORT = NativeSocketAddress.offsetSin6Port();
    private static final int OFFSET_SIN6_ADDR = NativeSocketAddress.offsetSin6Addr();
    private static final int OFFSET_SIN6_SCOPE_ID = NativeSocketAddress.offsetSin6ScopeId();
    private static final int OFFSET_SIN6_FLOWINFO = NativeSocketAddress.offsetSin6FlowInfo();
    private final long address;

    long address() {
        return this.address;
    }

    NativeSocketAddress() {
        long base = UNSAFE.allocateMemory(SIZEOF_SOCKETADDRESS);
        UNSAFE.setMemory(base, SIZEOF_SOCKETADDRESS, (byte)0);
        this.address = base;
    }

    static NativeSocketAddress[] allocate(int count) {
        NativeSocketAddress[] array = new NativeSocketAddress[count];
        for (int i = 0; i < count; ++i) {
            try {
                array[i] = new NativeSocketAddress();
                continue;
            }
            catch (OutOfMemoryError e) {
                NativeSocketAddress.freeAll(array);
                throw e;
            }
        }
        return array;
    }

    static void freeAll(NativeSocketAddress[] array) {
        for (int i = 0; i < array.length; ++i) {
            NativeSocketAddress sa = array[i];
            if (sa == null) continue;
            UNSAFE.freeMemory(sa.address);
        }
    }

    int encode(ProtocolFamily protocolFamily, InetSocketAddress isa) {
        if (protocolFamily == StandardProtocolFamily.INET) {
            InetAddress ia = isa.getAddress();
            if (!(ia instanceof Inet4Address)) {
                throw new UnsupportedAddressTypeException();
            }
            this.putFamily(AF_INET);
            this.putAddress(AF_INET, ia);
            this.putPort(AF_INET, isa.getPort());
            return SIZEOF_SOCKADDR4;
        }
        this.putFamily(AF_INET6);
        this.putAddress(AF_INET6, isa.getAddress());
        this.putPort(AF_INET6, isa.getPort());
        UNSAFE.putInt(this.address + (long)OFFSET_SIN6_FLOWINFO, 0);
        return SIZEOF_SOCKADDR6;
    }

    InetSocketAddress decode() throws SocketException {
        int family = this.family();
        if (family != AF_INET && family != AF_INET6) {
            throw new SocketException("Socket family not recognized");
        }
        return new InetSocketAddress(this.address(family), this.port(family));
    }

    private int mismatch(NativeSocketAddress other) {
        int i = ArraysSupport.vectorizedMismatch(null, this.address, null, other.address, SIZEOF_SOCKETADDRESS, ArraysSupport.LOG2_ARRAY_BYTE_INDEX_SCALE);
        if (i >= 0) {
            return i;
        }
        for (i = SIZEOF_SOCKETADDRESS - (i ^ 0xFFFFFFFF); i < SIZEOF_SOCKETADDRESS; ++i) {
            if (UNSAFE.getByte(this.address + (long)i) == UNSAFE.getByte(other.address + (long)i)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other instanceof NativeSocketAddress) {
            return this.mismatch((NativeSocketAddress)other) < 0;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int offset = 0; offset < SIZEOF_SOCKETADDRESS; ++offset) {
            h = 31 * h + UNSAFE.getByte(this.address + (long)offset);
        }
        return h;
    }

    public String toString() {
        int family = this.family();
        if (family == AF_INET || family == AF_INET6) {
            return (family == AF_INET ? "AF_INET" : "AF_INET6") + ", address=" + this.address(family) + ", port=" + this.port(family);
        }
        return "<unknown>";
    }

    private int family() {
        if (SIZEOF_FAMILY == 1) {
            return UNSAFE.getByte(this.address + (long)OFFSET_FAMILY);
        }
        if (SIZEOF_FAMILY == 2) {
            return UNSAFE.getShort(this.address + (long)OFFSET_FAMILY);
        }
        throw new InternalError();
    }

    private void putFamily(int family) {
        if (SIZEOF_FAMILY == 1) {
            UNSAFE.putByte(this.address + (long)OFFSET_FAMILY, (byte)family);
        } else if (SIZEOF_FAMILY == 2) {
            UNSAFE.putShort(this.address + (long)OFFSET_FAMILY, (short)family);
        } else {
            throw new InternalError();
        }
    }

    private int port(int family) {
        byte b2;
        byte b1;
        if (family == AF_INET) {
            b1 = UNSAFE.getByte(this.address + (long)OFFSET_SIN4_PORT);
            b2 = UNSAFE.getByte(this.address + (long)OFFSET_SIN4_PORT + 1L);
        } else {
            b1 = UNSAFE.getByte(this.address + (long)OFFSET_SIN6_PORT);
            b2 = UNSAFE.getByte(this.address + (long)OFFSET_SIN6_PORT + 1L);
        }
        return (Byte.toUnsignedInt(b1) << 8) + Byte.toUnsignedInt(b2);
    }

    private void putPort(int family, int port) {
        byte b1 = (byte)(port >> 8 & 0xFF);
        byte b2 = (byte)(port >> 0 & 0xFF);
        if (family == AF_INET) {
            UNSAFE.putByte(this.address + (long)OFFSET_SIN4_PORT, b1);
            UNSAFE.putByte(this.address + (long)OFFSET_SIN4_PORT + 1L, b2);
        } else {
            UNSAFE.putByte(this.address + (long)OFFSET_SIN6_PORT, b1);
            UNSAFE.putByte(this.address + (long)OFFSET_SIN6_PORT + 1L, b2);
        }
    }

    private InetAddress address(int family) {
        int scope_id;
        int offset;
        int len;
        if (family == AF_INET) {
            len = 4;
            offset = OFFSET_SIN4_ADDR;
            scope_id = 0;
        } else {
            len = 16;
            offset = OFFSET_SIN6_ADDR;
            scope_id = UNSAFE.getInt(this.address + (long)OFFSET_SIN6_SCOPE_ID);
        }
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(null, this.address + (long)offset, bytes, ARRAY_BASE_OFFSET, len);
        try {
            if (scope_id == 0) {
                return InetAddress.getByAddress(bytes);
            }
            return Inet6Address.getByAddress(null, bytes, scope_id);
        }
        catch (UnknownHostException e) {
            throw new InternalError(e);
        }
    }

    private void putAddress(int family, InetAddress ia) {
        if (family == AF_INET) {
            NativeSocketAddress.putAddress(this.address + (long)OFFSET_SIN4_ADDR, (Inet4Address)ia);
        } else {
            int scope_id;
            if (ia instanceof Inet4Address) {
                UNSAFE.setMemory(this.address + (long)OFFSET_SIN6_ADDR, 10L, (byte)0);
                UNSAFE.putByte(this.address + (long)OFFSET_SIN6_ADDR + 10L, (byte)-1);
                UNSAFE.putByte(this.address + (long)OFFSET_SIN6_ADDR + 11L, (byte)-1);
                NativeSocketAddress.putAddress(this.address + (long)OFFSET_SIN6_ADDR + 12L, (Inet4Address)ia);
                scope_id = 0;
            } else {
                Inet6Address inet6Address = (Inet6Address)ia;
                NativeSocketAddress.putAddress(this.address + (long)OFFSET_SIN6_ADDR, inet6Address);
                scope_id = inet6Address.getScopeId();
            }
            UNSAFE.putInt(this.address + (long)OFFSET_SIN6_SCOPE_ID, scope_id);
        }
    }

    private static void putAddress(long address, Inet4Address ia) {
        int ipAddress = JNINA.addressValue(ia);
        UNSAFE.putByte(address + 0L, (byte)(ipAddress >>> 24 & 0xFF));
        UNSAFE.putByte(address + 1L, (byte)(ipAddress >>> 16 & 0xFF));
        UNSAFE.putByte(address + 2L, (byte)(ipAddress >>> 8 & 0xFF));
        UNSAFE.putByte(address + 3L, (byte)(ipAddress & 0xFF));
    }

    private static void putAddress(long address, Inet6Address ia) {
        byte[] bytes = JNINA.addressBytes(ia);
        UNSAFE.copyMemory(bytes, ARRAY_BASE_OFFSET, null, address, 16L);
    }

    private static native int AFINET();

    private static native int AFINET6();

    private static native int sizeofSockAddr4();

    private static native int sizeofSockAddr6();

    private static native int sizeofFamily();

    private static native int offsetFamily();

    private static native int offsetSin4Port();

    private static native int offsetSin4Addr();

    private static native int offsetSin6Port();

    private static native int offsetSin6Addr();

    private static native int offsetSin6ScopeId();

    private static native int offsetSin6FlowInfo();

    static {
        IOUtil.load();
    }
}

