/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.AsynchronousCloseException;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.misc.Unsafe;
import sun.nio.ch.Groupable;
import sun.nio.ch.Iocp;
import sun.nio.ch.PendingFuture;

class PendingIoCache {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int addressSize = unsafe.addressSize();
    private static final int SIZEOF_OVERLAPPED = PendingIoCache.dependsArch(20, 32);
    private boolean closed;
    private boolean closePending;
    private final Map<Long, PendingFuture> pendingIoMap = new HashMap<Long, PendingFuture>();
    private long[] overlappedCache = new long[4];
    private int overlappedCacheCount = 0;

    private static int dependsArch(int value32, int value64) {
        return addressSize == 4 ? value32 : value64;
    }

    PendingIoCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long add(PendingFuture<?, ?> result) {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            if (this.closed) {
                throw new AssertionError((Object)"Should not get here");
            }
            long ov = this.overlappedCacheCount > 0 ? this.overlappedCache[--this.overlappedCacheCount] : unsafe.allocateMemory(SIZEOF_OVERLAPPED);
            this.pendingIoMap.put(ov, result);
            return ov;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V, A> PendingFuture<V, A> remove(long overlapped) {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            PendingFuture res = this.pendingIoMap.remove(overlapped);
            if (res != null) {
                if (this.overlappedCacheCount < this.overlappedCache.length) {
                    this.overlappedCache[this.overlappedCacheCount++] = overlapped;
                } else {
                    unsafe.freeMemory(overlapped);
                }
                if (this.closePending) {
                    this.notifyAll();
                }
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            if (this.closed) {
                return;
            }
            if (!this.pendingIoMap.isEmpty()) {
                this.clearPendingIoMap();
            }
            while (this.overlappedCacheCount > 0) {
                unsafe.freeMemory(this.overlappedCache[--this.overlappedCacheCount]);
            }
            this.closed = true;
        }
    }

    private void clearPendingIoMap() {
        assert (Thread.holdsLock(this));
        this.closePending = true;
        try {
            this.wait(50L);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.closePending = false;
        if (this.pendingIoMap.isEmpty()) {
            return;
        }
        for (Long ov : this.pendingIoMap.keySet()) {
            PendingFuture result = this.pendingIoMap.get(ov);
            Iocp iocp = (Iocp)((Groupable)((Object)result.channel())).group();
            iocp.makeStale(ov);
            final Iocp.ResultHandler rh = (Iocp.ResultHandler)result.getContext();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    rh.failed(-1, new AsynchronousCloseException());
                }
            };
            iocp.executeOnPooledThread(task);
        }
        this.pendingIoMap.clear();
    }
}

