/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.Net;
import sun.nio.ch.SelectionKeyImpl;

class PollArrayWrapper {
    private AllocatedNativeObject pollArray;
    long pollArrayAddress;
    private static final short FD_OFFSET = 0;
    private static final short EVENT_OFFSET = 4;
    static short SIZE_POLLFD = (short)8;
    private int size;

    PollArrayWrapper(int newSize) {
        int allocationSize = newSize * SIZE_POLLFD;
        this.pollArray = new AllocatedNativeObject(allocationSize, true);
        this.pollArrayAddress = this.pollArray.address();
        this.size = newSize;
    }

    void putEntry(int index, SelectionKeyImpl ski) {
        this.putDescriptor(index, ski.getFDVal());
        this.putEventOps(index, 0);
    }

    void replaceEntry(PollArrayWrapper source, int sindex, PollArrayWrapper target, int tindex) {
        target.putDescriptor(tindex, source.getDescriptor(sindex));
        target.putEventOps(tindex, source.getEventOps(sindex));
    }

    void grow(int newSize) {
        PollArrayWrapper temp = new PollArrayWrapper(newSize);
        for (int i = 0; i < this.size; ++i) {
            this.replaceEntry(this, i, temp, i);
        }
        this.pollArray.free();
        this.pollArray = temp.pollArray;
        this.size = temp.size;
        this.pollArrayAddress = this.pollArray.address();
    }

    void free() {
        this.pollArray.free();
    }

    void putDescriptor(int i, int fd) {
        this.pollArray.putInt(SIZE_POLLFD * i + 0, fd);
    }

    void putEventOps(int i, int event) {
        this.pollArray.putShort(SIZE_POLLFD * i + 4, (short)event);
    }

    int getEventOps(int i) {
        return this.pollArray.getShort(SIZE_POLLFD * i + 4);
    }

    int getDescriptor(int i) {
        return this.pollArray.getInt(SIZE_POLLFD * i + 0);
    }

    void addWakeupSocket(int fdVal, int index) {
        this.putDescriptor(index, fdVal);
        this.putEventOps(index, Net.POLLIN);
    }
}

