/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.ch.DummySocketImpl;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;

class ServerSocketAdaptor
extends ServerSocket {
    private final ServerSocketChannelImpl ssc;
    private volatile int timeout;

    static ServerSocket create(ServerSocketChannelImpl ssc) {
        PrivilegedExceptionAction<ServerSocket> pa = () -> new ServerSocketAdaptor(ssc);
        try {
            return AccessController.doPrivileged(pa);
        }
        catch (PrivilegedActionException pae) {
            throw new InternalError("Should not reach here", pae);
        }
    }

    private ServerSocketAdaptor(ServerSocketChannelImpl ssc) {
        super(DummySocketImpl.create());
        this.ssc = ssc;
    }

    @Override
    public void bind(SocketAddress local) throws IOException {
        this.bind(local, 50);
    }

    @Override
    public void bind(SocketAddress local, int backlog) throws IOException {
        if (local == null) {
            local = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(local, backlog);
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        SocketAddress local = this.ssc.localAddress();
        if (local == null) {
            return null;
        }
        return Net.getRevealedLocalAddress(local).getAddress();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress local = (InetSocketAddress)this.ssc.localAddress();
        if (local == null) {
            return -1;
        }
        return local.getPort();
    }

    @Override
    public Socket accept() throws IOException {
        SocketChannel sc = null;
        try {
            int timeout = this.timeout;
            if (timeout > 0) {
                long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
                sc = this.ssc.blockingAccept(nanos);
            } else {
                sc = this.ssc.accept();
                if (sc == null) {
                    throw new IllegalBlockingModeException();
                }
            }
        }
        catch (Exception e) {
            Net.translateException(e);
        }
        return sc.socket();
    }

    @Override
    public void close() throws IOException {
        this.ssc.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    @Override
    public boolean isBound() {
        return this.ssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (!this.ssc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.timeout = timeout;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (!this.ssc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)on);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return -1;
        }
    }

    @Override
    public <T> ServerSocket setOption(SocketOption<T> name, T value) throws IOException {
        this.ssc.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.ssc.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.ssc.supportedOptions();
    }
}

