/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.util.HashMap;
import java.util.Map;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.posix.NetinetIn;
import org.qbicc.runtime.posix.NetinetTcp;
import org.qbicc.runtime.posix.SysSocket;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.OptionKey;

public class SocketOptionRegistry {
    private SocketOptionRegistry() {
    }

    public static OptionKey findOption(SocketOption<?> name, ProtocolFamily family) {
        RegistryKey key = new RegistryKey(name, family);
        return LazyInitialization.options.get(key);
    }

    private static class RegistryKey {
        private final SocketOption<?> name;
        private final ProtocolFamily family;

        RegistryKey(SocketOption<?> name, ProtocolFamily family) {
            this.name = name;
            this.family = family;
        }

        public int hashCode() {
            return this.name.hashCode() + this.family.hashCode();
        }

        public boolean equals(Object ob) {
            if (ob == null) {
                return false;
            }
            if (!(ob instanceof RegistryKey)) {
                return false;
            }
            RegistryKey other = (RegistryKey)ob;
            if (this.name != other.name) {
                return false;
            }
            return this.family == other.family;
        }
    }

    private static class LazyInitialization {
        static final Map<RegistryKey, OptionKey> options = LazyInitialization.options();

        private LazyInitialization() {
        }

        private static Map<RegistryKey, OptionKey> options() {
            HashMap<RegistryKey, OptionKey> map = new HashMap<RegistryKey, OptionKey>();
            map.put(new RegistryKey(StandardSocketOptions.SO_BROADCAST, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_BROADCAST.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_KEEPALIVE, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_KEEPALIVE.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_LINGER, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_LINGER.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_SNDBUF, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_SNDBUF.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_RCVBUF, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_RCVBUF.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_REUSEADDR, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_REUSEADDR.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.SO_REUSEPORT, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), CNative.defined((CNative.object)SysSocket.SO_REUSEPORT) ? SysSocket.SO_REUSEPORT.intValue() : 0));
            map.put(new RegistryKey(StandardSocketOptions.TCP_NODELAY, Net.UNSPEC), new OptionKey(6, NetinetTcp.TCP_NODELAY.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.IP_TOS, StandardProtocolFamily.INET), new OptionKey(0, NetinetIn.IP_TOS.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_IF, StandardProtocolFamily.INET), new OptionKey(0, NetinetIn.IP_MULTICAST_IF.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_TTL, StandardProtocolFamily.INET), new OptionKey(0, NetinetIn.IP_MULTICAST_TTL.intValue()));
            map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_LOOP, StandardProtocolFamily.INET), new OptionKey(0, NetinetIn.IP_MULTICAST_LOOP.intValue()));
            if (CNative.defined((CNative.object)SysSocket.AF_INET6)) {
                map.put(new RegistryKey(StandardSocketOptions.IP_TOS, StandardProtocolFamily.INET6), new OptionKey(41, NetinetIn.IPV6_TCLASS.intValue()));
                map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_IF, StandardProtocolFamily.INET6), new OptionKey(41, NetinetIn.IPV6_MULTICAST_IF.intValue()));
                map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_TTL, StandardProtocolFamily.INET6), new OptionKey(41, NetinetIn.IPV6_MULTICAST_HOPS.intValue()));
                map.put(new RegistryKey(StandardSocketOptions.IP_MULTICAST_LOOP, StandardProtocolFamily.INET6), new OptionKey(41, NetinetIn.IPV6_MULTICAST_LOOP.intValue()));
            }
            map.put(new RegistryKey(ExtendedSocketOption.SO_OOBINLINE, Net.UNSPEC), new OptionKey(SysSocket.SOL_SOCKET.intValue(), SysSocket.SO_OOBINLINE.intValue()));
            return map;
        }
    }
}

