/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import jdk.internal.misc.Unsafe;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.PipeImpl;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.SocketChannelImpl;

class WindowsSelectorImpl
extends SelectorImpl {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static int addressSize = unsafe.addressSize();
    private final int INIT_CAP = 8;
    private static final int MAX_SELECTABLE_FDS = 1024;
    private static final long SIZEOF_FD_SET = WindowsSelectorImpl.dependsArch(4100, 8200);
    private SelectionKeyImpl[] channelArray = new SelectionKeyImpl[8];
    private PollArrayWrapper pollWrapper;
    private int totalChannels = 1;
    private int threadsCount = 0;
    private final List<SelectThread> threads = new ArrayList<SelectThread>();
    private final Pipe wakeupPipe;
    private final int wakeupSourceFd;
    private final int wakeupSinkFd;
    private final FdMap fdMap = new FdMap();
    private final SubSelector subSelector = new SubSelector();
    private long timeout;
    private final Object interruptLock = new Object();
    private volatile boolean interruptTriggered;
    private final Object updateLock = new Object();
    private final Deque<SelectionKeyImpl> newKeys = new ArrayDeque<SelectionKeyImpl>();
    private final Deque<SelectionKeyImpl> updateKeys = new ArrayDeque<SelectionKeyImpl>();
    private final StartLock startLock = new StartLock();
    private final FinishLock finishLock = new FinishLock();
    private long updateCount = 0L;

    private static int dependsArch(int value32, int value64) {
        return addressSize == 4 ? value32 : value64;
    }

    WindowsSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.pollWrapper = new PollArrayWrapper(8);
        this.wakeupPipe = new PipeImpl(sp, false);
        this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
        this.wakeupSinkFd = ((SelChImpl)((Object)this.wakeupPipe.sink())).getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(Consumer<SelectionKey> action, long timeout) throws IOException {
        assert (Thread.holdsLock(this));
        this.timeout = timeout;
        this.processUpdateQueue();
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        this.adjustThreadsCount();
        this.finishLock.reset();
        this.startLock.startThreads();
        try {
            this.begin();
            try {
                this.subSelector.poll();
            }
            catch (IOException e) {
                this.finishLock.setException(e);
            }
            if (this.threads.size() > 0) {
                this.finishLock.waitForHelperThreads();
            }
        }
        finally {
            this.end();
        }
        this.finishLock.checkForException();
        this.processDeregisterQueue();
        int updated = this.updateSelectedKeys(action);
        this.resetWakeupSocket();
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateQueue() {
        assert (Thread.holdsLock(this));
        Object object2 = this.updateLock;
        synchronized (object2) {
            SelectionKeyImpl ski;
            while ((ski = this.newKeys.pollFirst()) != null) {
                if (!ski.isValid()) continue;
                this.growIfNeeded();
                this.channelArray[this.totalChannels] = ski;
                ski.setIndex(this.totalChannels);
                this.pollWrapper.putEntry(this.totalChannels, ski);
                ++this.totalChannels;
                MapEntry previous = this.fdMap.put(ski);
                assert (previous == null);
            }
            while ((ski = this.updateKeys.pollFirst()) != null) {
                int events = ski.translateInterestOps();
                int fd = ski.getFDVal();
                if (!ski.isValid() || !this.fdMap.containsKey(fd)) continue;
                int index = ski.getIndex();
                assert (index >= 0 && index < this.totalChannels);
                this.pollWrapper.putEventOps(index, events);
            }
        }
    }

    private void adjustThreadsCount() {
        block3: {
            block2: {
                if (this.threadsCount <= this.threads.size()) break block2;
                for (int i = this.threads.size(); i < this.threadsCount; ++i) {
                    SelectThread newThread = new SelectThread(i);
                    this.threads.add(newThread);
                    newThread.setDaemon(true);
                    newThread.start();
                }
                break block3;
            }
            if (this.threadsCount >= this.threads.size()) break block3;
            for (int i = this.threads.size() - 1; i >= this.threadsCount; --i) {
                this.threads.remove(i).makeZombie();
            }
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void setWakeupSocket0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object2 = this.interruptLock;
        synchronized (object2) {
            if (!this.interruptTriggered) {
                return;
            }
            this.resetWakeupSocket0(this.wakeupSourceFd);
            this.interruptTriggered = false;
        }
    }

    private native void resetWakeupSocket0(int var1);

    private int updateSelectedKeys(Consumer<SelectionKey> action) throws IOException {
        ++this.updateCount;
        int numKeysUpdated = 0;
        numKeysUpdated += this.subSelector.processSelectedKeys(this.updateCount, action);
        for (SelectThread t : this.threads) {
            numKeysUpdated += t.subSelector.processSelectedKeys(this.updateCount, action);
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        assert (!this.isOpen());
        assert (Thread.holdsLock(this));
        Iterator<SelectThread> iterator = this.interruptLock;
        synchronized (iterator) {
            this.interruptTriggered = true;
        }
        this.wakeupPipe.sink().close();
        this.wakeupPipe.source().close();
        this.pollWrapper.free();
        for (SelectThread t : this.threads) {
            t.makeZombie();
        }
        this.startLock.startThreads();
        this.subSelector.freeFDSetBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        this.ensureOpen();
        Object object2 = this.updateLock;
        synchronized (object2) {
            this.newKeys.addLast(ski);
        }
    }

    private void growIfNeeded() {
        if (this.channelArray.length == this.totalChannels) {
            int newSize = this.totalChannels * 2;
            SelectionKeyImpl[] temp = new SelectionKeyImpl[newSize];
            System.arraycopy(this.channelArray, 1, temp, 1, this.totalChannels - 1);
            this.channelArray = temp;
            this.pollWrapper.grow(newSize);
        }
        if (this.totalChannels % 1024 == 0) {
            this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, this.totalChannels);
            ++this.totalChannels;
            ++this.threadsCount;
        }
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) {
        assert (!ski.isValid());
        assert (Thread.holdsLock(this));
        if (this.fdMap.remove(ski) != null) {
            int i = ski.getIndex();
            assert (i >= 0);
            if (i != this.totalChannels - 1) {
                SelectionKeyImpl endChannel;
                this.channelArray[i] = endChannel = this.channelArray[this.totalChannels - 1];
                endChannel.setIndex(i);
                this.pollWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, i);
            }
            ski.setIndex(-1);
            this.channelArray[this.totalChannels - 1] = null;
            --this.totalChannels;
            if (this.totalChannels != 1 && this.totalChannels % 1024 == 1) {
                --this.totalChannels;
                --this.threadsCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventOps(SelectionKeyImpl ski) {
        this.ensureOpen();
        Object object2 = this.updateLock;
        synchronized (object2) {
            this.updateKeys.addLast(ski);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object2 = this.interruptLock;
        synchronized (object2) {
            if (!this.interruptTriggered) {
                this.setWakeupSocket();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        IOUtil.load();
    }

    private static final class FdMap
    extends HashMap<Integer, MapEntry> {
        static final long serialVersionUID = 0L;

        private FdMap() {
        }

        private MapEntry get(int desc) {
            return (MapEntry)this.get((Object)desc);
        }

        private MapEntry put(SelectionKeyImpl ski) {
            return this.put(ski.getFDVal(), new MapEntry(ski));
        }

        private MapEntry remove(SelectionKeyImpl ski) {
            Integer fd = ski.getFDVal();
            MapEntry x = (MapEntry)this.get(fd);
            if (x != null && x.ski.channel() == ski.channel()) {
                return (MapEntry)this.remove(fd);
            }
            return null;
        }
    }

    private final class SubSelector {
        private final int pollArrayIndex;
        private final int[] readFds = new int[1025];
        private final int[] writeFds = new int[1025];
        private final int[] exceptFds = new int[1025];
        private final long fdsBuffer = unsafe.allocateMemory(SIZEOF_FD_SET * 3L);

        private SubSelector() {
            this.pollArrayIndex = 0;
        }

        private SubSelector(int threadIndex) {
            this.pollArrayIndex = (threadIndex + 1) * 1024;
        }

        private int poll() throws IOException {
            return this.poll0(WindowsSelectorImpl.this.pollWrapper.pollArrayAddress, Math.min(WindowsSelectorImpl.this.totalChannels, 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout, this.fdsBuffer);
        }

        private int poll(int index) throws IOException {
            return this.poll0(WindowsSelectorImpl.this.pollWrapper.pollArrayAddress + (long)(this.pollArrayIndex * PollArrayWrapper.SIZE_POLLFD), Math.min(1024, WindowsSelectorImpl.this.totalChannels - (index + 1) * 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout, this.fdsBuffer);
        }

        private native int poll0(long var1, int var3, int[] var4, int[] var5, int[] var6, long var7, long var9);

        private int processSelectedKeys(long updateCount, Consumer<SelectionKey> action) throws IOException {
            int numKeysUpdated = 0;
            numKeysUpdated += this.processFDSet(updateCount, action, this.readFds, Net.POLLIN, false);
            numKeysUpdated += this.processFDSet(updateCount, action, this.writeFds, Net.POLLCONN | Net.POLLOUT, false);
            return numKeysUpdated += this.processFDSet(updateCount, action, this.exceptFds, Net.POLLIN | Net.POLLCONN | Net.POLLOUT, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int processFDSet(long updateCount, Consumer<SelectionKey> action, int[] fds, int rOps, boolean isExceptFds) throws IOException {
            int numKeysUpdated = 0;
            for (int i = 1; i <= fds[0]; ++i) {
                int updated;
                int desc = fds[i];
                if (desc == WindowsSelectorImpl.this.wakeupSourceFd) {
                    Object object2 = WindowsSelectorImpl.this.interruptLock;
                    synchronized (object2) {
                        WindowsSelectorImpl.this.interruptTriggered = true;
                        continue;
                    }
                }
                MapEntry me = WindowsSelectorImpl.this.fdMap.get(desc);
                if (me == null) continue;
                SelectionKeyImpl ski = me.ski;
                SelectableChannel sc = ski.channel();
                if (isExceptFds && sc instanceof SocketChannelImpl && ((SocketChannelImpl)sc).isNetSocket() && Net.discardOOB(ski.getFD()) || (updated = WindowsSelectorImpl.this.processReadyEvents(rOps, ski, action)) <= 0 || me.updateCount == updateCount) continue;
                me.updateCount = updateCount;
                ++numKeysUpdated;
            }
            return numKeysUpdated;
        }

        private void freeFDSetBuffer() {
            unsafe.freeMemory(this.fdsBuffer);
        }
    }

    private final class StartLock {
        private long runsCounter;

        private StartLock() {
        }

        private synchronized void startThreads() {
            ++this.runsCounter;
            this.notifyAll();
        }

        private synchronized boolean waitForStart(SelectThread thread) {
            while (this.runsCounter == thread.lastRun) {
                try {
                    WindowsSelectorImpl.this.startLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (thread.isZombie()) {
                return true;
            }
            thread.lastRun = this.runsCounter;
            return false;
        }
    }

    private final class FinishLock {
        private int threadsToFinish;
        IOException exception = null;

        private FinishLock() {
        }

        private void reset() {
            this.threadsToFinish = WindowsSelectorImpl.this.threads.size();
        }

        private synchronized void threadFinished() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            --this.threadsToFinish;
            if (this.threadsToFinish == 0) {
                this.notify();
            }
        }

        private synchronized void waitForHelperThreads() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            while (this.threadsToFinish != 0) {
                try {
                    WindowsSelectorImpl.this.finishLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void setException(IOException e) {
            this.exception = e;
        }

        private void checkForException() throws IOException {
            if (this.exception == null) {
                return;
            }
            String message = "An exception occurred during the execution of select(): \n" + this.exception + '\n';
            this.exception = null;
            throw new IOException(message);
        }
    }

    private static final class MapEntry {
        final SelectionKeyImpl ski;
        long updateCount = 0L;

        MapEntry(SelectionKeyImpl ski) {
            this.ski = ski;
        }
    }

    private final class SelectThread
    extends Thread {
        private final int index;
        final SubSelector subSelector;
        private long lastRun;
        private volatile boolean zombie;

        private SelectThread(int i) {
            super(null, null, "SelectorHelper", 0L, false);
            this.lastRun = 0L;
            this.index = i;
            this.subSelector = new SubSelector(i);
            this.lastRun = WindowsSelectorImpl.this.startLock.runsCounter;
        }

        void makeZombie() {
            this.zombie = true;
        }

        boolean isZombie() {
            return this.zombie;
        }

        @Override
        public void run() {
            while (true) {
                if (WindowsSelectorImpl.this.startLock.waitForStart(this)) {
                    this.subSelector.freeFDSetBuffer();
                    return;
                }
                try {
                    this.subSelector.poll(this.index);
                }
                catch (IOException e) {
                    WindowsSelectorImpl.this.finishLock.setException(e);
                }
                WindowsSelectorImpl.this.finishLock.threadFinished();
            }
        }
    }
}

