/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class CESU_8
extends Unicode {
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();

    public CESU_8() {
        super("CESU-8", StandardCharsets.aliases_CESU_8());
    }

    @Override
    public String historicalName() {
        return "CESU8";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final void updatePositions(Buffer src, int sp, Buffer dst, int dp) {
        src.position(sp - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int b) {
            return (b & 0xC0) != 128;
        }

        private static boolean isMalformed3(int b1, int b2, int b3) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
        }

        private static boolean isMalformed3_2(int b1, int b2) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
        }

        private static CoderResult malformedN(ByteBuffer src, int nb) {
            switch (nb) {
                case 1: 
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte b1 = src.get();
                    byte b2 = src.get();
                    return CoderResult.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || Decoder.isNotContinuation(b2) ? 1 : 2);
                }
                case 4: {
                    int b1 = src.get() & 0xFF;
                    int b2 = src.get() & 0xFF;
                    if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || Decoder.isNotContinuation(b2)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(src.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
            src.position(sp - src.arrayOffset());
            CoderResult cr = Decoder.malformedN(src, nb);
            CESU_8.updatePositions(src, sp, dst, dp);
            return cr;
        }

        private static CoderResult malformed(ByteBuffer src, int mark, int nb) {
            src.position(mark);
            CoderResult cr = Decoder.malformedN(src, nb);
            src.position(mark);
            return cr;
        }

        private static CoderResult malformedForLength(ByteBuffer src, int sp, CharBuffer dst, int dp, int malformedNB) {
            CESU_8.updatePositions(src, sp, dst, dp);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult malformedForLength(ByteBuffer src, int mark, int malformedNB) {
            src.position(mark);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult xflow(Buffer src, int sp, int sl, Buffer dst, int dp, int nb) {
            CESU_8.updatePositions(src, sp, dst, dp);
            return nb == 0 || sl - sp < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer src, int mark, int nb) {
            src.position(mark);
            return nb == 0 || src.remaining() < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.position();
            int sl = soff + src.limit();
            char[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.position();
            int dl = doff + dst.limit();
            int n = JLA.decodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            sp += n;
            dp += n;
            while (sp < sl) {
                byte b1 = sa[sp];
                if (b1 >= 0) {
                    if (dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 1);
                    }
                    da[dp++] = (char)b1;
                    ++sp;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sl - sp < 2 || dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 2);
                    }
                    byte b2 = sa[sp + 1];
                    if (Decoder.isNotContinuation(b2)) {
                        return Decoder.malformedForLength(src, sp, dst, dp, 1);
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    sp += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    int srcRemaining = sl - sp;
                    if (srcRemaining < 3 || dp >= dl) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, sa[sp + 1])) {
                            return Decoder.malformedForLength(src, sp, dst, dp, 1);
                        }
                        return Decoder.xflow(src, sp, sl, dst, dp, 3);
                    }
                    byte b2 = sa[sp + 1];
                    byte b3 = sa[sp + 2];
                    if (Decoder.isMalformed3(b1, b2, b3)) {
                        return Decoder.malformed(src, sp, dst, dp, 3);
                    }
                    da[dp++] = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    sp += 3;
                    continue;
                }
                return Decoder.malformed(src, sp, dst, dp, 1);
            }
            return Decoder.xflow(src, sp, sl, dst, dp, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            int limit = src.limit();
            while (mark < limit) {
                byte b1 = src.get();
                if (b1 >= 0) {
                    if (dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 1);
                    }
                    dst.put((char)b1);
                    ++mark;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (limit - mark < 2 || dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 2);
                    }
                    byte b2 = src.get();
                    if (Decoder.isNotContinuation(b2)) {
                        return Decoder.malformedForLength(src, mark, 1);
                    }
                    dst.put((char)(b1 << 6 ^ b2 ^ 0xF80));
                    mark += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    byte b3;
                    int srcRemaining = limit - mark;
                    if (srcRemaining < 3 || dst.remaining() < 1) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, src.get())) {
                            return Decoder.malformedForLength(src, mark, 1);
                        }
                        return Decoder.xflow(src, mark, 3);
                    }
                    byte b2 = src.get();
                    if (Decoder.isMalformed3(b1, b2, b3 = src.get())) {
                        return Decoder.malformed(src, mark, 3);
                    }
                    dst.put((char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80)));
                    mark += 3;
                    continue;
                }
                return Decoder.malformed(src, mark, 1);
            }
            return Decoder.xflow(src, mark, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        private static ByteBuffer getByteBuffer(ByteBuffer bb, byte[] ba, int sp) {
            if (bb == null) {
                bb = ByteBuffer.wrap(ba);
            }
            bb.position(sp);
            return bb;
        }

        @Override
        public int decode(byte[] sa, int sp, int len, char[] da) {
            int sl = sp + len;
            int dp = 0;
            int dlASCII = Math.min(len, da.length);
            ByteBuffer bb = null;
            while (dp < dlASCII && sa[sp] >= 0) {
                da[dp++] = (char)sa[sp++];
            }
            while (sp < sl) {
                byte b2;
                byte b1;
                if ((b1 = sa[sp++]) >= 0) {
                    da[dp++] = (char)b1;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sp < sl) {
                        if (Decoder.isNotContinuation(b2 = sa[sp++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            --sp;
                            continue;
                        }
                        da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    da[dp++] = this.replacement().charAt(0);
                    return dp;
                }
                if (b1 >> 4 == -2) {
                    if (sp + 1 < sl) {
                        byte b3;
                        if (Decoder.isMalformed3(b1, b2 = sa[sp++], b3 = sa[sp++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            bb = Decoder.getByteBuffer(bb, sa, sp -= 3);
                            sp += Decoder.malformedN(bb, 3).length();
                            continue;
                        }
                        da[dp++] = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (sp < sl && Decoder.isMalformed3_2(b1, sa[sp])) {
                        da[dp++] = this.replacement().charAt(0);
                        continue;
                    }
                    da[dp++] = this.replacement().charAt(0);
                    return dp;
                }
                if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                    return -1;
                }
                da[dp++] = this.replacement().charAt(0);
            }
            return dp;
        }
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;

        private Encoder(Charset cs) {
            super(cs, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] >= 0 || super.isLegalReplacement(repl);
        }

        private static CoderResult overflow(CharBuffer src, int sp, ByteBuffer dst, int dp) {
            CESU_8.updatePositions(src, sp, dst, dp);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer src, int mark) {
            src.position(mark);
            return CoderResult.OVERFLOW;
        }

        private static void to3Bytes(byte[] da, int dp, char c) {
            da[dp] = (byte)(0xE0 | c >> 12);
            da[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            da[dp + 2] = (byte)(0x80 | c & 0x3F);
        }

        private static void to3Bytes(ByteBuffer dst, char c) {
            dst.put((byte)(0xE0 | c >> 12));
            dst.put((byte)(0x80 | c >> 6 & 0x3F));
            dst.put((byte)(0x80 | c & 0x3F));
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int n = JLA.encodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            sp += n;
            dp += n;
            while (sp < sl) {
                char c = sa[sp];
                if (c < '\u0080') {
                    if (dp >= dl) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)c;
                } else if (c < '\u0800') {
                    if (dl - dp < 2) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp, sl)) < 0) {
                        CESU_8.updatePositions(src, sp, dst, dp);
                        return this.sgp.error();
                    }
                    if (dl - dp < 6) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    Encoder.to3Bytes(da, dp, Character.highSurrogate(uc));
                    Encoder.to3Bytes(da, dp += 3, Character.lowSurrogate(uc));
                    dp += 3;
                    ++sp;
                } else {
                    if (dl - dp < 3) {
                        return Encoder.overflow(src, sp, dst, dp);
                    }
                    Encoder.to3Bytes(da, dp, c);
                    dp += 3;
                }
                ++sp;
            }
            CESU_8.updatePositions(src, sp, dst, dp);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            while (src.hasRemaining()) {
                char c = src.get();
                if (c < '\u0080') {
                    if (!dst.hasRemaining()) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)c);
                } else if (c < '\u0800') {
                    if (dst.remaining() < 2) {
                        return Encoder.overflow(src, mark);
                    }
                    dst.put((byte)(0xC0 | c >> 6));
                    dst.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, src)) < 0) {
                        src.position(mark);
                        return this.sgp.error();
                    }
                    if (dst.remaining() < 6) {
                        return Encoder.overflow(src, mark);
                    }
                    Encoder.to3Bytes(dst, Character.highSurrogate(uc));
                    Encoder.to3Bytes(dst, Character.lowSurrogate(uc));
                    ++mark;
                } else {
                    if (dst.remaining() < 3) {
                        return Encoder.overflow(src, mark);
                    }
                    Encoder.to3Bytes(dst, c);
                }
                ++mark;
            }
            src.position(mark);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Override
        public int encode(char[] sa, int sp, int len, byte[] da) {
            int sl = sp + len;
            int dp = 0;
            int n = JLA.encodeASCII(sa, sp, da, dp, Math.min(len, da.length));
            sp += n;
            dp += n;
            while (sp < sl) {
                char c;
                if ((c = sa[sp++]) < '\u0080') {
                    da[dp++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp - 1, sl)) < 0) {
                        if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                            return -1;
                        }
                        da[dp++] = this.replacement()[0];
                        continue;
                    }
                    Encoder.to3Bytes(da, dp, Character.highSurrogate(uc));
                    Encoder.to3Bytes(da, dp += 3, Character.lowSurrogate(uc));
                    dp += 3;
                    ++sp;
                    continue;
                }
                Encoder.to3Bytes(da, dp, c);
                dp += 3;
            }
            return dp;
        }
    }
}

