/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.DoubleByte;
import sun.nio.cs.StringUTF16;
import sun.nio.cs.Surrogate;

public class HKSCS {

    public static class Encoder
    extends DoubleByte.Encoder {
        private final DoubleByte.Encoder big5Enc;
        private final char[][] c2bBmp;
        private final char[][] c2bSupp;
        private byte[] repl = this.replacement();
        static char[] C2B_UNMAPPABLE = new char[256];

        protected Encoder(Charset cs, DoubleByte.Encoder big5Enc, char[][] c2bBmp, char[][] c2bSupp) {
            super(cs, null, null, true);
            this.big5Enc = big5Enc;
            this.c2bBmp = c2bBmp;
            this.c2bSupp = c2bSupp;
        }

        public int encodeBig5(char ch) {
            return this.big5Enc.encodeChar(ch);
        }

        @Override
        public int encodeChar(char ch) {
            char bb = this.c2bBmp[ch >> 8][ch & 0xFF];
            if (bb == '\ufffd') {
                return this.encodeBig5(ch);
            }
            return bb;
        }

        public int encodeSupp(int cp) {
            if ((cp & 0xF0000) != 131072) {
                return 65533;
            }
            return this.c2bSupp[cp >> 8 & 0xFF][cp & 0xFF];
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += inSize) {
                    char c = sa[sp];
                    inSize = 1;
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            int cp = this.sgp().parse(c, sa, sp, sl);
                            if (cp < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            bb = this.encodeSupp(cp);
                            if (bb == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            inSize = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (bb > 255) {
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(bb >> 8);
                        da[dp++] = (byte)bb;
                        continue;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (byte)bb;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int inSize = 1;
                    char c = src.get();
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            int cp = this.sgp().parse(c, src);
                            if (cp < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            bb = this.encodeSupp(cp);
                            if (bb == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            inSize = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (bb > 255) {
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)(bb >> 8));
                        dst.put((byte)bb);
                    } else {
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)bb);
                    }
                    mark += inSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Override
        protected void implReplaceWith(byte[] newReplacement) {
            this.repl = newReplacement;
        }

        @Override
        public int encode(char[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int sl = sp + len;
            while (sp < sl) {
                char c;
                int bb;
                if (!((bb = this.encodeChar(c = src[sp++])) != 65533 || Character.isHighSurrogate(c) && sp != sl && Character.isLowSurrogate(src[sp]) && (bb = this.encodeSupp(Character.toCodePoint(c, src[sp++]))) != 65533)) {
                    dst[dp++] = this.repl[0];
                    if (this.repl.length <= 1) continue;
                    dst[dp++] = this.repl[1];
                    continue;
                }
                if (bb > 255) {
                    dst[dp++] = (byte)(bb >> 8);
                    dst[dp++] = (byte)bb;
                    continue;
                }
                dst[dp++] = (byte)bb;
            }
            return dp;
        }

        @Override
        public int encodeFromUTF16(byte[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int sl = sp + len;
            int dl = dst.length;
            while (sp < sl) {
                char c;
                int bb;
                if (!((bb = this.encodeChar(c = StringUTF16.getChar(src, sp++))) != 65533 || Character.isHighSurrogate(c) && sp != sl && Character.isLowSurrogate(StringUTF16.getChar(src, sp)) && (bb = this.encodeSupp(Character.toCodePoint(c, StringUTF16.getChar(src, sp++)))) != 65533)) {
                    dst[dp++] = this.repl[0];
                    if (this.repl.length <= 1) continue;
                    dst[dp++] = this.repl[1];
                    continue;
                }
                if (bb > 255) {
                    dst[dp++] = (byte)(bb >> 8);
                    dst[dp++] = (byte)bb;
                    continue;
                }
                dst[dp++] = (byte)bb;
            }
            return dp;
        }

        public static void initc2b(char[][] c2b, String[] b2cStr, String pua) {
            int b2Min = 64;
            Arrays.fill((Object[])c2b, C2B_UNMAPPABLE);
            for (int b1 = 0; b1 < 256; ++b1) {
                String s = b2cStr[b1];
                if (s == null) continue;
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '\ufffd') continue;
                    int hi = c >> 8;
                    if (c2b[hi] == C2B_UNMAPPABLE) {
                        c2b[hi] = new char[256];
                        Arrays.fill(c2b[hi], '\ufffd');
                    }
                    c2b[hi][c & 0xFF] = (char)(b1 << 8 | i + b2Min);
                }
            }
            if (pua != null) {
                int c = 57344;
                for (int i = 0; i < pua.length(); ++i) {
                    char bb = pua.charAt(i);
                    if (bb != '\ufffd') {
                        int hi = c >> 8;
                        if (c2b[hi] == C2B_UNMAPPABLE) {
                            c2b[hi] = new char[256];
                            Arrays.fill(c2b[hi], '\ufffd');
                        }
                        c2b[hi][c & 0xFF] = bb;
                    }
                    c = (char)(c + 1);
                }
            }
        }

        static {
            Arrays.fill(C2B_UNMAPPABLE, '\ufffd');
        }
    }

    public static class Decoder
    extends DoubleByte.Decoder {
        static int b2Min = 64;
        static int b2Max = 254;
        private final char[][] b2cBmp;
        private final char[][] b2cSupp;
        private final DoubleByte.Decoder big5Dec;

        protected Decoder(Charset cs, DoubleByte.Decoder big5Dec, char[][] b2cBmp, char[][] b2cSupp) {
            super(cs, 0.5f, 1.0f, null, null, 0, 0, true);
            this.big5Dec = big5Dec;
            this.b2cBmp = b2cBmp;
            this.b2cSupp = b2cSupp;
        }

        @Override
        public char decodeSingle(int b) {
            return this.big5Dec.decodeSingle(b);
        }

        public char decodeBig5(int b1, int b2) {
            return this.big5Dec.decodeDouble(b1, b2);
        }

        @Override
        public char decodeDouble(int b1, int b2) {
            return this.b2cBmp[b1][b2 - b2Min];
        }

        public char decodeDoubleEx(int b1, int b2) {
            return this.b2cSupp[b1][b2 - b2Min];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += inSize) {
                    int b1 = sa[sp] & 0xFF;
                    char c = this.decodeSingle(b1);
                    inSize = 1;
                    int outSize = 1;
                    if (c == '\ufffd') {
                        if (sl - sp < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = sa[sp + 1] & 0xFF;
                        ++inSize;
                        if (b2 < b2Min || b2 > b2Max) {
                            CoderResult coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        c = this.decodeDouble(b1, b2);
                        if (c == '\ufffd') {
                            c = this.decodeDoubleEx(b1, b2);
                            if (c == '\ufffd') {
                                c = this.decodeBig5(b1, b2);
                                if (c == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                            } else {
                                outSize = 2;
                            }
                        }
                    }
                    if (dl - dp < outSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (outSize == 2) {
                        da[dp++] = Surrogate.high(131072 + c);
                        da[dp++] = Surrogate.low(131072 + c);
                        continue;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int b1 = src.get() & 0xFF;
                    int inSize = 1;
                    int outSize = 1;
                    char c = this.decodeSingle(b1);
                    if (c == '\ufffd') {
                        if (src.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = src.get() & 0xFF;
                        ++inSize;
                        if (b2 < b2Min || b2 > b2Max) {
                            CoderResult coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        c = this.decodeDouble(b1, b2);
                        if (c == '\ufffd') {
                            c = this.decodeDoubleEx(b1, b2);
                            if (c == '\ufffd') {
                                c = this.decodeBig5(b1, b2);
                                if (c == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                            } else {
                                outSize = 2;
                            }
                        }
                    }
                    if (dst.remaining() < outSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (outSize == 2) {
                        dst.put(Surrogate.high(131072 + c));
                        dst.put(Surrogate.low(131072 + c));
                    } else {
                        dst.put(c);
                    }
                    mark += inSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        public int decode(byte[] src, int sp, int len, char[] dst) {
            int dp = 0;
            int sl = sp + len;
            char repl = this.replacement().charAt(0);
            while (sp < sl) {
                int b1;
                char c;
                if ((c = this.decodeSingle(b1 = src[sp++] & 0xFF)) == '\ufffd') {
                    int b2;
                    if (sl == sp) {
                        c = repl;
                    } else if ((b2 = src[sp++] & 0xFF) < b2Min || b2 > b2Max) {
                        c = repl;
                    } else {
                        c = this.decodeDouble(b1, b2);
                        if (c == '\ufffd') {
                            c = this.decodeDoubleEx(b1, b2);
                            if (c == '\ufffd') {
                                c = this.decodeBig5(b1, b2);
                                if (c == '\ufffd') {
                                    c = repl;
                                }
                            } else {
                                dst[dp++] = Surrogate.high(131072 + c);
                                dst[dp++] = Surrogate.low(131072 + c);
                                continue;
                            }
                        }
                    }
                }
                dst[dp++] = c;
            }
            return dp;
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        public static void initb2c(char[][] b2c, String[] b2cStr) {
            for (int i = 0; i < b2cStr.length; ++i) {
                b2c[i] = b2cStr[i] == null ? DoubleByte.B2C_UNMAPPABLE : b2cStr[i].toCharArray();
            }
        }
    }
}

