/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class UnicodeDecoder
extends CharsetDecoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;
    private final int expectedByteOrder;
    private int currentByteOrder;
    private int defaultByteOrder = 1;

    public UnicodeDecoder(Charset cs, int bo) {
        super(cs, 0.5f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = bo;
    }

    public UnicodeDecoder(Charset cs, int bo, int defaultBO) {
        this(cs, bo);
        this.defaultByteOrder = defaultBO;
    }

    private char decode(int b1, int b2) {
        if (this.currentByteOrder == 1) {
            return (char)(b1 << 8 | b2);
        }
        return (char)(b2 << 8 | b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        try {
            while (src.remaining() > 1) {
                char c;
                int b1 = src.get() & 0xFF;
                int b2 = src.get() & 0xFF;
                if (this.currentByteOrder == 0) {
                    c = (char)(b1 << 8 | b2);
                    if (c == '\ufeff') {
                        this.currentByteOrder = 1;
                        mark += 2;
                        continue;
                    }
                    if (c == '\ufffe') {
                        this.currentByteOrder = 2;
                        mark += 2;
                        continue;
                    }
                    this.currentByteOrder = this.defaultByteOrder;
                }
                if (Character.isSurrogate(c = this.decode(b1, b2))) {
                    if (Character.isHighSurrogate(c)) {
                        if (src.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        char c2 = this.decode(src.get() & 0xFF, src.get() & 0xFF);
                        if (!Character.isLowSurrogate(c2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(4);
                            return coderResult;
                        }
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        mark += 4;
                        dst.put(c);
                        dst.put(c2);
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                mark += 2;
                dst.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    @Override
    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

