/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

public abstract class AbstractFileSystemProvider
extends FileSystemProvider {
    protected AbstractFileSystemProvider() {
    }

    private static String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos++);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos);
        }
        return s;
    }

    abstract DynamicFileAttributeView getFileAttributeView(Path var1, String var2, LinkOption ... var3);

    @Override
    public final void setAttribute(Path file, String attribute, Object value, LinkOption ... options) throws IOException {
        String[] s = AbstractFileSystemProvider.split(attribute);
        if (s[0].isEmpty()) {
            throw new IllegalArgumentException(attribute);
        }
        DynamicFileAttributeView view = this.getFileAttributeView(file, s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(s[1], value);
    }

    @Override
    public final Map<String, Object> readAttributes(Path file, String attributes, LinkOption ... options) throws IOException {
        String[] s = AbstractFileSystemProvider.split(attributes);
        if (s[0].isEmpty()) {
            throw new IllegalArgumentException(attributes);
        }
        DynamicFileAttributeView view = this.getFileAttributeView(file, s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    abstract boolean implDelete(Path var1, boolean var2) throws IOException;

    @Override
    public final void delete(Path file) throws IOException {
        this.implDelete(file, true);
    }

    @Override
    public final boolean deleteIfExists(Path file) throws IOException {
        return this.implDelete(file, false);
    }

    public boolean isDirectory(Path file) {
        try {
            return this.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).isDirectory();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean isRegularFile(Path file) {
        try {
            return this.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).isRegularFile();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean exists(Path file) {
        try {
            this.checkAccess(file, new AccessMode[0]);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public abstract byte[] getSunPathForSocketFile(Path var1);
}

